/*
 * Decompiled with CFR 0.152.
 */
package server;

import com.netflix.msl.crypto.ICryptoContext;
import com.netflix.msl.crypto.SymmetricCryptoContext;
import com.netflix.msl.entityauth.RsaStore;
import com.netflix.msl.msg.ConsoleFilterStreamFactory;
import com.netflix.msl.msg.ErrorHeader;
import com.netflix.msl.msg.FilterStreamFactory;
import com.netflix.msl.msg.MessageContext;
import com.netflix.msl.msg.MessageInputStream;
import com.netflix.msl.msg.MslControl;
import com.netflix.msl.userauth.EmailPasswordStore;
import com.netflix.msl.util.MslContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.json.JSONObject;
import server.SimpleConstants;
import server.entityauth.SimpleRsaStore;
import server.msg.SimpleReceiveMessageContext;
import server.msg.SimpleRequest;
import server.msg.SimpleRespondMessageContext;
import server.userauth.SimpleEmailPasswordStore;
import server.userauth.SimpleUser;
import server.util.SimpleMslContext;

public class SimpleServlet
extends HttpServlet {
    private static final long serialVersionUID = -4593207843035538485L;
    private static final String NEWLINE = System.lineSeparator();
    private static final String ST_KEYSET_ID = "serviceTokenKeySetId";
    private static final byte[] ST_ENCRYPTION_KEY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final byte[] ST_HMAC_KEY = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static boolean QUIT = false;
    private final MslContext ctx;
    private final MslControl ctrl;
    private final Map<String, ICryptoContext> cryptoContexts = new HashMap();

    public SimpleServlet() {
        SimpleRsaStore rsaStore;
        try {
            byte[] privKeyEncoded = DatatypeConverter.parseBase64Binary((String)"MIIEowIBAAKCAQEA4feorj/FWQi8AhbvjK3GL31ct6N+Ad/3FwqNsa4vAsfPmilLRx0DWhkxRycetmQEAa+1THyNCzobIduQE3UY8NtdOiy1S3BtHDoiSNEITFPAs0l2OAZ2ZUv0KIr9sLWAznlXMclLOBXtLOQMCs2eEy4MO1m9uLywwc2SuAfoZe+wjEIauyoQK/M5miA0fbaEn4H+3m5aiP3Lb1X5Ss4b4tuu0ENsO/ebgMx2ltZ4b9dkzA65DM6XxEC60jK1AW+/wvFb4+iPQqrA7mdiZWspzqMRTaAUDHKJo2LFBc6N0/wuTsXczHx6TYz5b2hrI6N+O7EEuxirAaU+xU7XEqv2dQIDAQABAoIBAQCh/pEv8knBbXCTMuwi90VYMFAy2oNwRqZ2Hzu7gHr1TFd5VldAMP2BLwRT1SjAau0wZE3d+oCG5u4ilKwyNsVdjnXESd7iqUOfc9G2UBzZ00UXgve8bG2eaxgrpJEAiO5Bl126NGu3VojEoOw9JnFHoMBmIAzSDnvNRFoFkq25vQYAG45l9ZeNJv8mJaJG5+DNr6xbAE5PmROcqyDL7RrfSqLxALhgZzLjVAP99fBGpOw2dCGKbQRzkUY0bojO19G3UUtf3HCI005ikYHuAPdvu4+AteOvKdnDeMcT1pDxiNZKO+kXumIGYaKul2k6t9UpsRvCSmrthFZxt8izGEehAoGBAPJ7YiK6W6NrgVyW5PaDtDRTrwZb/1G/K+jvCzHhV8/X5KfmjsaAkT5m2WS1/rMwJoyc45GmTyyy6reGqLs5zAdUVicRKjZZaQnj00QXHRlmAEiDtx2Tb0cagryVf79Ma5FgyOMmqHjS5Pob7RvI4UyzVhR/pYmOrqxWGZgmRlxNAoGBAO6QlfXvbL9JKZ3HXIVbrXS5QToACnQf19QH05LPJG4jni7ycoTZFOiFmJodP5ca+GugTLlPaeVu52dlbXM1k32tV+0ui6vn0ErE8ZsXTjbZ/KInx4munWrLP8w3Ju8MHPPlsEgmeggL0xBtt5BFRKus0SWwImZ9rIzxFXdbanbJAoGAOrP4LCQlr0iFht7ZC30TEV/5DXcUNrwrazcD5M2DLsQ7jRJaGmBhyVOo6aLNyJ+tlXkd9tLmdBHUlR26l6kEZfna6ZZUO9glf8lyChf2aYGyK9wHZtecpwAaCoG+7ZcYq5dcyvE+9BFKcep02rclJCZ+fnPwpX6vdvVZOOZ7PjkCgYAGMv2imWkjA1ywe+i8kmhMey/luPCMmfM60EVAMF/K+OP4ZlZxe06eyDHx90aav5mq+kxkGFsxGhOrTSht8Pt3LZT2VdpNSkXQW5PHqvBeXoXBFPWLb10p1ERBI0HAvnjWIabWCSHsqZn/eEpn1lT1fRUmPJB4R1W/h9g99MMseQKBgBVp+6dU2Rdf1jzwzDH3IRDIVgWeqLlQucbVr/Fipjooioq6nxH2oHUB2Qmq7FjYLKfKdaIRRoJhgeUhjVOVdjyIKVhLlBYpztr48jrMD5e4ykvKdAV2tlNvB/b+6sSJkqh7Qm6CMO29m+dE2PJBZCzviTkBMOzyme71phGsh//C");
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privKeyEncoded);
            KeyFactory rsaKeyFactory = KeyFactory.getInstance("RSA");
            PrivateKey privKey = rsaKeyFactory.generatePrivate(privKeySpec);
            rsaStore = new SimpleRsaStore("SimpleMslServer", null, privKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("RSA algorithm not found.", e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException("Invalid RSA private key.", e);
        }
        HashMap<String, String> emailPasswords = new HashMap<String, String>();
        for (String[] emailPassword : SimpleConstants.EMAIL_PASSWORDS) {
            emailPasswords.put(emailPassword[0], emailPassword[1]);
        }
        SimpleEmailPasswordStore emailPasswordStore = new SimpleEmailPasswordStore(emailPasswords);
        this.ctx = new SimpleMslContext("SimpleMslServer", (RsaStore)rsaStore, (EmailPasswordStore)emailPasswordStore);
        this.ctrl = new MslControl(0);
        this.ctrl.setFilterFactory((FilterStreamFactory)new ConsoleFilterStreamFactory());
        SecretKeySpec encryptionKey = new SecretKeySpec(ST_ENCRYPTION_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(ST_HMAC_KEY, "HmacSHA256");
        SymmetricCryptoContext stCryptoContext = new SymmetricCryptoContext(this.ctx, ST_KEYSET_ID, (SecretKey)encryptionKey, (SecretKey)hmacKey, null);
        this.cryptoContexts.put("", stCryptoContext);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SimpleRespondMessageContext responseMsgCtx;
        MessageInputStream request;
        resp.setHeader("Access-Control-Allow-Origin", "*");
        if (QUIT) {
            System.out.println("Returning 401.");
            resp.sendError(410, "MSL servlet terminated.");
            return;
        }
        SimpleReceiveMessageContext rcvMsgCtx = new SimpleReceiveMessageContext(this.cryptoContexts);
        ServletInputStream in = req.getInputStream();
        ServletOutputStream out = resp.getOutputStream();
        Future requestFuture = this.ctrl.receive(this.ctx, (MessageContext)rcvMsgCtx, (InputStream)in, (OutputStream)out, 120000);
        try {
            request = (MessageInputStream)requestFuture.get();
            if (request == null) {
                return;
            }
        }
        catch (ExecutionException e) {
            e.printStackTrace(System.err);
            return;
        }
        catch (InterruptedException e) {
            System.err.println("MslControl.receive() interrupted.");
            return;
        }
        ErrorHeader error = request.getErrorHeader();
        if (error != null) {
            System.err.println("Unexpectedly received error message: [" + error.getErrorCode() + "][" + error.getInternalCode() + "][" + error.getErrorMessage() + "]");
            return;
        }
        try {
            String identity = request.getIdentity();
            SimpleUser user = (SimpleUser)request.getUser();
            SimpleRequest simpleRequest = SimpleRequest.parse((String)identity, (SimpleUser)user, (MessageInputStream)request, (Map)this.cryptoContexts);
            String requestJson = simpleRequest.toJSONString();
            JSONObject requestJo = new JSONObject(requestJson);
            System.out.println(NEWLINE + "REQUEST" + NEWLINE + "======" + NEWLINE + requestJo.toString(4) + NEWLINE + "======");
            responseMsgCtx = simpleRequest.execute();
            if (SimpleRequest.Type.QUIT.equals((Object)simpleRequest.getType())) {
                QUIT = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseMsgCtx = new SimpleRespondMessageContext(null, true, e.getMessage());
        }
        Future channelFuture = this.ctrl.respond(this.ctx, (MessageContext)responseMsgCtx, (InputStream)in, (OutputStream)out, request, 120000);
        try {
            channelFuture.get();
        }
        catch (ExecutionException e) {
            e.printStackTrace(System.err);
            return;
        }
        catch (InterruptedException e) {
            System.err.println("MslControl.receive() interrupted.");
            return;
        }
        System.out.println(NEWLINE + "RESPONSE" + NEWLINE + "========" + NEWLINE + responseMsgCtx.getData() + NEWLINE + "========");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

