/*
 * Decompiled with CFR 0.152.
 */
package server.msg;

import org.json.JSONException;
import org.json.JSONObject;
import server.msg.SimpleRequest;
import server.msg.SimpleRequestParseException;
import server.msg.SimpleRespondMessageContext;
import server.userauth.SimpleUser;

public class SimpleEchoRequest
extends SimpleRequest {
    private static final String KEY_MESSAGE = "message";
    private final String message;

    public SimpleEchoRequest(String identity, SimpleUser user, JSONObject data) throws SimpleRequestParseException {
        super(SimpleRequest.Type.ECHO, identity, user);
        try {
            this.message = data.getString(KEY_MESSAGE);
        }
        catch (JSONException e) {
            throw new SimpleRequestParseException("Error parsing echo request.", (Throwable)e);
        }
    }

    public JSONObject getData() {
        JSONObject jo = new JSONObject();
        jo.put(KEY_MESSAGE, (Object)this.message);
        return jo;
    }

    public SimpleRespondMessageContext execute() {
        SimpleUser user = this.getUser();
        String username = user != null ? user.toString() : null;
        String data = username + "@" + this.getIdentity() + ": " + this.message;
        return new SimpleRespondMessageContext(this.getIdentity(), true, data);
    }
}

