/*
 * Decompiled with CFR 0.152.
 */
package server.entityauth;

import com.netflix.msl.entityauth.RsaStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class SimpleRsaStore
implements RsaStore {
    private final String serverId;
    private final PublicKey publicKey;
    private final PrivateKey privateKey;

    public SimpleRsaStore(String serverId, PublicKey publicKey, PrivateKey privateKey) {
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public Set<String> getIdentities() {
        return new HashSet<String>(Arrays.asList(this.serverId));
    }

    public PublicKey getPublicKey(String identity) {
        if (this.serverId.equals(identity)) {
            return this.publicKey;
        }
        return null;
    }

    public PrivateKey getPrivateKey(String identity) {
        if (this.serverId.equals(identity)) {
            return this.privateKey;
        }
        return null;
    }
}

