/*
 * Decompiled with CFR 0.152.
 */
package server.msg;

import com.netflix.msl.MslConstants;
import com.netflix.msl.crypto.ICryptoContext;
import com.netflix.msl.tokens.ServiceToken;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import server.msg.SimpleLogRequest;
import server.msg.SimpleRequest;
import server.msg.SimpleRequestParseException;
import server.msg.SimpleRespondMessageContext;
import server.userauth.SimpleUser;

/*
 * Exception performing whole class analysis ignored.
 */
public class SimpleLogRequest
extends SimpleRequest {
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_SEVERITY = "severity";
    private static final String KEY_MESSAGE = "message";
    public static final String SERVICETOKEN_LOGDATA_NAME = "server.logdata";
    private final long timestamp;
    private final Severity severity;
    private final String message;
    private final String logdata;
    private final Map<String, ICryptoContext> cryptoContexts;

    public SimpleLogRequest(String identity, SimpleUser user, JSONObject data, Set<ServiceToken> tokens, Map<String, ICryptoContext> cryptoContexts) throws SimpleRequestParseException {
        super(SimpleRequest.Type.LOG, identity, user);
        String severityString;
        try {
            this.timestamp = data.getLong("timestamp");
            severityString = data.getString("severity");
            this.message = data.getString("message");
        }
        catch (JSONException e) {
            throw new SimpleRequestParseException("Error parsing log request.", (Throwable)e);
        }
        try {
            this.severity = Severity.valueOf((String)severityString);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleRequestParseException("Unknown severity " + severityString + ".", (Throwable)e);
        }
        String logdata = null;
        for (ServiceToken token : tokens) {
            if (!token.isDecrypted() || !"server.logdata".equals(token.getName())) continue;
            logdata = new String(token.getData(), MslConstants.DEFAULT_CHARSET);
            break;
        }
        this.logdata = logdata;
        this.cryptoContexts = Collections.unmodifiableMap(cryptoContexts);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getMessage() {
        return this.message;
    }

    public JSONObject getData() {
        JSONObject jo = new JSONObject();
        jo.put("timestamp", this.timestamp);
        jo.put("severity", (Object)this.severity.name());
        jo.put("message", (Object)this.message);
        return jo;
    }

    public SimpleRespondMessageContext execute() {
        String newMessage = "Log " + this.getUser() + "@" + this.getIdentity() + ": " + new Date(this.timestamp) + " [" + this.severity.name() + "] " + this.message;
        String allMessages = this.logdata != null ? this.logdata + System.lineSeparator() + newMessage : newMessage;
        System.out.println(newMessage);
        HashSet<SimpleRespondMessageContext.Token> tokens = new HashSet<SimpleRespondMessageContext.Token>();
        tokens.add(new SimpleRespondMessageContext.Token("server.logdata", allMessages, true, true));
        return new SimpleRespondMessageContext(this.getIdentity(), false, allMessages, tokens, this.cryptoContexts);
    }
}

