/*
 * Decompiled with CFR 0.152.
 */
package server.userauth;

import com.netflix.msl.MslCryptoException;
import com.netflix.msl.MslEncodingException;
import com.netflix.msl.MslError;
import com.netflix.msl.MslException;
import com.netflix.msl.MslMasterTokenException;
import com.netflix.msl.MslUserIdTokenException;
import com.netflix.msl.entityauth.EntityAuthenticationData;
import com.netflix.msl.tokens.MasterToken;
import com.netflix.msl.tokens.MslUser;
import com.netflix.msl.tokens.TokenFactory;
import com.netflix.msl.tokens.UserIdToken;
import com.netflix.msl.util.JsonUtils;
import com.netflix.msl.util.MslContext;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.SecretKey;
import org.json.JSONObject;
import server.userauth.SimpleUser;

public class SimpleTokenFactory
implements TokenFactory {
    private static final int RENEWAL_OFFSET = 60000;
    private static final int EXPIRATION_OFFSET = 120000;
    private static final long NON_REPLAYABLE_ID_WINDOW = 65536L;
    private final ConcurrentHashMap<String, Long> mtSequenceNumbers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> nonReplayableIds = new ConcurrentHashMap();

    private boolean isNewestMasterToken(MasterToken masterToken) throws MslMasterTokenException {
        if (!masterToken.isDecrypted()) {
            throw new MslMasterTokenException(MslError.MASTERTOKEN_UNTRUSTED, masterToken);
        }
        Long newestSeqNo = (Long)this.mtSequenceNumbers.get(masterToken.getIdentity());
        return newestSeqNo == null || newestSeqNo.longValue() == masterToken.getSequenceNumber();
    }

    public MslError isMasterTokenRevoked(MslContext ctx, MasterToken masterToken) {
        return null;
    }

    public MslError acceptNonReplayableId(MslContext ctx, MasterToken masterToken, long nonReplayableId) throws MslException {
        long cutoff;
        if (!masterToken.isDecrypted()) {
            throw new MslMasterTokenException(MslError.MASTERTOKEN_UNTRUSTED, masterToken);
        }
        if (nonReplayableId < 0L || nonReplayableId > 0x20000000000000L) {
            throw new MslException(MslError.NONREPLAYABLE_ID_OUT_OF_RANGE, "nonReplayableId " + nonReplayableId);
        }
        String key = masterToken.getIdentity() + ":" + masterToken.getSerialNumber();
        Long largestNonReplayableId = (Long)this.nonReplayableIds.get(key);
        if (largestNonReplayableId == null) {
            this.nonReplayableIds.put(key, nonReplayableId);
            return null;
        }
        long catchupWindow = 6L;
        if (nonReplayableId <= largestNonReplayableId && nonReplayableId > largestNonReplayableId - 6L) {
            return MslError.MESSAGE_REPLAYED;
        }
        if (nonReplayableId - 65536L > largestNonReplayableId) {
            return MslError.MESSAGE_REPLAYED_UNRECOVERABLE;
        }
        if (nonReplayableId < largestNonReplayableId && nonReplayableId >= (cutoff = largestNonReplayableId - 0x20000000000000L + 65536L)) {
            return MslError.MESSAGE_REPLAYED_UNRECOVERABLE;
        }
        this.nonReplayableIds.put(key, nonReplayableId);
        return null;
    }

    public MasterToken createMasterToken(MslContext ctx, EntityAuthenticationData entityAuthData, SecretKey encryptionKey, SecretKey hmacKey, JSONObject issuerData) throws MslEncodingException, MslCryptoException {
        java.sql.Date renewalWindow = new java.sql.Date(ctx.getTime() + 60000L);
        java.sql.Date expiration = new java.sql.Date(ctx.getTime() + 120000L);
        long sequenceNumber = 0L;
        long serialNumber = -1L;
        while ((serialNumber = ctx.getRandom().nextLong()) < 0L || serialNumber > 0x20000000000000L) {
        }
        String identity = entityAuthData.getIdentity();
        MasterToken masterToken = new MasterToken(ctx, (Date)renewalWindow, (Date)expiration, 0L, serialNumber, issuerData, identity, encryptionKey, hmacKey);
        this.mtSequenceNumbers.put(identity, 0L);
        return masterToken;
    }

    public MslError isMasterTokenRenewable(MslContext ctx, MasterToken masterToken) throws MslMasterTokenException {
        if (!this.isNewestMasterToken(masterToken)) {
            return MslError.MASTERTOKEN_SEQUENCE_NUMBER_OUT_OF_SYNC;
        }
        return null;
    }

    public MasterToken renewMasterToken(MslContext ctx, MasterToken masterToken, SecretKey encryptionKey, SecretKey hmacKey, JSONObject issuerData) throws MslEncodingException, MslCryptoException, MslMasterTokenException {
        if (!this.isNewestMasterToken(masterToken)) {
            throw new MslMasterTokenException(MslError.MASTERTOKEN_SEQUENCE_NUMBER_OUT_OF_SYNC, masterToken);
        }
        JSONObject mergedIssuerData = JsonUtils.merge((JSONObject)masterToken.getIssuerData(), (JSONObject)issuerData);
        java.sql.Date renewalWindow = new java.sql.Date(ctx.getTime() + 60000L);
        java.sql.Date expiration = new java.sql.Date(ctx.getTime() + 120000L);
        long oldSequenceNumber = masterToken.getSequenceNumber();
        long sequenceNumber = oldSequenceNumber == 0x20000000000000L ? 0L : oldSequenceNumber + 1L;
        long serialNumber = masterToken.getSerialNumber();
        String identity = masterToken.getIdentity();
        MasterToken newMasterToken = new MasterToken(ctx, (Date)renewalWindow, (Date)expiration, sequenceNumber, serialNumber, mergedIssuerData, identity, encryptionKey, hmacKey);
        this.mtSequenceNumbers.put(identity, sequenceNumber);
        return newMasterToken;
    }

    public MslError isUserIdTokenRevoked(MslContext ctx, MasterToken masterToken, UserIdToken userIdToken) {
        return null;
    }

    public UserIdToken createUserIdToken(MslContext ctx, MslUser user, MasterToken masterToken) throws MslEncodingException, MslCryptoException {
        JSONObject issuerData = null;
        java.sql.Date renewalWindow = new java.sql.Date(ctx.getTime() + 60000L);
        java.sql.Date expiration = new java.sql.Date(ctx.getTime() + 120000L);
        long serialNumber = -1L;
        while ((serialNumber = ctx.getRandom().nextLong()) < 0L || serialNumber > 0x20000000000000L) {
        }
        return new UserIdToken(ctx, (Date)renewalWindow, (Date)expiration, masterToken, serialNumber, issuerData, user);
    }

    public UserIdToken renewUserIdToken(MslContext ctx, UserIdToken userIdToken, MasterToken masterToken) throws MslEncodingException, MslCryptoException, MslUserIdTokenException {
        if (!userIdToken.isDecrypted()) {
            throw new MslUserIdTokenException(MslError.USERIDTOKEN_NOT_DECRYPTED, userIdToken).setMasterToken(masterToken);
        }
        JSONObject issuerData = null;
        java.sql.Date renewalWindow = new java.sql.Date(ctx.getTime() + 60000L);
        java.sql.Date expiration = new java.sql.Date(ctx.getTime() + 120000L);
        long serialNumber = userIdToken.getSerialNumber();
        MslUser user = userIdToken.getUser();
        return new UserIdToken(ctx, (Date)renewalWindow, (Date)expiration, masterToken, serialNumber, issuerData, user);
    }

    public MslUser createUser(MslContext ctx, String userdata) {
        return new SimpleUser(userdata);
    }
}

