/*
 * Decompiled with CFR 0.152.
 */
package server.msg;

import org.json.JSONException;
import org.json.JSONObject;
import server.SimpleConstants;
import server.msg.SimpleRequest;
import server.msg.SimpleRequestExecutionException;
import server.msg.SimpleRequestParseException;
import server.msg.SimpleRequestUserException;
import server.msg.SimpleRespondMessageContext;
import server.userauth.SimpleUser;

public class SimpleQueryRequest
extends SimpleRequest {
    private static final String KEY_KEY = "key";
    private final String key;

    public SimpleQueryRequest(String identity, SimpleUser user, JSONObject data) throws SimpleRequestParseException {
        super(SimpleRequest.Type.QUERY, identity, user);
        try {
            this.key = data.getString(KEY_KEY);
        }
        catch (JSONException e) {
            throw new SimpleRequestParseException("Error parsing query request: " + data.toString() + ".", (Throwable)e);
        }
    }

    public String getKey() {
        return this.key;
    }

    public JSONObject getData() {
        JSONObject jo = new JSONObject();
        jo.put(KEY_KEY, (Object)this.key);
        return jo;
    }

    public SimpleRespondMessageContext execute() throws SimpleRequestUserException, SimpleRequestExecutionException {
        SimpleUser user = this.getUser();
        String username = user != null ? user.toString() : null;
        for (String[] data : SimpleConstants.QUERY_DATA) {
            if (!data[1].equals(this.key)) continue;
            if (data[0] != null && !data[0].equals(username)) {
                throw new SimpleRequestUserException("Error: access restricted to user " + data[0] + ".");
            }
            String response = data[2];
            return new SimpleRespondMessageContext(this.getIdentity(), true, response);
        }
        throw new SimpleRequestExecutionException("Error: no data found for key " + this.key + ".");
    }
}

