/*
 * Decompiled with CFR 0.152.
 */
package server.msg;

import com.netflix.msl.MslConstants;
import com.netflix.msl.crypto.ICryptoContext;
import com.netflix.msl.msg.MessageHeader;
import com.netflix.msl.msg.MessageInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONString;
import server.msg.SimpleEchoRequest;
import server.msg.SimpleLogRequest;
import server.msg.SimpleProfileRequest;
import server.msg.SimpleQueryRequest;
import server.msg.SimpleQuitRequest;
import server.msg.SimpleRequest;
import server.msg.SimpleRequestExecutionException;
import server.msg.SimpleRequestParseException;
import server.msg.SimpleRequestUnknownException;
import server.msg.SimpleRequestUserException;
import server.msg.SimpleRespondMessageContext;
import server.userauth.SimpleUser;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class SimpleRequest
implements JSONString {
    private static final String KEY_TYPE = "type";
    private static final String KEY_DATA = "data";
    private final Type type;
    private final String identity;
    private final SimpleUser user;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleRequest parse(String identity, SimpleUser user, MessageInputStream request, Map<String, ICryptoContext> cryptoContexts) throws SimpleRequestUnknownException, SimpleRequestParseException, SimpleRequestUserException, IOException {
        Type type;
        JSONObject data;
        String typeString;
        StringBuilder jsonBuilder = new StringBuilder();
        InputStreamReader r = new InputStreamReader((InputStream)request, MslConstants.DEFAULT_CHARSET);
        try {
            char[] buffer;
            int count;
            while ((count = r.read(buffer = new char[4096])) >= 0) {
                jsonBuilder.append(buffer, 0, count);
            }
        }
        finally {
            try {
                ((Reader)r).close();
            }
            catch (IOException e) {}
        }
        JSONObject json = new JSONObject(jsonBuilder.toString());
        try {
            typeString = json.getString("type");
            data = json.getJSONObject("data");
        }
        catch (JSONException e) {
            throw new SimpleRequestParseException("Error parsing request outer structure: " + json.toString(), (Throwable)e);
        }
        try {
            type = Type.valueOf((String)typeString);
        }
        catch (IllegalArgumentException e) {
            throw new SimpleRequestUnknownException("Unknown request type " + typeString + ".");
        }
        switch (1.$SwitchMap$server$msg$SimpleRequest$Type[type.ordinal()]) {
            case 1: {
                return new SimpleEchoRequest(identity, user, data);
            }
            case 2: {
                return new SimpleQueryRequest(identity, user, data);
            }
            case 3: {
                MessageHeader header = request.getMessageHeader();
                Set tokens = header.getServiceTokens();
                return new SimpleLogRequest(identity, user, data, tokens, cryptoContexts);
            }
            case 4: {
                return new SimpleProfileRequest(identity, user, data);
            }
            case 5: {
                return new SimpleQuitRequest(identity, user, data);
            }
        }
        throw new SimpleRequestUnknownException("Request type " + type + " has no request class.");
    }

    protected SimpleRequest(Type type, String identity, SimpleUser user) {
        this.type = type;
        this.identity = identity;
        this.user = user;
    }

    public Type getType() {
        return this.type;
    }

    public String getIdentity() {
        return this.identity;
    }

    public SimpleUser getUser() {
        return this.user;
    }

    public abstract JSONObject getData();

    public abstract SimpleRespondMessageContext execute() throws SimpleRequestUserException, SimpleRequestExecutionException;

    public String toJSONString() {
        JSONObject jo = new JSONObject();
        jo.put("type", (Object)this.type.name());
        jo.put("data", (Object)this.getData());
        return jo.toString();
    }
}

