/*
 * Decompiled with CFR 0.152.
 */
package server.msg;

import com.netflix.msl.MslConstants;
import com.netflix.msl.MslCryptoException;
import com.netflix.msl.MslEncodingException;
import com.netflix.msl.MslException;
import com.netflix.msl.MslKeyExchangeException;
import com.netflix.msl.crypto.ICryptoContext;
import com.netflix.msl.keyx.KeyRequestData;
import com.netflix.msl.msg.MessageContext;
import com.netflix.msl.msg.MessageDebugContext;
import com.netflix.msl.msg.MessageOutputStream;
import com.netflix.msl.msg.MessageServiceTokenBuilder;
import com.netflix.msl.tokens.MslUser;
import com.netflix.msl.userauth.UserAuthenticationData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import server.msg.SimpleRespondMessageContext;

public class SimpleRespondMessageContext
implements MessageContext {
    private final Map<String, ICryptoContext> cryptoContexts;
    private final String recipient;
    private final boolean encrypted;
    private final String data;
    private final Set<Token> tokens;

    public SimpleRespondMessageContext(String recipient, boolean encrypted, String data) {
        this.recipient = recipient;
        this.encrypted = encrypted;
        this.data = data;
        this.tokens = Collections.emptySet();
        this.cryptoContexts = Collections.emptyMap();
    }

    public SimpleRespondMessageContext(String recipient, boolean encrypted, String data, Set<Token> tokens, Map<String, ICryptoContext> cryptoContexts) {
        this.recipient = recipient;
        this.encrypted = encrypted;
        this.data = data;
        this.tokens = tokens;
        this.cryptoContexts = Collections.unmodifiableMap(cryptoContexts);
    }

    public Map<String, ICryptoContext> getCryptoContexts() {
        return this.cryptoContexts;
    }

    public String getRecipient() {
        return this.recipient;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isIntegrityProtected() {
        return true;
    }

    public boolean isNonReplayable() {
        return false;
    }

    public boolean isRequestingTokens() {
        return false;
    }

    public String getUserId() {
        return null;
    }

    public UserAuthenticationData getUserAuthData(MessageContext.ReauthCode reauthCode, boolean renewable, boolean required) {
        return null;
    }

    public MslUser getUser() {
        return null;
    }

    public Set<KeyRequestData> getKeyRequestData() throws MslKeyExchangeException {
        return null;
    }

    public void updateServiceTokens(MessageServiceTokenBuilder builder, boolean handshake) throws MslEncodingException, MslCryptoException, MslException {
        if (handshake) {
            return;
        }
        for (Token token : this.tokens) {
            String name = token.name;
            byte[] data = token.data.getBytes(MslConstants.DEFAULT_CHARSET);
            if (token.userBound && builder.isPrimaryUserIdTokenAvailable()) {
                builder.addUserBoundPrimaryServiceToken(name, data, true, MslConstants.CompressionAlgorithm.GZIP);
                continue;
            }
            if (token.entityBound && builder.isPrimaryMasterTokenAvailable()) {
                builder.addMasterBoundPrimaryServiceToken(name, data, true, MslConstants.CompressionAlgorithm.GZIP);
                continue;
            }
            builder.addUnboundPrimaryServiceToken(name, data, true, MslConstants.CompressionAlgorithm.GZIP);
        }
    }

    public void write(MessageOutputStream output) throws IOException {
        output.write(this.data.getBytes(MslConstants.DEFAULT_CHARSET));
        output.close();
    }

    public MessageDebugContext getDebugContext() {
        return null;
    }

    public String getData() {
        return this.data;
    }
}

