/*
 * Decompiled with CFR 0.152.
 */
package server.util;

import com.netflix.msl.MslConstants;
import com.netflix.msl.MslCryptoException;
import com.netflix.msl.crypto.ICryptoContext;
import com.netflix.msl.crypto.SymmetricCryptoContext;
import com.netflix.msl.entityauth.EntityAuthenticationData;
import com.netflix.msl.entityauth.EntityAuthenticationFactory;
import com.netflix.msl.entityauth.EntityAuthenticationScheme;
import com.netflix.msl.entityauth.RsaAuthenticationData;
import com.netflix.msl.entityauth.RsaAuthenticationFactory;
import com.netflix.msl.entityauth.RsaStore;
import com.netflix.msl.entityauth.UnauthenticatedAuthenticationFactory;
import com.netflix.msl.keyx.AsymmetricWrappedExchange;
import com.netflix.msl.keyx.KeyExchangeFactory;
import com.netflix.msl.keyx.KeyExchangeScheme;
import com.netflix.msl.msg.MessageCapabilities;
import com.netflix.msl.tokens.TokenFactory;
import com.netflix.msl.userauth.EmailPasswordAuthenticationFactory;
import com.netflix.msl.userauth.EmailPasswordStore;
import com.netflix.msl.userauth.UserAuthenticationFactory;
import com.netflix.msl.userauth.UserAuthenticationScheme;
import com.netflix.msl.util.AuthenticationUtils;
import com.netflix.msl.util.MslContext;
import com.netflix.msl.util.MslStore;
import com.netflix.msl.util.NullMslStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import server.userauth.SimpleTokenFactory;
import server.util.SimpleAuthenticationUtils;
import server.util.SimpleMslContext;

public class SimpleMslContext
extends MslContext {
    private static final byte[] MSL_ENCRYPTION_KEY = new byte[]{29, 88, -13, -72, -9, 71, -47, 106, -79, -109, -60, -64, -90, 36, -22, -49};
    private static final byte[] MSL_HMAC_KEY = new byte[]{-41, -82, -65, -43, -121, -101, -80, -32, -83, 1, 106, 76, -13, -53, 57, -126, -11, -70, 38, 13, -91, 32, 36, 91, -76, 34, 117, -67, 121, 71, 55, 12};
    private static final byte[] MSL_WRAPPING_KEY = new byte[]{-125, -74, -102, 21, -128, -45, 35, -94, -25, -99, -39, -78, 38, 38, -77, -10};
    private final MessageCapabilities messageCaps;
    private final EntityAuthenticationData entityAuthData;
    private final ICryptoContext mslCryptoContext;
    private final Set<EntityAuthenticationFactory> entityAuthFactories;
    private final UserAuthenticationFactory userAuthFactory;
    private final TokenFactory tokenFactory = new SimpleTokenFactory();
    private final SortedSet<KeyExchangeFactory> keyxFactories;
    private final MslStore store = new NullMslStore();

    public SimpleMslContext(String serverId, RsaStore rsaStore, EmailPasswordStore emailPasswordStore) {
        HashSet<MslConstants.CompressionAlgorithm> compressionAlgos = new HashSet<MslConstants.CompressionAlgorithm>(Arrays.asList(MslConstants.CompressionAlgorithm.GZIP, MslConstants.CompressionAlgorithm.LZW));
        List<String> languages = Arrays.asList("en-US");
        this.messageCaps = new MessageCapabilities(compressionAlgos, languages);
        SecretKeySpec encryptionKey = new SecretKeySpec(MSL_ENCRYPTION_KEY, "AES");
        SecretKeySpec hmacKey = new SecretKeySpec(MSL_HMAC_KEY, "HmacSHA256");
        SecretKeySpec wrappingKey = new SecretKeySpec(MSL_WRAPPING_KEY, "AES");
        this.mslCryptoContext = new SymmetricCryptoContext((MslContext)this, serverId, (SecretKey)encryptionKey, (SecretKey)hmacKey, (SecretKey)wrappingKey);
        SimpleAuthenticationUtils authutils = new SimpleAuthenticationUtils(serverId);
        this.entityAuthData = new RsaAuthenticationData(serverId, serverId);
        this.entityAuthFactories = new HashSet();
        this.entityAuthFactories.add(new RsaAuthenticationFactory(serverId, rsaStore, (AuthenticationUtils)authutils));
        this.entityAuthFactories.add(new UnauthenticatedAuthenticationFactory((AuthenticationUtils)authutils));
        this.userAuthFactory = new EmailPasswordAuthenticationFactory(emailPasswordStore, (AuthenticationUtils)authutils);
        this.keyxFactories = new TreeSet(new KeyExchangeFactoryComparator());
        this.keyxFactories.add(new AsymmetricWrappedExchange((AuthenticationUtils)authutils));
    }

    public long getTime() {
        return System.currentTimeMillis();
    }

    public Random getRandom() {
        return new SecureRandom();
    }

    public boolean isPeerToPeer() {
        return false;
    }

    public MessageCapabilities getMessageCapabilities() {
        return this.messageCaps;
    }

    public EntityAuthenticationData getEntityAuthenticationData(MslContext.ReauthCode reauthCode) {
        return this.entityAuthData;
    }

    public ICryptoContext getMslCryptoContext() throws MslCryptoException {
        return this.mslCryptoContext;
    }

    public EntityAuthenticationScheme getEntityAuthenticationScheme(String name) {
        return EntityAuthenticationScheme.getScheme((String)name);
    }

    public EntityAuthenticationFactory getEntityAuthenticationFactory(EntityAuthenticationScheme scheme) {
        for (EntityAuthenticationFactory factory : this.entityAuthFactories) {
            if (!factory.getScheme().equals((Object)scheme)) continue;
            return factory;
        }
        return null;
    }

    public UserAuthenticationScheme getUserAuthenticationScheme(String name) {
        return UserAuthenticationScheme.getScheme((String)name);
    }

    public UserAuthenticationFactory getUserAuthenticationFactory(UserAuthenticationScheme scheme) {
        if (this.userAuthFactory.getScheme().equals((Object)scheme)) {
            return this.userAuthFactory;
        }
        return null;
    }

    public TokenFactory getTokenFactory() {
        return this.tokenFactory;
    }

    public KeyExchangeScheme getKeyExchangeScheme(String name) {
        return KeyExchangeScheme.getScheme((String)name);
    }

    public KeyExchangeFactory getKeyExchangeFactory(KeyExchangeScheme scheme) {
        for (KeyExchangeFactory factory : this.keyxFactories) {
            if (!factory.getScheme().equals((Object)scheme)) continue;
            return factory;
        }
        return null;
    }

    public SortedSet<KeyExchangeFactory> getKeyExchangeFactories() {
        return this.keyxFactories;
    }

    public MslStore getMslStore() {
        return this.store;
    }
}

