/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencylock;

import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockCommitExtension;
import nebula.plugin.dependencylock.DependencyLockExtension;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.DependencyLockReader;
import nebula.plugin.dependencylock.DependencyLockTaskConfigurer;
import nebula.plugin.dependencylock.GradleInteropKt;
import nebula.plugin.dependencylock.exceptions.DependencyLockException;
import nebula.plugin.dependencylock.model.LockKey;
import nebula.plugin.dependencylock.model.LockValue;
import nebula.plugin.dependencylock.utils.CoreLockingHelper;
import nebula.plugin.dependencylock.utils.DependencyLockingFeatureFlags;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifier;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifierExtension;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ResolutionStrategy;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.NameMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002ABB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0002J \u0010$\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010,\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J$\u0010-\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010/\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u001e\u00100\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J<\u00104\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\b\u00107\u001a\u0004\u0018\u00010\r2\b\u00108\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020!H\u0002J\u0016\u0010<\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\r02H\u0002J\u0010\u0010>\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\f\u0010?\u001a\u000203*\u00020@H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006C"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "lockReader", "Lnebula/plugin/dependencylock/DependencyLockReader;", "getLockReader", "()Lnebula/plugin/dependencylock/DependencyLockReader;", "setLockReader", "(Lnebula/plugin/dependencylock/DependencyLockReader;)V", "lockUsed", "", "getLockUsed", "()Ljava/lang/String;", "setLockUsed", "(Ljava/lang/String;)V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "reasons", "", "getReasons", "()Ljava/util/Set;", "apply", "", "applyLock", "conf", "Lorg/gradle/api/artifacts/Configuration;", "dependenciesLock", "Ljava/io/File;", "updates", "", "applyOverrides", "overrides", "", "disableCachingForGenerateLock", "hasGenerationTask", "", "cliTasks", "", "hasMigrationTask", "hasTask", "taskNames", "hasUpdateTask", "lockConfiguration", "selectorKeys", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "maybeApplyLock", "extension", "Lnebula/plugin/dependencylock/DependencyLockExtension;", "globalLockFileName", "lockFilename", "parseUpdates", "rewriteLocksUsingCoreLocking", "lockFile", "taskRunOnThisProject", "tokens", "uniqueProjectKey", "toKey", "Lorg/gradle/api/artifacts/DependencyResolveDetails;", "Companion", "ModuleVersionSelectorKey", "gradle-dependency-lock-plugin"})
public final class DependencyLockPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOGGER;
    public Project project;
    public DependencyLockReader lockReader;
    public String lockUsed;
    @NotNull
    private final Set<String> reasons;
    @NotNull
    public static final String EXTENSION_NAME = "dependencyLock";
    @NotNull
    public static final String COMMIT_EXTENSION_NAME = "commitDependencyLock";
    @NotNull
    public static final String DEPENDENCY_RESOLTION_VERIFIER_EXTENSION = "dependencyResolutionVerifierExtension";
    @NotNull
    public static final String LOCK_FILE = "dependencyLock.lockFile";
    @NotNull
    public static final String GLOBAL_LOCK_FILE = "dependencyLock.globalLockFile";
    @NotNull
    public static final String LOCK_AFTER_EVALUATING = "dependencyLock.lockAfterEvaluating";
    @NotNull
    public static final String UPDATE_DEPENDENCIES = "dependencyLock.updateDependencies";
    @NotNull
    public static final String OVERRIDE = "dependencyLock.override";
    @NotNull
    public static final String OVERRIDE_FILE = "dependencyLock.overrideFile";
    @NotNull
    public static final String GENERATE_GLOBAL_LOCK_TASK_NAME = "generateGlobalLock";
    @NotNull
    public static final String UPDATE_GLOBAL_LOCK_TASK_NAME = "updateGlobalLock";
    @NotNull
    public static final String GENERATE_LOCK_TASK_NAME = "generateLock";
    @NotNull
    public static final String UPDATE_LOCK_TASK_NAME = "updateLock";
    @NotNull
    public static final String MIGRATE_TO_CORE_LOCK_TASK_NAME = "migrateToCoreLocks";
    @NotNull
    public static final String WRITE_CORE_LOCK_TASK_TO_RUN = "`./gradlew dependencies --write-locks`";
    @NotNull
    private static final Set<String> GENERATION_TASK_NAMES;
    @NotNull
    private static final Set<String> UPDATE_TASK_NAMES;
    @NotNull
    private static final Set<String> MIGRATION_TASK_NAMES;
    @NotNull
    private static final Map<String, Map<String, List<ModuleVersionSelectorKey>>> lockedDepsPerProjectForConfigurations;
    @NotNull
    private static final Map<String, Map<String, List<ModuleVersionSelectorKey>>> overrideDepsPerProjectForConfigurations;

    public DependencyLockPlugin() {
        Logger logger2 = Logging.getLogger(DependencyLockPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(DependencyLockPlugin::class.java)");
        this.LOGGER = logger2;
        boolean bl = false;
        this.reasons = new LinkedHashSet();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyLockReader getLockReader() {
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader != null) {
            return dependencyLockReader;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        return null;
    }

    public final void setLockReader(@NotNull DependencyLockReader dependencyLockReader) {
        Intrinsics.checkNotNullParameter((Object)dependencyLockReader, (String)"<set-?>");
        this.lockReader = dependencyLockReader;
    }

    @NotNull
    public final String getLockUsed() {
        String string = this.lockUsed;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        return null;
    }

    public final void setLockUsed(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lockUsed = string;
    }

    @NotNull
    public final Set<String> getReasons() {
        return this.reasons;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
        this.setLockReader(new DependencyLockReader(project));
        DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = (DependencyResolutionVerifierExtension)project.getRootProject().getExtensions().findByType(DependencyResolutionVerifierExtension.class);
        if (dependencyResolutionVerifierExtension == null) {
            dependencyResolutionVerifierExtension = (DependencyResolutionVerifierExtension)project.getRootProject().getExtensions().create(DEPENDENCY_RESOLTION_VERIFIER_EXTENSION, DependencyResolutionVerifierExtension.class, new Object[0]);
        }
        Map<String, Map<String, List<ModuleVersionSelectorKey>>> map = lockedDepsPerProjectForConfigurations;
        String string = this.uniqueProjectKey(project);
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        boolean bl2 = false;
        map.put(string, map2);
        map = overrideDepsPerProjectForConfigurations;
        string = this.uniqueProjectKey(project);
        boolean bl3 = false;
        Map map3 = new LinkedHashMap();
        bl2 = false;
        map.put(string, map3);
        string = project.getGradle().getStartParameter();
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.gradle.api.internal.StartParameterInternal");
        }
        StartParameterInternal startParameter = (StartParameterInternal)string;
        boolean isMigratingToCoreLocks = startParameter.getTaskNames().contains(MIGRATE_TO_CORE_LOCK_TASK_NAME);
        boolean isConfigurationCache = false;
        try {
            Method method = StartParameterInternal.class.getMethod("isConfigurationCache", new Class[0]);
            Object object = method.invoke((Object)startParameter, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
            }
            isConfigurationCache = (Boolean)object;
        }
        catch (Exception method) {
            // empty catch block
        }
        if (!isMigratingToCoreLocks && !isConfigurationCache) {
            new DependencyResolutionVerifier().verifySuccessfulResolution(project);
        }
        DependencyLockExtension extension = (DependencyLockExtension)project.getExtensions().create(EXTENSION_NAME, DependencyLockExtension.class, new Object[0]);
        DependencyLockCommitExtension commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().findByType(DependencyLockCommitExtension.class);
        if (commitExtension == null) {
            commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().create(COMMIT_EXTENSION_NAME, DependencyLockCommitExtension.class, new Object[0]);
        }
        Map overrides = this.getLockReader().readOverrides();
        String globalLockFilename = GradleInteropKt.findStringProperty(project, GLOBAL_LOCK_FILE);
        String lockFilename = GradleInteropKt.findStringProperty(project, LOCK_FILE);
        new DependencyLockTaskConfigurer(project).configureTasks(globalLockFilename, lockFilename, extension, commitExtension, overrides);
        if (DependencyLockingFeatureFlags.isCoreLockingEnabled()) {
            List taskNames;
            this.LOGGER.info(Intrinsics.stringPlus((String)project.getName(), (Object)": coreLockingSupport feature enabled"));
            CoreLockingHelper coreLockingHelper = new CoreLockingHelper(project);
            coreLockingHelper.lockSelectedConfigurations(extension.getConfigurationNames());
            coreLockingHelper.disableCachingWhenUpdatingDependencies();
            coreLockingHelper.notifyWhenUsingOfflineMode();
            File lockFile = new File(project.getProjectDir(), extension.getLockFile());
            if (lockFile.exists()) {
                if (startParameter.isWriteDependencyLocks()) {
                    this.rewriteLocksUsingCoreLocking(lockFile);
                } else {
                    taskNames = startParameter.getTaskNames();
                    Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
                    boolean hasMigrationTask = this.hasMigrationTask(taskNames);
                    if (!hasMigrationTask) {
                        throw new BuildCancelledException(Intrinsics.stringPlus((String)"Legacy locks are not supported with core locking.\nIf you wish to migrate with the current locked dependencies, please use `./gradlew migrateToCoreLocks`\nAlternatively, please remove the legacy lockfile manually and use `./gradlew dependencies --write-locks`\n - Legacy lock: ", (Object)lockFile.getAbsolutePath()));
                    }
                }
            }
            taskNames = startParameter.getTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(taskNames);
            boolean hasGenerationTask = this.hasGenerationTask(taskNames);
            File globalLockFile = new File(project.getProjectDir(), extension.getGlobalLockFile());
            if (globalLockFile.exists() && !hasGenerationTask && !hasUpdateTask) {
                throw new BuildCancelledException(Intrinsics.stringPlus((String)"Legacy global locks are not supported with core locking.\nPlease remove global locks.\n - Legacy global lock: ", (Object)globalLockFile.getAbsolutePath()));
            }
        } else {
            boolean lockAfterEvaluating;
            boolean bl4;
            if (project.hasProperty(LOCK_AFTER_EVALUATING)) {
                String lockFile = String.valueOf(project.property(LOCK_AFTER_EVALUATING));
                boolean taskNames = false;
                bl4 = Boolean.parseBoolean(lockFile);
            } else {
                bl4 = lockAfterEvaluating = extension.getLockAfterEvaluating();
            }
            if (lockAfterEvaluating) {
                this.LOGGER.info("Delaying dependency lock apply until beforeResolve (dependencyLock.lockAfterEvaluating set to true)");
            } else {
                this.LOGGER.info("Applying dependency lock during plugin apply (dependencyLock.lockAfterEvaluating set to false)");
            }
            this.disableCachingForGenerateLock();
            DependencyLockPlugin $this$groovyClosure$iv = this;
            boolean $i$f$groovyClosure = false;
            project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Unit>((Object)$this$groovyClosure$iv, this){
                final /* synthetic */ Object $this_groovyClosure;
                final /* synthetic */ DependencyLockPlugin this$0;
                {
                    this.$this_groovyClosure = $receiver;
                    this.this$0 = dependencyLockPlugin;
                    super($receiver);
                }

                public final void doCall() {
                    boolean bl = false;
                    DependencyLockPlugin.access$disableCachingForGenerateLock(this.this$0);
                }
            });
            project.getConfigurations().all(arg_0 -> DependencyLockPlugin.apply$lambda-2(lockAfterEvaluating, this, extension, overrides, globalLockFilename, lockFilename, arg_0));
        }
    }

    private final void disableCachingForGenerateLock() {
        List list = this.getProject().getGradle().getStartParameter().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.gradle.startParameter.taskNames");
        if (this.hasGenerationTask(list)) {
            this.getProject().getConfigurations().all(DependencyLockPlugin::disableCachingForGenerateLock$lambda-4);
        }
    }

    private final void maybeApplyLock(Configuration conf, DependencyLockExtension extension, Map<?, ?> overrides, String globalLockFileName, String lockFilename) {
        String string;
        File file;
        String string2;
        File globalLock = new File(this.getProject().getRootProject().getProjectDir(), (string2 = globalLockFileName) == null ? extension.getGlobalLockFile() : string2);
        if (globalLock.exists()) {
            file = globalLock;
        } else {
            string = lockFilename;
            String string3 = string == null ? extension.getLockFile() : string;
            file = new File(this.getProject().getProjectDir(), string3);
        }
        File dependenciesLock = file;
        string = dependenciesLock.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dependenciesLock.name");
        this.setLockUsed(string);
        this.reasons.add(Intrinsics.stringPlus((String)"nebula.dependency-lock locked with: ", (Object)this.getLockUsed()));
        if (!DependencyLockTaskConfigurer.shouldIgnoreDependencyLock(this.getProject())) {
            Set<String> set;
            List taskNames = this.getProject().getGradle().getStartParameter().getTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(taskNames);
            if (this.getProject().hasProperty(UPDATE_DEPENDENCIES)) {
                Object object = this.getProject().property(UPDATE_DEPENDENCIES);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                set = this.parseUpdates((String)object);
            } else {
                set = extension.getUpdateDependencies();
            }
            Set<String> updates = set;
            String projectCoord = this.getProject().getGroup() + ':' + this.getProject().getName();
            if (hasUpdateTask) {
                boolean bl;
                block15: {
                    Intrinsics.checkNotNullExpressionValue(updates, (String)"updates");
                    Iterable $this$any$iv = updates;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)projectCoord)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw new DependencyLockException("Dependency locks cannot be updated. An update was requested for a project dependency (" + projectCoord + ')');
                }
            }
            boolean hasGenerateTask = this.hasGenerationTask(taskNames);
            if (dependenciesLock.exists()) {
                if (!hasGenerateTask) {
                    DependencyLockPlugin.applyLock$default(this, conf, dependenciesLock, null, 4, null);
                } else if (hasUpdateTask) {
                    Intrinsics.checkNotNullExpressionValue(updates, (String)"updates");
                    this.applyLock(conf, dependenciesLock, updates);
                }
            }
            this.applyOverrides(conf, overrides);
        }
    }

    private final boolean hasGenerationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)GENERATION_TASK_NAMES);
    }

    private final boolean hasUpdateTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)UPDATE_TASK_NAMES);
    }

    private final boolean hasMigrationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)MIGRATION_TASK_NAMES);
    }

    private final boolean hasTask(Collection<String> cliTasks, Collection<String> taskNames) {
        Object v0;
        block1: {
            NameMatcher matcher = new NameMatcher();
            Iterable iterable = cliTasks;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                String cliTaskName = (String)t;
                boolean bl3 = false;
                String[] stringArray = new String[]{":"};
                List tokens = StringsKt.split$default((CharSequence)cliTaskName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String taskName = (String)CollectionsKt.last((List)tokens);
                String generatesPresent = matcher.find(taskName, taskNames);
                if (!(generatesPresent != null && this.taskRunOnThisProject(tokens))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        String found = v0;
        return found != null;
    }

    private final boolean taskRunOnThisProject(List<String> tokens) {
        if (tokens.size() == 1) {
            return true;
        }
        if (tokens.size() == 2 && Intrinsics.areEqual((Object)tokens.get(0), (Object)"")) {
            return Intrinsics.areEqual((Object)this.getProject(), (Object)this.getProject().getRootProject());
        }
        return Intrinsics.areEqual((Object)this.getProject().getName(), (Object)tokens.get(tokens.size() - 2));
    }

    private final Set<String> parseUpdates(String updates) {
        String[] stringArray = new String[]{","};
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)updates, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void applyLock(Configuration conf, File dependenciesLock, Set<String> updates) {
        Object dependency;
        this.LOGGER.info("Using " + dependenciesLock.getName() + " to lock dependencies in " + conf);
        boolean bl = false;
        Map deps2 = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)applyLock.deps.1.INSTANCE);
        DomainObjectSet externalDependencies = conf.getAllDependencies().withType(ExternalDependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)externalDependencies, (String)"externalDependencies");
        Iterable $this$forEach$iv = (Iterable)externalDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            dependency = (ExternalDependency)element$iv;
            boolean bl2 = false;
            LockKey key = new LockKey(dependency.getGroup(), dependency.getName(), conf.getName());
            deps2.put(key, new LockValue());
            Object v = deps2.get(key);
            Intrinsics.checkNotNull(v);
            ((LockValue)v).setRequested(dependency.getVersion());
        }
        Map locks = this.getLockReader().readLocks(conf, dependenciesLock, deps2, (Collection<String>)updates);
        if (locks != null) {
            Map<String, List<ModuleVersionSelectorKey>> lockedDepsByConf;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl3;
            String string;
            Object object;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = locks;
            boolean $i$f$filter = false;
            dependency = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var13_20 = $this$filterTo$iv$iv;
            boolean bl4 = false;
            Iterator iterator = var13_20.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl5 = false;
                object = it.getValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                object = (Map)object;
                string = "locked";
                bl3 = false;
                if (!object.containsKey(string)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            var13_20 = $this$mapTo$iv$iv;
            bl4 = false;
            for (Map.Entry item$iv$iv : var13_20.entrySet()) {
                it = item$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl6 = false;
                object = it.getValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                object = (Map)object;
                string = "locked";
                bl3 = false;
                Object version = object.get(string);
                ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), version);
                object2.add(moduleVersionSelectorKey);
            }
            List locked = (List)destination$iv$iv;
            this.LOGGER.debug("locked: {}", (Object)locked);
            this.lockConfiguration(conf, locked);
            Map<String, List<ModuleVersionSelectorKey>> map = lockedDepsByConf = lockedDepsPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
            Intrinsics.checkNotNull(map);
            Map<String, List<ModuleVersionSelectorKey>> map2 = map;
            String string2 = conf.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"conf.name");
            boolean bl7 = false;
            map2.put(string2, locked);
        }
    }

    static /* synthetic */ void applyLock$default(DependencyLockPlugin dependencyLockPlugin, Configuration configuration, File file, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        dependencyLockPlugin.applyLock(configuration, file, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyOverrides(Configuration conf, Map<?, ?> overrides) {
        Map<String, List<ModuleVersionSelectorKey>> overrideDepsByConf;
        void $this$mapTo$iv$iv;
        if (this.getProject().hasProperty(OVERRIDE_FILE)) {
            this.LOGGER.info("Using override file " + this.getProject().property(OVERRIDE_FILE) + " to lock dependencies");
            this.reasons.add(Intrinsics.stringPlus((String)"nebula.dependency-lock using override file: ", (Object)this.getProject().property(OVERRIDE_FILE)));
        }
        if (this.getProject().hasProperty(OVERRIDE)) {
            this.LOGGER.info(Intrinsics.stringPlus((String)"Using command line overrides ", (Object)this.getProject().property(OVERRIDE)));
            this.reasons.add(Intrinsics.stringPlus((String)"nebula.dependency-lock using override: ", (Object)this.getProject().property(OVERRIDE)));
        }
        Map<?, ?> $this$map$iv = overrides;
        boolean $i$f$map = false;
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_10 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_10.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), it.getValue());
            collection.add(moduleVersionSelectorKey);
        }
        List overrideDeps = (List)destination$iv$iv;
        this.LOGGER.debug("overrides: {}", (Object)overrideDeps);
        this.lockConfiguration(conf, overrideDeps);
        Map<String, List<ModuleVersionSelectorKey>> map = overrideDepsByConf = overrideDepsPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Intrinsics.checkNotNull(map);
        Map<String, List<ModuleVersionSelectorKey>> map2 = map;
        object = conf.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"conf.name");
        boolean bl3 = false;
        map2.put((String)object, overrideDeps);
    }

    /*
     * WARNING - void declaration
     */
    private final void lockConfiguration(Configuration conf, List<ModuleVersionSelectorKey> selectorKeys) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = selectorKeys;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ModuleVersionSelectorKey it = (ModuleVersionSelectorKey)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl3 = false;
            ModuleVersionSelectorKey moduleVersionSelectorKey = (ModuleVersionSelectorKey)it.getKey();
            map2.put(k2, moduleVersionSelectorKey);
        }
        Map selectorsByKey = destination$iv$iv;
        conf.getResolutionStrategy().eachDependency(arg_0 -> DependencyLockPlugin.lockConfiguration$lambda-13(this, selectorsByKey, arg_0));
    }

    private final ModuleVersionSelectorKey toKey(DependencyResolveDetails $this$toKey) {
        String string = $this$toKey.getRequested().getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requested.group");
        String string2 = string;
        string = $this$toKey.getRequested().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requested.name");
        return new ModuleVersionSelectorKey(string2, string, $this$toKey.getRequested().getVersion());
    }

    private final void rewriteLocksUsingCoreLocking(File lockFile) {
        File dependencyLockDirectory = new File(this.getProject().getProjectDir(), "/gradle/dependency-locks");
        this.LOGGER.warn("Removing legacy locks to use core Gradle locking. This will remove legacy locks.This is not a migration.\n - Legacy lock: " + lockFile.getAbsolutePath() + "\n - Core Gradle locks: " + dependencyLockDirectory.getAbsoluteFile() + "\n\nTo migrate your currently locked state, please run `./gradlew migrateToCoreLocks`");
        String failureToDeleteLockfileMessage = Intrinsics.stringPlus((String)"Failed to delete legacy locks.\nPlease remove the legacy lock file manually.\n - Legacy lock: ", (Object)lockFile.getAbsolutePath());
        try {
            if (!lockFile.delete()) {
                throw new BuildCancelledException(failureToDeleteLockfileMessage);
            }
        }
        catch (Exception e) {
            throw new BuildCancelledException(failureToDeleteLockfileMessage, (Throwable)e);
        }
    }

    private final String uniqueProjectKey(Project project) {
        return project.getName() + '-' + (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? "rootproject" : "subproject");
    }

    private static final void apply$lambda-2(boolean $lockAfterEvaluating, DependencyLockPlugin this$0, DependencyLockExtension $extension, Map $overrides, String $globalLockFilename, String $lockFilename, Configuration conf) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($lockAfterEvaluating) {
            Intrinsics.checkNotNullExpressionValue((Object)conf, (String)"conf");
            Configuration $this$onResolve$iv = conf;
            boolean $i$f$onResolve = false;
            $this$onResolve$iv.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>($this$onResolve$iv, this$0, conf, $extension, $overrides, $globalLockFilename, $lockFilename){
                final /* synthetic */ Configuration $this_onResolve;
                final /* synthetic */ DependencyLockPlugin this$0;
                final /* synthetic */ Configuration $conf$inlined;
                final /* synthetic */ DependencyLockExtension $extension$inlined;
                final /* synthetic */ Map $overrides$inlined;
                final /* synthetic */ String $globalLockFilename$inlined;
                final /* synthetic */ String $lockFilename$inlined;
                {
                    this.$this_onResolve = configuration;
                    this.this$0 = dependencyLockPlugin;
                    this.$conf$inlined = configuration2;
                    this.$extension$inlined = dependencyLockExtension;
                    this.$overrides$inlined = map;
                    this.$globalLockFilename$inlined = string;
                    this.$lockFilename$inlined = string2;
                }

                public final void execute(ResolvableDependencies incoming) {
                    if (Intrinsics.areEqual((Object)this.$this_onResolve.getIncoming(), (Object)incoming)) {
                        ResolvableDependencies resolvableDependencies = incoming;
                        Intrinsics.checkNotNullExpressionValue((Object)resolvableDependencies, (String)"incoming");
                        ResolvableDependencies it = resolvableDependencies;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)this.$conf$inlined, (String)"conf");
                        Intrinsics.checkNotNullExpressionValue((Object)this.$extension$inlined, (String)"extension");
                        Intrinsics.checkNotNullExpressionValue((Object)this.$overrides$inlined, (String)"overrides");
                        DependencyLockPlugin.access$maybeApplyLock(this.this$0, this.$conf$inlined, this.$extension$inlined, this.$overrides$inlined, this.$globalLockFilename$inlined, this.$lockFilename$inlined);
                    }
                }
            });
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)conf, (String)"conf");
            Intrinsics.checkNotNullExpressionValue((Object)$extension, (String)"extension");
            Intrinsics.checkNotNullExpressionValue((Object)$overrides, (String)"overrides");
            this$0.maybeApplyLock(conf, $extension, $overrides, $globalLockFilename, $lockFilename);
        }
    }

    private static final void disableCachingForGenerateLock$lambda-4(Configuration configuration) {
        if (configuration.getState() == Configuration.State.UNRESOLVED) {
            ResolutionStrategy resolutionStrategy = configuration.getResolutionStrategy();
            boolean bl = false;
            boolean bl2 = false;
            ResolutionStrategy $this$disableCachingForGenerateLock_u24lambda_u2d4_u24lambda_u2d3 = resolutionStrategy;
            boolean bl3 = false;
            $this$disableCachingForGenerateLock_u24lambda_u2d4_u24lambda_u2d3.cacheDynamicVersionsFor(0, "seconds");
            $this$disableCachingForGenerateLock_u24lambda_u2d4_u24lambda_u2d3.cacheChangingModulesFor(0, "seconds");
        }
    }

    private static final void lockConfiguration$lambda-13(DependencyLockPlugin this$0, Map $selectorsByKey, DependencyResolveDetails details) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$selectorsByKey, (String)"$selectorsByKey");
        Intrinsics.checkNotNullExpressionValue((Object)details, (String)"details");
        ModuleVersionSelectorKey moduleKey = this$0.toKey(details);
        ModuleVersionSelectorKey module = (ModuleVersionSelectorKey)$selectorsByKey.get(moduleKey);
        if (module != null) {
            DependencyResolveDetails dependencyResolveDetails = details.because(moduleKey.toModuleString() + " locked to " + module.getVersion() + "\n\twith reasons: " + CollectionsKt.joinToString$default((Iterable)this$0.getReasons(), null, null, null, (int)0, null, null, (int)63, null));
            String string = module.getVersion();
            Intrinsics.checkNotNull((Object)string);
            dependencyResolveDetails.useVersion(string);
        }
    }

    public static final /* synthetic */ void access$disableCachingForGenerateLock(DependencyLockPlugin $this) {
        $this.disableCachingForGenerateLock();
    }

    public static final /* synthetic */ void access$maybeApplyLock(DependencyLockPlugin $this, Configuration conf, DependencyLockExtension extension, Map overrides, String globalLockFileName, String lockFilename) {
        $this.maybeApplyLock(conf, extension, overrides, globalLockFileName, lockFilename);
    }

    static {
        Object[] objectArray = new String[]{GENERATE_LOCK_TASK_NAME, GENERATE_GLOBAL_LOCK_TASK_NAME, UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME};
        GENERATION_TASK_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME};
        UPDATE_TASK_NAMES = SetsKt.setOf((Object[])objectArray);
        MIGRATION_TASK_NAMES = SetsKt.setOf((Object)MIGRATE_TO_CORE_LOCK_TASK_NAME);
        boolean bl = false;
        lockedDepsPerProjectForConfigurations = new LinkedHashMap();
        bl = false;
        overrideDepsPerProjectForConfigurations = new LinkedHashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0011\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R/\u0010\u001b\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R/\u0010!\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001c0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 \u00a8\u0006#"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$Companion;", "", "()V", "COMMIT_EXTENSION_NAME", "", "DEPENDENCY_RESOLTION_VERIFIER_EXTENSION", "EXTENSION_NAME", "GENERATE_GLOBAL_LOCK_TASK_NAME", "GENERATE_LOCK_TASK_NAME", "GENERATION_TASK_NAMES", "", "getGENERATION_TASK_NAMES", "()Ljava/util/Set;", "GLOBAL_LOCK_FILE", "LOCK_AFTER_EVALUATING", "LOCK_FILE", "MIGRATE_TO_CORE_LOCK_TASK_NAME", "MIGRATION_TASK_NAMES", "getMIGRATION_TASK_NAMES", "OVERRIDE", "OVERRIDE_FILE", "UPDATE_DEPENDENCIES", "UPDATE_GLOBAL_LOCK_TASK_NAME", "UPDATE_LOCK_TASK_NAME", "UPDATE_TASK_NAMES", "getUPDATE_TASK_NAMES", "WRITE_CORE_LOCK_TASK_TO_RUN", "lockedDepsPerProjectForConfigurations", "", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "getLockedDepsPerProjectForConfigurations", "()Ljava/util/Map;", "overrideDepsPerProjectForConfigurations", "getOverrideDepsPerProjectForConfigurations", "gradle-dependency-lock-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getGENERATION_TASK_NAMES() {
            return GENERATION_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getUPDATE_TASK_NAMES() {
            return UPDATE_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getMIGRATION_TASK_NAMES() {
            return MIGRATION_TASK_NAMES;
        }

        @NotNull
        public final Map<String, Map<String, List<ModuleVersionSelectorKey>>> getLockedDepsPerProjectForConfigurations() {
            return lockedDepsPerProjectForConfigurations;
        }

        @NotNull
        public final Map<String, Map<String, List<ModuleVersionSelectorKey>>> getOverrideDepsPerProjectForConfigurations() {
            return overrideDepsPerProjectForConfigurations;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0011J\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "", "group", "", "name", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "getVersion", "equals", "", "other", "hashCode", "", "toMap", "", "toModuleString", "toString", "Companion", "gradle-dependency-lock-plugin"})
    public static final class ModuleVersionSelectorKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @Nullable
        private final String version;

        public ModuleVersionSelectorKey(@NotNull String group, @NotNull String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.group, this.name};
            return Objects.hash(objectArray);
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            return object instanceof ModuleVersionSelectorKey ? Intrinsics.areEqual((Object)this.group, (Object)((ModuleVersionSelectorKey)other).group) && Intrinsics.areEqual((Object)this.name, (Object)((ModuleVersionSelectorKey)other).name) : false;
        }

        @NotNull
        public final Map<String, String> toMap() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)this.group), TuplesKt.to((Object)"name", (Object)this.name), TuplesKt.to((Object)"version", (Object)this.version)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public final String toModuleString() {
            return this.group + ':' + this.name;
        }

        @NotNull
        public String toString() {
            return this.group + ':' + this.name + ':' + this.version;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0007"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey$Companion;", "", "()V", "create", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "notation", "version", "gradle-dependency-lock-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ModuleVersionSelectorKey create(@Nullable Object notation, @Nullable Object version) {
                if (notation == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                String cfr_ignored_0 = (String)notation;
                String group = StringsKt.substringBefore$default((String)((String)notation), (String)":", null, (int)2, null);
                String name = StringsKt.substringAfter$default((String)((String)notation), (String)":", null, (int)2, null);
                if (version == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                return new ModuleVersionSelectorKey(group, name, (String)version);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

