/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencylock;

import groovy.lang.Closure;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockCommitExtension;
import nebula.plugin.dependencylock.DependencyLockExtension;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.DependencyLockReader;
import nebula.plugin.dependencylock.DependencyLockTaskConfigurer;
import nebula.plugin.dependencylock.GradleInteropKt;
import nebula.plugin.dependencylock.exceptions.DependencyLockException;
import nebula.plugin.dependencylock.model.LockKey;
import nebula.plugin.dependencylock.model.LockValue;
import nebula.plugin.dependencylock.utils.CoreLockingHelper;
import nebula.plugin.dependencylock.utils.DependencyLockingFeatureFlags;
import nebula.plugin.dependencylock.utils.NameMatcher;
import nebula.plugin.dependencylock.validation.UpdateDependenciesValidator;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifier;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifierExtension;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002ABB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0002J \u0010$\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010,\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J$\u0010-\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010/\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u001e\u00100\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J<\u00104\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\b\u00107\u001a\u0004\u0018\u00010\r2\b\u00108\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020!H\u0002J\u0016\u0010<\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\r02H\u0002J\u0010\u0010>\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0002J\f\u0010?\u001a\u000203*\u00020@H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006C"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "lockReader", "Lnebula/plugin/dependencylock/DependencyLockReader;", "getLockReader", "()Lnebula/plugin/dependencylock/DependencyLockReader;", "setLockReader", "(Lnebula/plugin/dependencylock/DependencyLockReader;)V", "lockUsed", "", "getLockUsed", "()Ljava/lang/String;", "setLockUsed", "(Ljava/lang/String;)V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "reasons", "", "getReasons", "()Ljava/util/Set;", "apply", "", "applyLock", "conf", "Lorg/gradle/api/artifacts/Configuration;", "dependenciesLock", "Ljava/io/File;", "updates", "", "applyOverrides", "overrides", "", "disableCachingForGenerateLock", "hasGenerationTask", "", "cliTasks", "", "hasMigrationTask", "hasTask", "taskNames", "hasUpdateTask", "lockConfiguration", "selectorKeys", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "maybeApplyLock", "extension", "Lnebula/plugin/dependencylock/DependencyLockExtension;", "globalLockFileName", "lockFilename", "parseUpdates", "rewriteLocksUsingCoreLocking", "lockFile", "taskRunOnThisProject", "tokens", "uniqueProjectKey", "toKey", "Lorg/gradle/api/artifacts/DependencyResolveDetails;", "Companion", "ModuleVersionSelectorKey", "gradle-dependency-lock-plugin"})
public final class DependencyLockPlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOGGER;
    public Project project;
    public DependencyLockReader lockReader;
    public String lockUsed;
    @NotNull
    private final Set<String> reasons;
    @NotNull
    public static final String EXTENSION_NAME = "dependencyLock";
    @NotNull
    public static final String COMMIT_EXTENSION_NAME = "commitDependencyLock";
    @NotNull
    public static final String DEPENDENCY_RESOLTION_VERIFIER_EXTENSION = "dependencyResolutionVerifierExtension";
    @NotNull
    public static final String LOCK_FILE = "dependencyLock.lockFile";
    @NotNull
    public static final String GLOBAL_LOCK_FILE = "dependencyLock.globalLockFile";
    @NotNull
    public static final String LOCK_AFTER_EVALUATING = "dependencyLock.lockAfterEvaluating";
    @NotNull
    public static final String UPDATE_DEPENDENCIES = "dependencyLock.updateDependencies";
    @NotNull
    public static final String VALIDATE_DEPENDENCY_COORDINATES = "dependencyLock.updateDependenciesFailOnInvalidCoordinates";
    @NotNull
    public static final String VALIDATE_SIMULTANEOUS_TASKS = "dependencyLock.updateDependenciesFailOnSimultaneousTaskUsage";
    @NotNull
    public static final String VALIDATE_SPECIFIED_DEPENDENCIES_TO_UPDATE = "dependencyLock.updateDependenciesFailOnNonSpecifiedDependenciesToUpdate";
    @NotNull
    public static final String OVERRIDE = "dependencyLock.override";
    @NotNull
    public static final String OVERRIDE_FILE = "dependencyLock.overrideFile";
    @NotNull
    public static final String GENERATE_GLOBAL_LOCK_TASK_NAME = "generateGlobalLock";
    @NotNull
    public static final String UPDATE_GLOBAL_LOCK_TASK_NAME = "updateGlobalLock";
    @NotNull
    public static final String GENERATE_LOCK_TASK_NAME = "generateLock";
    @NotNull
    public static final String UPDATE_LOCK_TASK_NAME = "updateLock";
    @NotNull
    public static final String MIGRATE_TO_CORE_LOCK_TASK_NAME = "migrateToCoreLocks";
    @NotNull
    public static final String WRITE_CORE_LOCK_TASK_TO_RUN = "`./gradlew dependencies --write-locks`";
    @NotNull
    private static final Set<String> GENERATION_TASK_NAMES;
    @NotNull
    private static final Set<String> UPDATE_TASK_NAMES;
    @NotNull
    private static final Set<String> MIGRATION_TASK_NAMES;
    @NotNull
    private static final Map<String, Map<String, List<ModuleVersionSelectorKey>>> lockedDepsPerProjectForConfigurations;
    @NotNull
    private static final Map<String, Map<String, List<ModuleVersionSelectorKey>>> overrideDepsPerProjectForConfigurations;

    public DependencyLockPlugin() {
        Logger logger2 = Logging.getLogger(DependencyLockPlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(DependencyLockPlugin::class.java)");
        this.LOGGER = logger2;
        this.reasons = new LinkedHashSet();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyLockReader getLockReader() {
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader != null) {
            return dependencyLockReader;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        return null;
    }

    public final void setLockReader(@NotNull DependencyLockReader dependencyLockReader) {
        Intrinsics.checkNotNullParameter((Object)dependencyLockReader, (String)"<set-?>");
        this.lockReader = dependencyLockReader;
    }

    @NotNull
    public final String getLockUsed() {
        String string = this.lockUsed;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        return null;
    }

    public final void setLockUsed(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.lockUsed = string;
    }

    @NotNull
    public final Set<String> getReasons() {
        return this.reasons;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
        this.setLockReader(new DependencyLockReader(project));
        DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = (DependencyResolutionVerifierExtension)project.getRootProject().getExtensions().findByType(DependencyResolutionVerifierExtension.class);
        if (dependencyResolutionVerifierExtension == null) {
            dependencyResolutionVerifierExtension = (DependencyResolutionVerifierExtension)project.getRootProject().getExtensions().create(DEPENDENCY_RESOLTION_VERIFIER_EXTENSION, DependencyResolutionVerifierExtension.class, new Object[0]);
        }
        lockedDepsPerProjectForConfigurations.put(this.uniqueProjectKey(project), new LinkedHashMap());
        overrideDepsPerProjectForConfigurations.put(this.uniqueProjectKey(project), new LinkedHashMap());
        StartParameter startParameter = project.getGradle().getStartParameter();
        Intrinsics.checkNotNull((Object)startParameter, (String)"null cannot be cast to non-null type org.gradle.api.internal.StartParameterInternal");
        StartParameterInternal startParameter2 = (StartParameterInternal)startParameter;
        boolean isMigratingToCoreLocks = startParameter2.getTaskNames().contains(MIGRATE_TO_CORE_LOCK_TASK_NAME);
        boolean isConfigurationCache = false;
        try {
            Method method = StartParameterInternal.class.getMethod("isConfigurationCache", new Class[0]);
            Object object = method.invoke((Object)startParameter2, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            isConfigurationCache = (Boolean)object;
        }
        catch (Exception method) {
            // empty catch block
        }
        if (!isMigratingToCoreLocks && !isConfigurationCache) {
            new DependencyResolutionVerifier().verifySuccessfulResolution(project);
        }
        DependencyLockExtension extension = (DependencyLockExtension)project.getExtensions().create(EXTENSION_NAME, DependencyLockExtension.class, new Object[0]);
        DependencyLockCommitExtension commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().findByType(DependencyLockCommitExtension.class);
        if (commitExtension == null) {
            commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().create(COMMIT_EXTENSION_NAME, DependencyLockCommitExtension.class, new Object[0]);
        }
        Map overrides = this.getLockReader().readOverrides();
        String globalLockFilename = GradleInteropKt.findStringProperty(project, GLOBAL_LOCK_FILE);
        String lockFilename = GradleInteropKt.findStringProperty(project, LOCK_FILE);
        new DependencyLockTaskConfigurer(project).configureTasks(globalLockFilename, lockFilename, extension, commitExtension, overrides);
        if (DependencyLockingFeatureFlags.isCoreLockingEnabled()) {
            List taskNames;
            this.LOGGER.info(project.getName() + ": coreLockingSupport feature enabled");
            CoreLockingHelper coreLockingHelper = new CoreLockingHelper(project);
            coreLockingHelper.lockSelectedConfigurations(extension.getConfigurationNames());
            coreLockingHelper.disableCachingWhenUpdatingDependencies();
            coreLockingHelper.notifyWhenUsingOfflineMode();
            File lockFile = new File(project.getProjectDir(), extension.getLockFile());
            if (lockFile.exists()) {
                if (startParameter2.isWriteDependencyLocks()) {
                    this.rewriteLocksUsingCoreLocking(lockFile);
                } else {
                    taskNames = startParameter2.getTaskNames();
                    Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
                    boolean hasMigrationTask = this.hasMigrationTask(taskNames);
                    if (!hasMigrationTask) {
                        throw new BuildCancelledException("Legacy locks are not supported with core locking.\nIf you wish to migrate with the current locked dependencies, please use `./gradlew migrateToCoreLocks`\nAlternatively, please remove the legacy lockfile manually and use `./gradlew dependencies --write-locks`\n - Legacy lock: " + lockFile.getAbsolutePath());
                    }
                }
            }
            taskNames = startParameter2.getTaskNames();
            Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(taskNames);
            boolean hasGenerationTask = this.hasGenerationTask(taskNames);
            File globalLockFile = new File(project.getProjectDir(), extension.getGlobalLockFile());
            if (globalLockFile.exists() && !hasGenerationTask && !hasUpdateTask) {
                throw new BuildCancelledException("Legacy global locks are not supported with core locking.\nPlease remove global locks.\n - Legacy global lock: " + globalLockFile.getAbsolutePath());
            }
        } else {
            boolean lockAfterEvaluating;
            boolean bl = lockAfterEvaluating = project.hasProperty(LOCK_AFTER_EVALUATING) ? Boolean.parseBoolean(String.valueOf(project.property(LOCK_AFTER_EVALUATING))) : extension.getLockAfterEvaluating();
            if (lockAfterEvaluating) {
                this.LOGGER.info("Delaying dependency lock apply until beforeResolve (dependencyLock.lockAfterEvaluating set to true)");
            } else {
                this.LOGGER.info("Applying dependency lock during plugin apply (dependencyLock.lockAfterEvaluating set to false)");
            }
            this.disableCachingForGenerateLock();
            DependencyLockPlugin $this$groovyClosure$iv = this;
            boolean $i$f$groovyClosure = false;
            project.getGradle().getTaskGraph().whenReady((Closure)new Closure<Unit>((Object)$this$groovyClosure$iv, this){
                final /* synthetic */ DependencyLockPlugin this$0;
                {
                    this.this$0 = dependencyLockPlugin;
                    super($receiver);
                }

                public final void doCall() {
                    boolean bl = false;
                    DependencyLockPlugin.access$disableCachingForGenerateLock(this.this$0);
                }
            });
            project.getConfigurations().all(arg_0 -> DependencyLockPlugin.apply$lambda$1((Function1)new Function1<Configuration, Unit>(lockAfterEvaluating, this, extension, overrides, globalLockFilename, lockFilename){
                final /* synthetic */ boolean $lockAfterEvaluating;
                final /* synthetic */ DependencyLockPlugin this$0;
                final /* synthetic */ DependencyLockExtension $extension;
                final /* synthetic */ Map $overrides;
                final /* synthetic */ String $globalLockFilename;
                final /* synthetic */ String $lockFilename;
                {
                    this.$lockAfterEvaluating = $lockAfterEvaluating;
                    this.this$0 = $receiver;
                    this.$extension = $extension;
                    this.$overrides = $overrides;
                    this.$globalLockFilename = $globalLockFilename;
                    this.$lockFilename = $lockFilename;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(Configuration conf) {
                    if (this.$lockAfterEvaluating) {
                        void $this$onResolve$iv;
                        Intrinsics.checkNotNullExpressionValue((Object)conf, (String)"conf");
                        Configuration configuration = conf;
                        DependencyLockPlugin dependencyLockPlugin = this.this$0;
                        DependencyLockExtension dependencyLockExtension = this.$extension;
                        Map map = this.$overrides;
                        String string = this.$globalLockFilename;
                        String string2 = this.$lockFilename;
                        boolean $i$f$onResolve = false;
                        Function1 function1 = (Function1)new Function1<ResolvableDependencies, Unit>((Configuration)$this$onResolve$iv, dependencyLockPlugin, conf, dependencyLockExtension, map, string, string2){
                            final /* synthetic */ Configuration $this_onResolve;
                            final /* synthetic */ DependencyLockPlugin this$0;
                            final /* synthetic */ Configuration $conf$inlined;
                            final /* synthetic */ DependencyLockExtension $extension$inlined;
                            final /* synthetic */ Map $overrides$inlined;
                            final /* synthetic */ String $globalLockFilename$inlined;
                            final /* synthetic */ String $lockFilename$inlined;
                            {
                                this.$this_onResolve = $receiver;
                                this.this$0 = dependencyLockPlugin;
                                this.$conf$inlined = configuration;
                                this.$extension$inlined = dependencyLockExtension;
                                this.$overrides$inlined = map;
                                this.$globalLockFilename$inlined = string;
                                this.$lockFilename$inlined = string2;
                                super(1);
                            }

                            public final void invoke(ResolvableDependencies incoming) {
                                if (Intrinsics.areEqual((Object)this.$this_onResolve.getIncoming(), (Object)incoming)) {
                                    Intrinsics.checkNotNullExpressionValue((Object)incoming, (String)"incoming");
                                    ResolvableDependencies it = incoming;
                                    boolean bl = false;
                                    Intrinsics.checkNotNullExpressionValue((Object)this.$conf$inlined, (String)"conf");
                                    Intrinsics.checkNotNullExpressionValue((Object)this.$extension$inlined, (String)"extension");
                                    Intrinsics.checkNotNullExpressionValue((Object)this.$overrides$inlined, (String)"overrides");
                                    DependencyLockPlugin.access$maybeApplyLock(this.this$0, this.$conf$inlined, this.$extension$inlined, this.$overrides$inlined, this.$globalLockFilename$inlined, this.$lockFilename$inlined);
                                }
                            }
                        };
                        $this$onResolve$iv.getIncoming().beforeResolve(new Action(function1){
                            private final /* synthetic */ Function1 function;
                            {
                                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                                this.function = function;
                            }

                            public final /* synthetic */ void execute(Object p0) {
                                this.function.invoke(p0);
                            }
                        });
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)conf, (String)"conf");
                        DependencyLockExtension dependencyLockExtension = this.$extension;
                        Intrinsics.checkNotNullExpressionValue((Object)dependencyLockExtension, (String)"extension");
                        Map map = this.$overrides;
                        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"overrides");
                        DependencyLockPlugin.access$maybeApplyLock(this.this$0, conf, dependencyLockExtension, map, this.$globalLockFilename, this.$lockFilename);
                    }
                }
            }, arg_0));
        }
    }

    private final void disableCachingForGenerateLock() {
        List list = this.getProject().getGradle().getStartParameter().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"project.gradle.startParameter.taskNames");
        if (this.hasGenerationTask(list)) {
            this.getProject().getConfigurations().all(arg_0 -> DependencyLockPlugin.disableCachingForGenerateLock$lambda$2(disableCachingForGenerateLock.1.INSTANCE, arg_0));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void maybeApplyLock(Configuration conf, DependencyLockExtension extension, Map<?, ?> overrides, String globalLockFileName, String lockFilename) {
        Set<String> set;
        File file;
        File globalLock;
        boolean shouldIgnoreLock;
        boolean bl;
        Set<String> set2 = extension.getSkippedConfigurationNamesPrefixes();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"extension.skippedConfigurationNamesPrefixes");
        Set<String> set3 = DependencyLockTaskConfigurer.configurationsToSkipForGlobalLockPrefixes;
        Intrinsics.checkNotNullExpressionValue(set3, (String)"configurationsToSkipForGlobalLockPrefixes");
        Iterable $this$any$iv = SetsKt.plus(set2, (Iterable)set3);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                String prefix = (String)element$iv;
                boolean bl2 = false;
                String string = conf.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conf.name");
                Intrinsics.checkNotNullExpressionValue((Object)prefix, (String)"prefix");
                if (StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) {
                    String string2 = conf.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"conf.name");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"resolutionRules", (boolean)false, (int)2, null)) {
                        return;
                    }
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return;
            }
            bl = shouldIgnoreLock = false;
        }
        if (shouldIgnoreLock) {
            return;
        }
        File file2 = this.getProject().getRootProject().getProjectDir();
        String string = globalLockFileName;
        if (string == null) {
            string = extension.getGlobalLockFile();
        }
        if ((globalLock = new File(file2, string)).exists()) {
            file = globalLock;
        } else {
            File file3 = this.getProject().getProjectDir();
            String string3 = lockFilename;
            if (string3 == null) {
                string3 = extension.getLockFile();
            }
            file = new File(file3, string3);
        }
        File dependenciesLock = file;
        String string4 = dependenciesLock.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"dependenciesLock.name");
        this.setLockUsed(string4);
        this.reasons.add("com.netflix.nebula.dependency-lock locked with: " + this.getLockUsed());
        if (DependencyLockTaskConfigurer.shouldIgnoreDependencyLock(this.getProject())) return;
        List taskNames = this.getProject().getGradle().getStartParameter().getTaskNames();
        Intrinsics.checkNotNullExpressionValue((Object)taskNames, (String)"taskNames");
        boolean hasUpdateTask = this.hasUpdateTask(taskNames);
        if (this.getProject().hasProperty(UPDATE_DEPENDENCIES)) {
            Object object = this.getProject().property(UPDATE_DEPENDENCIES);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            set = this.parseUpdates((String)object);
        } else {
            set = extension.getUpdateDependencies();
        }
        Set<String> updates = set;
        Intrinsics.checkNotNullExpressionValue(updates, (String)"updates");
        UpdateDependenciesValidator.Companion.validate(updates, overrides, hasUpdateTask, this.hasTask(taskNames, SetsKt.minus(GENERATION_TASK_NAMES, (Iterable)UPDATE_TASK_NAMES)), this.getProject(), extension);
        String projectCoord = this.getProject().getGroup() + ':' + this.getProject().getName();
        if (hasUpdateTask) {
            boolean bl4;
            block21: {
                Iterable $this$any$iv2 = updates;
                boolean $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)projectCoord)) continue;
                        bl4 = true;
                        break block21;
                    }
                    bl4 = false;
                }
            }
            if (bl4) {
                throw new DependencyLockException("Dependency locks cannot be updated. An update was requested for a project dependency (" + projectCoord + ')');
            }
        }
        boolean hasGenerateTask = this.hasGenerationTask(taskNames);
        if (dependenciesLock.exists()) {
            if (!hasGenerateTask) {
                DependencyLockPlugin.applyLock$default(this, conf, dependenciesLock, null, 4, null);
            } else if (hasUpdateTask) {
                this.applyLock(conf, dependenciesLock, updates);
            }
        }
        this.applyOverrides(conf, overrides);
    }

    private final boolean hasGenerationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)GENERATION_TASK_NAMES);
    }

    private final boolean hasUpdateTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)UPDATE_TASK_NAMES);
    }

    private final boolean hasMigrationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)MIGRATION_TASK_NAMES);
    }

    private final boolean hasTask(Collection<String> cliTasks, Collection<String> taskNames) {
        Object v0;
        block1: {
            NameMatcher matcher = new NameMatcher();
            Iterable iterable = cliTasks;
            for (Object t : iterable) {
                String cliTaskName = (String)t;
                boolean bl = false;
                String[] stringArray = new String[]{":"};
                List tokens = StringsKt.split$default((CharSequence)cliTaskName, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String taskName = (String)CollectionsKt.last((List)tokens);
                String generatesPresent = matcher.find(taskName, taskNames);
                if (!(generatesPresent != null && this.taskRunOnThisProject(tokens))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        String found = v0;
        return found != null;
    }

    private final boolean taskRunOnThisProject(List<String> tokens) {
        if (tokens.size() == 1) {
            return true;
        }
        if (tokens.size() == 2 && Intrinsics.areEqual((Object)tokens.get(0), (Object)"")) {
            return Intrinsics.areEqual((Object)this.getProject(), (Object)this.getProject().getRootProject());
        }
        return Intrinsics.areEqual((Object)this.getProject().getName(), (Object)tokens.get(tokens.size() - 2));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> parseUpdates(String updates) {
        void $this$filterTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)updates, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void applyLock(Configuration conf, File dependenciesLock, Set<String> updates) {
        Object dependency;
        this.LOGGER.info("Using " + dependenciesLock.getName() + " to lock dependencies in " + conf);
        Map deps2 = MapsKt.withDefaultMutable((Map)new LinkedHashMap(), (Function1)applyLock.deps.1.INSTANCE);
        DomainObjectSet externalDependencies = conf.getAllDependencies().withType(ExternalDependency.class);
        Intrinsics.checkNotNullExpressionValue((Object)externalDependencies, (String)"externalDependencies");
        Iterable $this$forEach$iv = (Iterable)externalDependencies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            dependency = (ExternalDependency)element$iv;
            boolean bl = false;
            LockKey key = new LockKey(dependency.getGroup(), dependency.getName(), conf.getName());
            deps2.put(key, new LockValue());
            Object v = deps2.get(key);
            Intrinsics.checkNotNull(v);
            ((LockValue)v).setRequested(dependency.getVersion());
        }
        Map locks = this.getLockReader().readLocks(conf, dependenciesLock, deps2, (Collection<String>)updates);
        if (locks != null) {
            Map<String, List<ModuleVersionSelectorKey>> lockedDepsByConf;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map map;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv = locks;
            boolean $i$f$filter = false;
            dependency = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                map = (Map)v;
                if (!map.containsKey("locked")) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                Object v = it.getValue();
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                map = (Map)v;
                Object version = map.get("locked");
                object.add(ModuleVersionSelectorKey.Companion.create(it.getKey(), version));
            }
            List locked = (List)destination$iv$iv;
            this.LOGGER.debug("locked: {}", (Object)locked);
            this.lockConfiguration(conf, locked);
            Map<String, List<ModuleVersionSelectorKey>> map2 = lockedDepsByConf = lockedDepsPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
            Intrinsics.checkNotNull(map2);
            Map<String, List<ModuleVersionSelectorKey>> map3 = map2;
            String string = conf.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conf.name");
            map3.put(string, locked);
        }
    }

    static /* synthetic */ void applyLock$default(DependencyLockPlugin dependencyLockPlugin, Configuration configuration, File file, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        dependencyLockPlugin.applyLock(configuration, file, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyOverrides(Configuration conf, Map<?, ?> overrides) {
        Map<String, List<ModuleVersionSelectorKey>> overrideDepsByConf;
        void $this$mapTo$iv$iv;
        if (this.getProject().hasProperty(OVERRIDE_FILE)) {
            this.LOGGER.info("Using override file " + this.getProject().property(OVERRIDE_FILE) + " to lock dependencies");
            this.reasons.add("com.netflix.nebula.dependency-lock using override file: " + this.getProject().property(OVERRIDE_FILE));
        }
        if (this.getProject().hasProperty(OVERRIDE)) {
            this.LOGGER.info("Using command line overrides " + this.getProject().property(OVERRIDE));
            this.reasons.add("com.netflix.nebula.dependency-lock using override: " + this.getProject().property(OVERRIDE));
        }
        Map<?, ?> $this$map$iv = overrides;
        boolean $i$f$map = false;
        Map<?, ?> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ModuleVersionSelectorKey.Companion.create(it.getKey(), it.getValue()));
        }
        List overrideDeps = (List)destination$iv$iv;
        this.LOGGER.debug("overrides: {}", (Object)overrideDeps);
        this.lockConfiguration(conf, overrideDeps);
        Map<String, List<ModuleVersionSelectorKey>> map2 = overrideDepsByConf = overrideDepsPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Intrinsics.checkNotNull(map2);
        Map<String, List<ModuleVersionSelectorKey>> map3 = map2;
        String string = conf.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conf.name");
        map3.put(string, overrideDeps);
    }

    /*
     * WARNING - void declaration
     */
    private final void lockConfiguration(Configuration conf, List<ModuleVersionSelectorKey> selectorKeys) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object value$iv$iv$iv;
        Object key$iv$iv;
        void $this$groupByTo$iv$iv;
        Object $this$groupBy$iv = selectorKeys;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            ModuleVersionSelectorKey it = (ModuleVersionSelectorKey)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = map;
            boolean bl3 = false;
            ModuleVersionSelectorKey moduleVersionSelectorKey = (ModuleVersionSelectorKey)it.getKey();
            map2.put(k, moduleVersionSelectorKey);
        }
        Map selectorsByKey = destination$iv$iv;
        conf.getResolutionStrategy().eachDependency(arg_0 -> DependencyLockPlugin.lockConfiguration$lambda$13((Function1)new Function1<DependencyResolveDetails, Unit>(this, (Map<ModuleVersionSelectorKey, ModuleVersionSelectorKey>)selectorsByKey){
            final /* synthetic */ DependencyLockPlugin this$0;
            final /* synthetic */ Map<ModuleVersionSelectorKey, ModuleVersionSelectorKey> $selectorsByKey;
            {
                this.this$0 = $receiver;
                this.$selectorsByKey = $selectorsByKey;
                super(1);
            }

            public final void invoke(DependencyResolveDetails details) {
                Intrinsics.checkNotNullExpressionValue((Object)details, (String)"details");
                ModuleVersionSelectorKey moduleKey = DependencyLockPlugin.access$toKey(this.this$0, details);
                ModuleVersionSelectorKey module = this.$selectorsByKey.get(moduleKey);
                if (module != null) {
                    DependencyResolveDetails dependencyResolveDetails = details.because(moduleKey.toModuleString() + " locked to " + module.getVersion() + "\n\twith reasons: " + CollectionsKt.joinToString$default((Iterable)this.this$0.getReasons(), null, null, null, (int)0, null, null, (int)63, null));
                    String string = module.getVersion();
                    Intrinsics.checkNotNull((Object)string);
                    dependencyResolveDetails.useVersion(string);
                }
            }
        }, arg_0));
    }

    private final ModuleVersionSelectorKey toKey(DependencyResolveDetails $this$toKey) {
        String string = $this$toKey.getRequested().getGroup();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requested.group");
        String string2 = $this$toKey.getRequested().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requested.name");
        return new ModuleVersionSelectorKey(string, string2, $this$toKey.getRequested().getVersion());
    }

    private final void rewriteLocksUsingCoreLocking(File lockFile) {
        File dependencyLockDirectory = new File(this.getProject().getProjectDir(), "/gradle/dependency-locks");
        this.LOGGER.warn("Removing legacy locks to use core Gradle locking. This will remove legacy locks.This is not a migration.\n - Legacy lock: " + lockFile.getAbsolutePath() + "\n - Core Gradle locks: " + dependencyLockDirectory.getAbsoluteFile() + "\n\nTo migrate your currently locked state, please run `./gradlew migrateToCoreLocks`");
        String failureToDeleteLockfileMessage = "Failed to delete legacy locks.\nPlease remove the legacy lock file manually.\n - Legacy lock: " + lockFile.getAbsolutePath();
        try {
            if (!lockFile.delete()) {
                throw new BuildCancelledException(failureToDeleteLockfileMessage);
            }
        }
        catch (Exception e) {
            throw new BuildCancelledException(failureToDeleteLockfileMessage, (Throwable)e);
        }
    }

    private final String uniqueProjectKey(Project project) {
        return project.getName() + '-' + (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? "rootproject" : "subproject");
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void disableCachingForGenerateLock$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void lockConfiguration$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$maybeApplyLock(DependencyLockPlugin $this, Configuration conf, DependencyLockExtension extension, Map overrides, String globalLockFileName, String lockFilename) {
        $this.maybeApplyLock(conf, extension, overrides, globalLockFileName, lockFilename);
    }

    public static final /* synthetic */ ModuleVersionSelectorKey access$toKey(DependencyLockPlugin $this, DependencyResolveDetails $receiver) {
        return $this.toKey($receiver);
    }

    public static final /* synthetic */ void access$disableCachingForGenerateLock(DependencyLockPlugin $this) {
        $this.disableCachingForGenerateLock();
    }

    static {
        Object[] objectArray = new String[]{GENERATE_LOCK_TASK_NAME, GENERATE_GLOBAL_LOCK_TASK_NAME, UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME};
        GENERATION_TASK_NAMES = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME};
        UPDATE_TASK_NAMES = SetsKt.setOf((Object[])objectArray);
        MIGRATION_TASK_NAMES = SetsKt.setOf((Object)MIGRATE_TO_CORE_LOCK_TASK_NAME);
        lockedDepsPerProjectForConfigurations = new LinkedHashMap();
        overrideDepsPerProjectForConfigurations = new LinkedHashMap();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0014\n\u0002\u0010%\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R/\u0010\u001e\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R/\u0010$\u001a \u0012\u0004\u0012\u00020\u0004\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020!0 0\u001f0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010#\u00a8\u0006&"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$Companion;", "", "()V", "COMMIT_EXTENSION_NAME", "", "DEPENDENCY_RESOLTION_VERIFIER_EXTENSION", "EXTENSION_NAME", "GENERATE_GLOBAL_LOCK_TASK_NAME", "GENERATE_LOCK_TASK_NAME", "GENERATION_TASK_NAMES", "", "getGENERATION_TASK_NAMES", "()Ljava/util/Set;", "GLOBAL_LOCK_FILE", "LOCK_AFTER_EVALUATING", "LOCK_FILE", "MIGRATE_TO_CORE_LOCK_TASK_NAME", "MIGRATION_TASK_NAMES", "getMIGRATION_TASK_NAMES", "OVERRIDE", "OVERRIDE_FILE", "UPDATE_DEPENDENCIES", "UPDATE_GLOBAL_LOCK_TASK_NAME", "UPDATE_LOCK_TASK_NAME", "UPDATE_TASK_NAMES", "getUPDATE_TASK_NAMES", "VALIDATE_DEPENDENCY_COORDINATES", "VALIDATE_SIMULTANEOUS_TASKS", "VALIDATE_SPECIFIED_DEPENDENCIES_TO_UPDATE", "WRITE_CORE_LOCK_TASK_TO_RUN", "lockedDepsPerProjectForConfigurations", "", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "getLockedDepsPerProjectForConfigurations", "()Ljava/util/Map;", "overrideDepsPerProjectForConfigurations", "getOverrideDepsPerProjectForConfigurations", "gradle-dependency-lock-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getGENERATION_TASK_NAMES() {
            return GENERATION_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getUPDATE_TASK_NAMES() {
            return UPDATE_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getMIGRATION_TASK_NAMES() {
            return MIGRATION_TASK_NAMES;
        }

        @NotNull
        public final Map<String, Map<String, List<ModuleVersionSelectorKey>>> getLockedDepsPerProjectForConfigurations() {
            return lockedDepsPerProjectForConfigurations;
        }

        @NotNull
        public final Map<String, Map<String, List<ModuleVersionSelectorKey>>> getOverrideDepsPerProjectForConfigurations() {
            return overrideDepsPerProjectForConfigurations;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0011J\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "", "group", "", "name", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "getVersion", "equals", "", "other", "hashCode", "", "toMap", "", "toModuleString", "toString", "Companion", "gradle-dependency-lock-plugin"})
    public static final class ModuleVersionSelectorKey {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @Nullable
        private final String version;

        public ModuleVersionSelectorKey(@NotNull String group, @NotNull String name, @Nullable String version) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public int hashCode() {
            Object[] objectArray = new Object[]{this.group, this.name};
            return Objects.hash(objectArray);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ModuleVersionSelectorKey ? Intrinsics.areEqual((Object)this.group, (Object)((ModuleVersionSelectorKey)other).group) && Intrinsics.areEqual((Object)this.name, (Object)((ModuleVersionSelectorKey)other).name) : false;
        }

        @NotNull
        public final Map<String, String> toMap() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"group", (Object)this.group), TuplesKt.to((Object)"name", (Object)this.name), TuplesKt.to((Object)"version", (Object)this.version)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public final String toModuleString() {
            return this.group + ':' + this.name;
        }

        @NotNull
        public String toString() {
            return this.group + ':' + this.name + ':' + this.version;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0007"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey$Companion;", "", "()V", "create", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "notation", "version", "gradle-dependency-lock-plugin"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ModuleVersionSelectorKey create(@Nullable Object notation, @Nullable Object version) {
                Intrinsics.checkNotNull((Object)notation, (String)"null cannot be cast to non-null type kotlin.String");
                String cfr_ignored_0 = (String)notation;
                String group = StringsKt.substringBefore$default((String)((String)notation), (String)":", null, (int)2, null);
                String name = StringsKt.substringAfter$default((String)((String)notation), (String)":", null, (int)2, null);
                Intrinsics.checkNotNull((Object)version, (String)"null cannot be cast to non-null type kotlin.String");
                return new ModuleVersionSelectorKey(group, name, (String)version);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

