/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencyverifier;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.utils.ConfigurationFilters;
import nebula.plugin.dependencylock.utils.DependencyLockingFeatureFlags;
import nebula.plugin.dependencyverifier.DependencyResolutionVerifierExtension;
import nebula.plugin.dependencyverifier.exceptions.DependencyResolutionException;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskState;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.diagnostics.DependencyInsightReportTask;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.locking.LockOutOfDateException;
import org.gradle.internal.resolve.ModuleVersionNotFoundException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\"\u001a\u00020!2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020!H\u0002J(\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u001a00H\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J(\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u0018\u00104\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020+0\u001a00H\u0002J\u001e\u00105\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001b07H\u0002J\b\u00108\u001a\u00020\fH\u0002J\u0010\u00109\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002R#\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006;"}, d2={"Lnebula/plugin/dependencyverifier/DependencyResolutionVerifier;", "", "<init>", "()V", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/gradle/api/logging/Logger;", "logger$delegate", "Lkotlin/Lazy;", "providedErrorMessageForThisProject", "", "project", "Lorg/gradle/api/Project;", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "extension", "Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;", "getExtension", "()Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;", "setExtension", "(Lnebula/plugin/dependencyverifier/DependencyResolutionVerifierExtension;)V", "configurationsToExcludeOverride", "", "", "getConfigurationsToExcludeOverride", "()Ljava/util/Set;", "setConfigurationsToExcludeOverride", "(Ljava/util/Set;)V", "verifySuccessfulResolution", "", "verifyResolution", "collectDependencyResolutionErrorsAfterBuildFailure", "buildResult", "Lorg/gradle/BuildResult;", "collectDependencyResolutionErrorsAfterExecute", "task", "Lorg/gradle/api/Task;", "validateThatResolvedVersionIsLockedVersion", "conf", "Lorg/gradle/api/artifacts/Configuration;", "logOrThrowOnFailedDependencies", "createMessagesForFailedDeps", "", "failedDepsForConfs", "", "createMessagesForLockedDepsOutOfDate", "lockedDepsOutOfDate", "createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion", "depsWhereResolvedVersionIsNotTheLockedVersionByConf", "configurationIsResolvedAndMatches", "configurationsToExclude", "", "unresolvedDependenciesShouldFailTheBuild", "uniqueProjectKey", "Companion", "gradle-dependency-lock-plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyResolutionVerifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyResolutionVerifier.kt\nnebula/plugin/dependencyverifier/DependencyResolutionVerifier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,358:1\n808#2,11:359\n230#2,2:370\n1869#2,2:372\n1222#2,2:374\n1252#2,4:376\n1222#2,2:380\n1252#2,4:382\n1563#2:386\n1634#2,3:387\n1869#2,2:390\n1869#2,2:394\n774#2:398\n865#2,2:399\n216#3,2:392\n216#3,2:396\n*S KotlinDebug\n*F\n+ 1 DependencyResolutionVerifier.kt\nnebula/plugin/dependencyverifier/DependencyResolutionVerifier\n*L\n122#1:359,11\n140#1:370,2\n148#1:372,2\n217#1:374,2\n217#1:376,4\n220#1:380,2\n220#1:382,4\n227#1:386\n227#1:387,3\n227#1:390,2\n310#1:394,2\n87#1:398\n87#1:399,2\n283#1:392,2\n323#1:396,2\n*E\n"})
public final class DependencyResolutionVerifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy logger$delegate = LazyKt.lazy(DependencyResolutionVerifier::logger_delegate$lambda$0);
    private boolean providedErrorMessageForThisProject;
    public Project project;
    public DependencyResolutionVerifierExtension extension;
    public Set<String> configurationsToExcludeOverride;
    @NotNull
    private static Map<String, Map<String, Set<Configuration>>> failedDependenciesPerProjectForConfigurations = new LinkedHashMap();
    @NotNull
    private static Map<String, Set<String>> lockedDepsOutOfDatePerProject = new LinkedHashMap();
    @NotNull
    private static Map<String, Map<String, Set<Configuration>>> depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations = new LinkedHashMap();

    private final Logger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project != null) {
            return project;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        return null;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyResolutionVerifierExtension getExtension() {
        DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension = this.extension;
        if (dependencyResolutionVerifierExtension != null) {
            return dependencyResolutionVerifierExtension;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"extension");
        return null;
    }

    public final void setExtension(@NotNull DependencyResolutionVerifierExtension dependencyResolutionVerifierExtension) {
        Intrinsics.checkNotNullParameter((Object)dependencyResolutionVerifierExtension, (String)"<set-?>");
        this.extension = dependencyResolutionVerifierExtension;
    }

    @NotNull
    public final Set<String> getConfigurationsToExcludeOverride() {
        Set<String> set = this.configurationsToExcludeOverride;
        if (set != null) {
            return set;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"configurationsToExcludeOverride");
        return null;
    }

    public final void setConfigurationsToExcludeOverride(@NotNull Set<String> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.configurationsToExcludeOverride = set;
    }

    public final void verifySuccessfulResolution(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.setProject(project);
        Object object = project.getRootProject().getExtensions().findByType(DependencyResolutionVerifierExtension.class);
        Intrinsics.checkNotNull((Object)object);
        this.setExtension((DependencyResolutionVerifierExtension)object);
        this.setConfigurationsToExcludeOverride(new LinkedHashSet());
        if (project.hasProperty("dependencyResolutionVerifier.configurationsToExclude")) {
            Set<String> set = this.getConfigurationsToExcludeOverride();
            Object object2 = project.property("dependencyResolutionVerifier.configurationsToExclude");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            String[] stringArray = new String[]{","};
            set.addAll(StringsKt.split$default((CharSequence)((String)object2), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        }
        String uniqueProjectKey = this.uniqueProjectKey(project);
        failedDependenciesPerProjectForConfigurations.put(uniqueProjectKey, new LinkedHashMap());
        lockedDepsOutOfDatePerProject.put(uniqueProjectKey, new LinkedHashSet());
        depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.put(uniqueProjectKey, new LinkedHashMap());
        this.verifyResolution(project);
    }

    private final void verifyResolution(Project project) {
        project.getGradle().buildFinished(new Action(this){
            final /* synthetic */ DependencyResolutionVerifier this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(BuildResult buildResult) {
                boolean buildFailed;
                Intrinsics.checkNotNullParameter((Object)buildResult, (String)"buildResult");
                boolean bl = buildFailed = buildResult.getFailure() != null;
                if (buildFailed && !DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0)) {
                    DependencyResolutionVerifier.access$collectDependencyResolutionErrorsAfterBuildFailure(this.this$0, buildResult);
                }
                if (!DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0)) {
                    DependencyResolutionVerifier.access$logOrThrowOnFailedDependencies(this.this$0);
                }
            }
        });
        project.getGradle().getTaskGraph().whenReady(arg_0 -> DependencyResolutionVerifier.verifyResolution$lambda$2(project, this, arg_0));
    }

    private final void collectDependencyResolutionErrorsAfterBuildFailure(BuildResult buildResult) {
        String buildResultFailureMessage;
        String[] $this$filterIsInstanceTo$iv$iv;
        Throwable failureCause;
        Throwable throwable = buildResult.getFailure();
        Throwable throwable2 = throwable != null && (throwable = throwable.getCause()) != null ? throwable.getCause() : (failureCause = null);
        if (failureCause == null || !(failureCause instanceof DefaultMultiCauseException)) {
            return;
        }
        List list = ((DefaultMultiCauseException)failureCause).getCauses();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCauses(...)");
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object t : $this$filterIsInstanceTo$iv$iv) {
            if (!(t instanceof ModuleVersionNotFoundException)) continue;
            destination$iv$iv.add(t);
        }
        List moduleVersionNotFoundCauses = (List)destination$iv$iv;
        if (moduleVersionNotFoundCauses.isEmpty()) {
            return;
        }
        String string = buildResultFailureMessage = ((DefaultMultiCauseException)failureCause).getMessage();
        Intrinsics.checkNotNull((Object)string);
        $this$filterIsInstanceTo$iv$iv = new String[]{":"};
        List split = StringsKt.split$default((CharSequence)string, (String[])$this$filterIsInstanceTo$iv$iv, (boolean)false, (int)0, (int)6, null);
        String projectNameFromFailure = null;
        if (split.size() == 3) {
            v4 = (String)split.get(1);
        } else {
            destination$iv$iv = this.getProject().getRootProject().getName();
            Intrinsics.checkNotNull((Object)destination$iv$iv);
            v4 = projectNameFromFailure = destination$iv$iv;
        }
        if (Intrinsics.areEqual((Object)this.getProject().getName(), (Object)projectNameFromFailure)) {
            boolean bl;
            Object it;
            this.getLogger().debug("Starting dependency resolution verification after the build has completed: " + buildResultFailureMessage);
            Configuration conf = null;
            try {
                Object element$iv22;
                String confName;
                block12: {
                    String[] stringArray = new String[]{"for "};
                    confName = (String)StringsKt.split$default((CharSequence)StringsKt.replace$default((String)buildResultFailureMessage, (String)".", (String)"", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(1);
                    ConfigurationContainer configurationContainer = this.getProject().getConfigurations();
                    Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"getConfigurations(...)");
                    Iterable $this$first$iv = (Iterable)configurationContainer;
                    boolean bl2 = false;
                    for (Object element$iv22 : $this$first$iv) {
                        it = (Configuration)element$iv22;
                        bl = false;
                        if (!Intrinsics.areEqual((Object)it.toString(), (Object)confName)) continue;
                        break block12;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                conf = (Configuration)element$iv22;
                this.getLogger().debug("Found " + conf + " from " + confName);
            }
            catch (Exception e) {
                this.getLogger().warn("Error finding configuration associated with build failure from '" + buildResultFailureMessage + "'", (Throwable)e);
                return;
            }
            Map<String, Set<Configuration>> failedDepsByConf = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
            Iterable $this$forEach$iv = moduleVersionNotFoundCauses;
            boolean bl3 = false;
            for (Object element$iv : $this$forEach$iv) {
                Object object;
                it = (Throwable)element$iv;
                bl = false;
                if (!(it instanceof ModuleVersionNotFoundException)) {
                    object = "Failed requirement.";
                    throw new IllegalArgumentException(object.toString());
                }
                String dep = ((ModuleVersionNotFoundException)it).getSelector().toString();
                Map<String, Set<Configuration>> map = failedDepsByConf;
                Intrinsics.checkNotNull(map);
                if (map.containsKey(dep)) {
                    Set<Configuration> set = failedDepsByConf.get(dep);
                    Intrinsics.checkNotNull(set);
                    set.add(conf);
                    continue;
                }
                object = failedDepsByConf;
                Object object2 = new Configuration[]{conf};
                object2 = SetsKt.mutableSetOf((Object[])object2);
                object.put(dep, object2);
            }
        }
    }

    private final void collectDependencyResolutionErrorsAfterExecute(Task task) {
        Map<String, Set<Configuration>> failedDepsByConf = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Set<String> lockedDepsOutOfDate = lockedDepsOutOfDatePerProject.get(this.uniqueProjectKey(this.getProject()));
        Set<String> configurationsToExclude = !((Collection)this.getConfigurationsToExcludeOverride()).isEmpty() ? this.getConfigurationsToExcludeOverride() : this.getExtension().getConfigurationsToExclude();
        task.getProject().getConfigurations().matching(arg_0 -> DependencyResolutionVerifier.collectDependencyResolutionErrorsAfterExecute$lambda$6(arg_0 -> DependencyResolutionVerifier.collectDependencyResolutionErrorsAfterExecute$lambda$5(this, configurationsToExclude, arg_0), arg_0)).all(new Action(this, task, failedDepsByConf, lockedDepsOutOfDate){
            final /* synthetic */ DependencyResolutionVerifier this$0;
            final /* synthetic */ Task $task;
            final /* synthetic */ Map<String, Set<Configuration>> $failedDepsByConf;
            final /* synthetic */ Set<String> $lockedDepsOutOfDate;
            {
                this.this$0 = $receiver;
                this.$task = $task;
                this.$failedDepsByConf = $failedDepsByConf;
                this.$lockedDepsOutOfDate = $lockedDepsOutOfDate;
            }

            /*
             * WARNING - void declaration
             */
            public final void execute(Configuration conf) {
                DependencyResolutionVerifier.access$getLogger(this.this$0).debug(conf + " in " + this.this$0.getProject().getName() + " has state " + conf.getState() + ". Starting dependency resolution verification after task '" + this.$task.getName() + "'.");
                try {
                    conf.getResolvedConfiguration().rethrowFailure();
                }
                catch (ResolveException e) {
                    void $this$forEach$iv;
                    List list = e.getCauses();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCauses(...)");
                    Iterable iterable = list;
                    Map<String, Set<Configuration>> map = this.$failedDepsByConf;
                    Set<String> set = this.$lockedDepsOutOfDate;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Throwable cause = (Throwable)element$iv;
                        boolean bl = false;
                        Throwable throwable = cause;
                        if (throwable instanceof ModuleVersionNotFoundException) {
                            String dep = ((ModuleVersionNotFoundException)cause).getSelector().toString();
                            Map<String, Set<Configuration>> map2 = map;
                            Intrinsics.checkNotNull(map2);
                            if (map2.containsKey(dep)) {
                                Set<Configuration> set2 = map.get(dep);
                                Intrinsics.checkNotNull(set2);
                                Intrinsics.checkNotNull((Object)conf);
                                set2.add(conf);
                                continue;
                            }
                            Map<String, Set<Configuration>> map3 = map;
                            Object object = new Configuration[1];
                            Intrinsics.checkNotNull((Object)conf);
                            object[0] = conf;
                            object = SetsKt.mutableSetOf((Object[])object);
                            map3.put(dep, (Set<Configuration>)object);
                            continue;
                        }
                        if (!(throwable instanceof LockOutOfDateException)) continue;
                        Set<String> set3 = set;
                        Intrinsics.checkNotNull(set3);
                        set3.add(String.valueOf(((LockOutOfDateException)cause).getMessage()));
                    }
                    return;
                }
                catch (Exception e) {
                    DependencyResolutionVerifier.access$getLogger(this.this$0).warn("Received an unhandled exception: {}", (Object)e.getMessage());
                    return;
                }
                Intrinsics.checkNotNull((Object)conf);
                DependencyResolutionVerifier.access$validateThatResolvedVersionIsLockedVersion(this.this$0, conf);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void validateThatResolvedVersionIsLockedVersion(Configuration conf) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        Map overrideDependencies;
        Map map;
        String string;
        String string2;
        Object object;
        Map destination$iv$iv;
        boolean usesNebulaAlignment = !Boolean.getBoolean("nebula.features.coreAlignmentSupport");
        boolean usesDependencyLockingFeatureFlags = DependencyLockingFeatureFlags.isCoreLockingEnabled();
        if (usesDependencyLockingFeatureFlags || usesNebulaAlignment) {
            return;
        }
        if (this.getProject().getGradle().getStartParameter().getTaskNames().contains("updateLock") || this.getProject().getGradle().getStartParameter().getTaskNames().contains("updateGlobalLock")) {
            return;
        }
        Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf = depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> lockedDepsByConf = DependencyLockPlugin.Companion.getLockedDepsPerProjectForConfigurations().get(this.uniqueProjectKey(this.getProject()));
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> overrideDepsByConf = DependencyLockPlugin.Companion.getOverrideDepsPerProjectForConfigurations().get(this.uniqueProjectKey(this.getProject()));
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> map2 = lockedDepsByConf;
        Intrinsics.checkNotNull(map2);
        List<DependencyLockPlugin.ModuleVersionSelectorKey> list = map2.get(conf.getName());
        if (list != null) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Iterable iterable = list;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var13_15 = $this$associateBy$iv;
            destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                DependencyLockPlugin.ModuleVersionSelectorKey moduleVersionSelectorKey = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                DependencyLockPlugin.ModuleVersionSelectorKey it = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv;
                string2 = it.getGroup() + ":" + it.getName();
                boolean bl2 = false;
                string = String.valueOf(it.getVersion());
                object.put(string2, string);
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        Map lockedDependencies = map;
        Map<String, List<DependencyLockPlugin.ModuleVersionSelectorKey>> map3 = overrideDepsByConf;
        Intrinsics.checkNotNull(map3);
        List<DependencyLockPlugin.ModuleVersionSelectorKey> list2 = map3.get(conf.getName());
        if (list2 != null) {
            Iterator $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Object element$iv$iv;
            Iterable $i$f$associateBy = list2;
            boolean $i$f$associateBy2 = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            element$iv$iv = $this$associateByTo$iv$iv.iterator();
            while (element$iv$iv.hasNext()) {
                Object element$iv$iv2 = element$iv$iv.next();
                DependencyLockPlugin.ModuleVersionSelectorKey bl2 = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv2;
                object = destination$iv$iv2;
                boolean bl = false;
                DependencyLockPlugin.ModuleVersionSelectorKey it = (DependencyLockPlugin.ModuleVersionSelectorKey)element$iv$iv2;
                string2 = it.getGroup() + ":" + it.getName();
                boolean bl3 = false;
                string = String.valueOf(it.getVersion());
                object.put(string2, string);
            }
            v3 = destination$iv$iv2;
        } else {
            v3 = overrideDependencies = MapsKt.emptyMap();
        }
        if (lockedDependencies.isEmpty() && overrideDependencies.isEmpty()) {
            return;
        }
        Set set = conf.getResolvedConfiguration().getResolvedArtifacts();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getResolvedArtifacts(...)");
        Iterable $this$map$iv = set;
        boolean $i$f$map = false;
        Iterable $this$associateBy$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ResolvedArtifact $i$f$associateByTo = (ResolvedArtifact)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl = false;
            object.add(it.getModuleVersion().getId());
        }
        $this$map$iv = (List)destination$iv$iv3;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string3;
            String lockedVersion;
            ModuleVersionIdentifier dep = (ModuleVersionIdentifier)element$iv;
            boolean bl = false;
            String string4 = (String)lockedDependencies.get(dep.getGroup() + ":" + dep.getName());
            if (string4 == null) {
                string4 = lockedVersion = "";
            }
            if ((string3 = (String)overrideDependencies.get(dep.getGroup() + ":" + dep.getName())) == null) {
                string3 = "";
            }
            String overrideVersion = string3;
            String expectedVersion = ((CharSequence)overrideVersion).length() > 0 ? overrideVersion : (((CharSequence)lockedVersion).length() > 0 ? lockedVersion : "");
            if (!(((CharSequence)expectedVersion).length() > 0) || Intrinsics.areEqual((Object)expectedVersion, (Object)dep.getVersion())) continue;
            String depAsString = dep.getGroup() + ":" + dep.getName() + ":" + dep.getVersion();
            String key = "'" + depAsString + "' instead of locked version '" + expectedVersion + "'";
            Map<String, Set<Configuration>> map4 = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
            Intrinsics.checkNotNull(map4);
            if (map4.containsKey(dep.toString())) {
                Set<Configuration> set2 = depsWhereResolvedVersionIsNotTheLockedVersionByConf.get(key);
                Intrinsics.checkNotNull(set2);
                set2.add(conf);
                continue;
            }
            Map<String, Set<Configuration>> map5 = depsWhereResolvedVersionIsNotTheLockedVersionByConf;
            Object object2 = new Configuration[]{conf};
            object2 = SetsKt.mutableSetOf((Object[])object2);
            map5.put(key, (Set<Configuration>)object2);
        }
    }

    private final void logOrThrowOnFailedDependencies() {
        List messages = new ArrayList();
        Map<String, Set<Configuration>> map = failedDependenciesPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Intrinsics.checkNotNull(map);
        Map<String, Set<Configuration>> failedDepsByConf = map;
        Set<String> set = lockedDepsOutOfDatePerProject.get(this.uniqueProjectKey(this.getProject()));
        Intrinsics.checkNotNull(set);
        Set<String> lockedDepsOutOfDate = set;
        Map<String, Set<Configuration>> map2 = depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations.get(this.uniqueProjectKey(this.getProject()));
        Intrinsics.checkNotNull(map2);
        Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf = map2;
        if (!failedDepsByConf.isEmpty() || !((Collection)lockedDepsOutOfDate).isEmpty() || !depsWhereResolvedVersionIsNotTheLockedVersionByConf.isEmpty()) {
            try {
                messages.addAll((Collection)this.createMessagesForFailedDeps(failedDepsByConf));
                messages.addAll((Collection)this.createMessagesForLockedDepsOutOfDate(lockedDepsOutOfDate));
                messages.addAll((Collection)this.createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion(depsWhereResolvedVersionIsNotTheLockedVersionByConf));
            }
            catch (Exception e) {
                this.getLogger().warn("Error creating message regarding failed dependencies", (Throwable)e);
                return;
            }
            this.providedErrorMessageForThisProject = true;
            if (this.unresolvedDependenciesShouldFailTheBuild()) {
                throw new DependencyResolutionException(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
            }
            this.getLogger().warn(CollectionsKt.joinToString$default((Iterable)messages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
        }
    }

    private final List<String> createMessagesForFailedDeps(Map<String, Set<Configuration>> failedDepsForConfs) {
        List messages = new ArrayList();
        List depsMissingVersions = new ArrayList();
        if (!failedDepsForConfs.isEmpty()) {
            messages.add("Failed to resolve the following dependencies:");
        }
        int failureMessageCounter = 0;
        Map $this$forEach$iv = MapsKt.toSortedMap(failedDepsForConfs);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String dep = (String)entry.getKey();
            messages.add("  " + (failureMessageCounter + 1) + ". Failed to resolve '" + dep + "' for project '" + this.getProject().getName() + "'");
            Intrinsics.checkNotNull((Object)dep);
            char[] cArray = new char[]{':'};
            if (StringsKt.split$default((CharSequence)dep, (char[])cArray, (boolean)false, (int)0, (int)6, null).size() < 3) {
                depsMissingVersions.add(dep);
            }
            ++failureMessageCounter;
        }
        if (depsMissingVersions.size() > 0) {
            messages.add("The following dependencies are missing a version: " + CollectionsKt.joinToString$default((Iterable)depsMissingVersions, null, null, null, (int)0, null, null, (int)63, null) + "\nPlease add a version to fix this. If you have been using a BOM, perhaps these dependencies are no longer managed. \n" + this.getExtension().getMissingVersionsMessageAddition());
        }
        return messages;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> createMessagesForLockedDepsOutOfDate(Set<String> lockedDepsOutOfDate) {
        void $this$forEach$iv;
        List messages = new ArrayList();
        if (!((Collection)lockedDepsOutOfDate).isEmpty()) {
            messages.add("Resolved dependencies were missing from the lock state:");
        }
        int locksOutOfDateCounter = 0;
        Iterable iterable = CollectionsKt.sorted((Iterable)lockedDepsOutOfDate);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String outOfDateMessage = (String)element$iv;
            boolean bl = false;
            messages.add("  " + (locksOutOfDateCounter + 1) + ". " + outOfDateMessage + " for project '" + this.getProject().getName() + "'");
            ++locksOutOfDateCounter;
        }
        return messages;
    }

    private final List<String> createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion(Map<String, Set<Configuration>> depsWhereResolvedVersionIsNotTheLockedVersionByConf) {
        List messages = new ArrayList();
        if (!depsWhereResolvedVersionIsNotTheLockedVersionByConf.isEmpty()) {
            messages.add("Dependency lock state is out of date:");
        }
        int failureMessageCounter = 0;
        Map $this$forEach$iv = MapsKt.toSortedMap(depsWhereResolvedVersionIsNotTheLockedVersionByConf);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String dep = (String)entry.getKey();
            Set configs = (Set)entry.getValue();
            String string = this.getProject().getName();
            Intrinsics.checkNotNull((Object)configs);
            messages.add("  " + (failureMessageCounter + 1) + ". Resolved " + dep + " for project '" + string + "' for configuration(s): " + CollectionsKt.joinToString$default((Iterable)configs, (CharSequence)",", null, null, (int)0, null, DependencyResolutionVerifier::createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion$lambda$16$lambda$15, (int)30, null));
            ++failureMessageCounter;
        }
        if (!depsWhereResolvedVersionIsNotTheLockedVersionByConf.isEmpty()) {
            messages.add("Please update your dependency locks or your build file constraints.\n" + this.getExtension().getResolvedVersionDoesNotEqualLockedVersionMessageAddition());
        }
        return messages;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean configurationIsResolvedAndMatches(Configuration conf, Set<String> configurationsToExclude) {
        if (conf.getState() == Configuration.State.UNRESOLVED) return false;
        String string = conf.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.startsWith$default((String)string, (String)"incrementalScala", (boolean)false, (int)2, null)) return false;
        if (configurationsToExclude.contains(conf.getName())) return false;
        if (ConfigurationFilters.safelyHasAResolutionAlternative(conf)) return false;
        String string2 = conf.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string2, (String)"CompileOnly", (boolean)false, (int)2, null)) return false;
        if (conf.getName().equals("compileOnly")) return false;
        return true;
    }

    private final boolean unresolvedDependenciesShouldFailTheBuild() {
        boolean bl;
        if (this.getProject().hasProperty("dependencyResolutionVerifier.unresolvedDependenciesFailTheBuild")) {
            Object object = this.getProject().property("dependencyResolutionVerifier.unresolvedDependenciesFailTheBuild");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            bl = Boolean.parseBoolean((String)object);
        } else {
            bl = this.getExtension().getShouldFailTheBuild();
        }
        return bl;
    }

    private final String uniqueProjectKey(Project project) {
        return project.getName() + "-" + (Intrinsics.areEqual((Object)project, (Object)project.getRootProject()) ? "rootproject" : "subproject");
    }

    private static final Logger logger_delegate$lambda$0() {
        return Logging.getLogger(DependencyResolutionVerifier.class);
    }

    /*
     * WARNING - void declaration
     */
    private static final void verifyResolution$lambda$2(Project $project, DependencyResolutionVerifier this$0, TaskExecutionGraph taskGraph) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)taskGraph, (String)"taskGraph");
        List list = taskGraph.getAllTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTasks(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Task it = (Task)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getProject(), (Object)$project)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tasks = (List)destination$iv$iv;
        if (tasks.isEmpty()) {
            return;
        }
        taskGraph.addTaskExecutionListener(new TaskExecutionListener($project, this$0){
            final /* synthetic */ Project $project;
            final /* synthetic */ DependencyResolutionVerifier this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void beforeExecute(Task task) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            }

            public void afterExecute(Task task, TaskState taskState) {
                Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                Intrinsics.checkNotNullParameter((Object)taskState, (String)"taskState");
                if (!Intrinsics.areEqual((Object)task.getProject(), (Object)this.$project)) {
                    return;
                }
                if (this.this$0.getExtension().getTasksToExclude().contains(task.getName())) {
                    return;
                }
                if (DependencyResolutionVerifier.access$getProvidedErrorMessageForThisProject$p(this.this$0)) {
                    return;
                }
                if (!(task instanceof DependencyReportTask || task instanceof DependencyInsightReportTask || task instanceof AbstractCompile)) {
                    return;
                }
                DependencyResolutionVerifier.access$collectDependencyResolutionErrorsAfterExecute(this.this$0, task);
                DependencyResolutionVerifier.access$logOrThrowOnFailedDependencies(this.this$0);
            }
        });
    }

    private static final boolean collectDependencyResolutionErrorsAfterExecute$lambda$5(DependencyResolutionVerifier this$0, Set $configurationsToExclude, Configuration it) {
        Intrinsics.checkNotNull((Object)it);
        Intrinsics.checkNotNull((Object)$configurationsToExclude);
        return this$0.configurationIsResolvedAndMatches(it, $configurationsToExclude);
    }

    private static final boolean collectDependencyResolutionErrorsAfterExecute$lambda$6(Function1 $tmp0, Object element) {
        return (Boolean)$tmp0.invoke(element);
    }

    private static final CharSequence createMessagesForDepsWhereResolvedVersionIsNotTheLockedVersion$lambda$16$lambda$15(Configuration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public static final /* synthetic */ boolean access$getProvidedErrorMessageForThisProject$p(DependencyResolutionVerifier $this) {
        return $this.providedErrorMessageForThisProject;
    }

    public static final /* synthetic */ void access$collectDependencyResolutionErrorsAfterBuildFailure(DependencyResolutionVerifier $this, BuildResult buildResult) {
        $this.collectDependencyResolutionErrorsAfterBuildFailure(buildResult);
    }

    public static final /* synthetic */ void access$logOrThrowOnFailedDependencies(DependencyResolutionVerifier $this) {
        $this.logOrThrowOnFailedDependencies();
    }

    public static final /* synthetic */ Logger access$getLogger(DependencyResolutionVerifier $this) {
        return $this.getLogger();
    }

    public static final /* synthetic */ void access$validateThatResolvedVersionIsLockedVersion(DependencyResolutionVerifier $this, Configuration conf) {
        $this.validateThatResolvedVersionIsLockedVersion(conf);
    }

    public static final /* synthetic */ void access$collectDependencyResolutionErrorsAfterExecute(DependencyResolutionVerifier $this, Task task) {
        $this.collectDependencyResolutionErrorsAfterExecute(task);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R8\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR,\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR8\u0010\u0010\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lnebula/plugin/dependencyverifier/DependencyResolutionVerifier$Companion;", "", "<init>", "()V", "failedDependenciesPerProjectForConfigurations", "", "", "", "Lorg/gradle/api/artifacts/Configuration;", "getFailedDependenciesPerProjectForConfigurations", "()Ljava/util/Map;", "setFailedDependenciesPerProjectForConfigurations", "(Ljava/util/Map;)V", "lockedDepsOutOfDatePerProject", "getLockedDepsOutOfDatePerProject", "setLockedDepsOutOfDatePerProject", "depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "getDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "setDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations", "gradle-dependency-lock-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Map<String, Set<Configuration>>> getFailedDependenciesPerProjectForConfigurations() {
            return failedDependenciesPerProjectForConfigurations;
        }

        public final void setFailedDependenciesPerProjectForConfigurations(@NotNull Map<String, Map<String, Set<Configuration>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            failedDependenciesPerProjectForConfigurations = map;
        }

        @NotNull
        public final Map<String, Set<String>> getLockedDepsOutOfDatePerProject() {
            return lockedDepsOutOfDatePerProject;
        }

        public final void setLockedDepsOutOfDatePerProject(@NotNull Map<String, Set<String>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            lockedDepsOutOfDatePerProject = map;
        }

        @NotNull
        public final Map<String, Map<String, Set<Configuration>>> getDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations() {
            return depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations;
        }

        public final void setDepsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations(@NotNull Map<String, Map<String, Set<Configuration>>> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            depsWhereResolvedVersionIsNotTheLockedVersionPerProjectForConfigurations = map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

