/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencylock;

import com.netflix.nebula.dependencybase.DependencyBasePlugin;
import com.netflix.nebula.dependencybase.DependencyManagement;
import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockCommitExtension;
import nebula.plugin.dependencylock.DependencyLockExtension;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.DependencyLockReader;
import nebula.plugin.dependencylock.DependencyLockTaskConfigurer;
import nebula.plugin.dependencylock.GradleInteropKt;
import nebula.plugin.dependencylock.exceptions.DependencyLockException;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.NameMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002ABB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J(\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u000e\b\u0002\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150'H\u0002J \u0010(\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*H\u0002J\b\u0010+\u001a\u00020 H\u0002J\u0016\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150/H\u0002J$\u00100\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150/2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150/H\u0002J\u0016\u00102\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00150/H\u0002J\u001e\u00103\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\f\u00104\u001a\b\u0012\u0004\u0012\u00020605H\u0002J<\u00107\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u00108\u001a\u0002092\u000e\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030*2\b\u0010:\u001a\u0004\u0018\u00010\u00152\b\u0010;\u001a\u0004\u0018\u00010\u0015H\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00150'2\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0016\u0010=\u001a\u00020-2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001505H\u0002J\f\u0010?\u001a\u000206*\u00020@H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006C"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "getLOGGER", "()Lorg/gradle/api/logging/Logger;", "insight", "Lcom/netflix/nebula/dependencybase/DependencyManagement;", "getInsight", "()Lcom/netflix/nebula/dependencybase/DependencyManagement;", "setInsight", "(Lcom/netflix/nebula/dependencybase/DependencyManagement;)V", "lockReader", "Lnebula/plugin/dependencylock/DependencyLockReader;", "getLockReader", "()Lnebula/plugin/dependencylock/DependencyLockReader;", "setLockReader", "(Lnebula/plugin/dependencylock/DependencyLockReader;)V", "lockUsed", "", "getLockUsed", "()Ljava/lang/String;", "setLockUsed", "(Ljava/lang/String;)V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "apply", "", "applyLock", "conf", "Lorg/gradle/api/artifacts/Configuration;", "dependenciesLock", "Ljava/io/File;", "updates", "", "applyOverrides", "overrides", "", "disableCachingForGenerateLock", "hasGenerationTask", "", "cliTasks", "", "hasTask", "taskNames", "hasUpdateTask", "lockConfiguration", "selectorKeys", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "maybeApplyLock", "extension", "Lnebula/plugin/dependencylock/DependencyLockExtension;", "globalLockFileName", "lockFilename", "parseUpdates", "taskRunOnThisProject", "tokens", "toKey", "Lorg/gradle/api/artifacts/DependencyResolveDetails;", "Companion", "ModuleVersionSelectorKey", "gradle-dependency-lock-plugin_main"})
public final class DependencyLockPlugin
implements Plugin<Project> {
    @NotNull
    private final Logger LOGGER;
    @NotNull
    public Project project;
    @NotNull
    public DependencyLockReader lockReader;
    @NotNull
    public DependencyManagement insight;
    @NotNull
    public String lockUsed;
    @NotNull
    public static final String EXTENSION_NAME = "dependencyLock";
    @NotNull
    public static final String COMMIT_EXTENSION_NAME = "commitDependencyLock";
    @NotNull
    public static final String GLOBAL_LOCK_FILE = "dependencyLock.globalLockFile";
    @NotNull
    public static final String LOCK_AFTER_EVALUATING = "dependencyLock.lockAfterEvaluating";
    @NotNull
    public static final String UPDATE_DEPENDENCIES = "dependencyLock.updateDependencies";
    @NotNull
    public static final String OVERRIDE = "dependencyLock.override";
    @NotNull
    public static final String OVERRIDE_FILE = "dependencyLock.overrideFile";
    @NotNull
    public static final String GENERATE_GLOBAL_LOCK_TASK_NAME = "generateGlobalLock";
    @NotNull
    public static final String UPDATE_GLOBAL_LOCK_TASK_NAME = "updateGlobalLock";
    @NotNull
    public static final String GENERATE_LOCK_TASK_NAME = "generateLock";
    @NotNull
    public static final String UPDATE_LOCK_TASK_NAME = "updateLock";
    @NotNull
    private static final Set<String> GENERATION_TASK_NAMES;
    @NotNull
    private static final Set<String> UPDATE_TASK_NAMES;
    public static final Companion Companion;

    @NotNull
    public final Logger getLOGGER() {
        return this.LOGGER;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyLockReader getLockReader() {
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        return dependencyLockReader;
    }

    public final void setLockReader(@NotNull DependencyLockReader dependencyLockReader) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyLockReader, (String)"<set-?>");
        this.lockReader = dependencyLockReader;
    }

    @NotNull
    public final DependencyManagement getInsight() {
        DependencyManagement dependencyManagement = this.insight;
        if (dependencyManagement == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"insight");
        }
        return dependencyManagement;
    }

    public final void setInsight(@NotNull DependencyManagement dependencyManagement) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyManagement, (String)"<set-?>");
        this.insight = dependencyManagement;
    }

    @NotNull
    public final String getLockUsed() {
        String string = this.lockUsed;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        }
        return string;
    }

    public final void setLockUsed(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.lockUsed = string;
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void $receiver$iv;
        boolean lockAfterEvaluating;
        boolean bl;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.lockReader = new DependencyLockReader(project);
        project.getPlugins().apply(DependencyBasePlugin.class);
        Object object2 = project.getExtensions().getExtraProperties().get("nebulaDependencyBase");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.netflix.nebula.dependencybase.DependencyManagement");
        }
        this.insight = (DependencyManagement)object2;
        DependencyLockExtension extension = (DependencyLockExtension)project.getExtensions().create(EXTENSION_NAME, DependencyLockExtension.class, new Object[0]);
        DependencyLockCommitExtension commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().findByType(DependencyLockCommitExtension.class);
        if (commitExtension == null) {
            commitExtension = (DependencyLockCommitExtension)project.getRootProject().getExtensions().create(COMMIT_EXTENSION_NAME, DependencyLockCommitExtension.class, new Object[0]);
        }
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        Map overrides = dependencyLockReader.readOverrides();
        String globalLockFilename = GradleInteropKt.findStringProperty(project, GLOBAL_LOCK_FILE);
        String lockFilename = new DependencyLockTaskConfigurer(project).configureTasks(globalLockFilename, extension, commitExtension, overrides);
        if (project.hasProperty(LOCK_AFTER_EVALUATING)) {
            object = project.property(LOCK_AFTER_EVALUATING).toString();
            bl = Boolean.parseBoolean((String)object);
        } else {
            bl = lockAfterEvaluating = extension.getLockAfterEvaluating();
        }
        if (lockAfterEvaluating) {
            this.LOGGER.info("Delaying dependency lock apply until beforeResolve (" + LOCK_AFTER_EVALUATING + " set to true)");
        } else {
            this.LOGGER.info("Applying dependency lock during plugin apply (" + LOCK_AFTER_EVALUATING + " set to false)");
        }
        this.disableCachingForGenerateLock();
        object = this;
        TaskExecutionGraph taskExecutionGraph = project.getGradle().getTaskGraph();
        Closure closure = (Closure)new Closure<Unit>((Object)$receiver$iv, (Object)$receiver$iv, this){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DependencyLockPlugin this$0;
            {
                this.receiver$0 = $receiver;
                this.this$0 = dependencyLockPlugin;
                super($super_call_param$2);
            }

            public final void doCall() {
                DependencyLockPlugin.access$disableCachingForGenerateLock(this.this$0);
            }
        };
        taskExecutionGraph.whenReady(closure);
        project.getConfigurations().all((Action)new Action<Configuration>(this, lockAfterEvaluating, extension, overrides, globalLockFilename, lockFilename){
            final /* synthetic */ DependencyLockPlugin this$0;
            final /* synthetic */ boolean $lockAfterEvaluating;
            final /* synthetic */ DependencyLockExtension $extension;
            final /* synthetic */ Map $overrides;
            final /* synthetic */ String $globalLockFilename;
            final /* synthetic */ String $lockFilename;

            public final void execute(Configuration conf) {
                if (this.$lockAfterEvaluating) {
                    conf.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(this, conf){
                        final /* synthetic */ apply.2 this$0;
                        final /* synthetic */ Configuration $conf;

                        public final void execute(ResolvableDependencies it) {
                            DependencyLockPlugin dependencyLockPlugin = this.this$0.this$0;
                            Configuration configuration = this.$conf;
                            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                            DependencyLockExtension dependencyLockExtension = this.this$0.$extension;
                            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
                            Map map = this.this$0.$overrides;
                            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"overrides");
                            DependencyLockPlugin.access$maybeApplyLock(dependencyLockPlugin, configuration, dependencyLockExtension, map, this.this$0.$globalLockFilename, this.this$0.$lockFilename);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$conf = configuration;
                        }
                    });
                } else {
                    Configuration configuration = conf;
                    Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                    DependencyLockExtension dependencyLockExtension = this.$extension;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
                    Map map = this.$overrides;
                    Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"overrides");
                    DependencyLockPlugin.access$maybeApplyLock(this.this$0, configuration, dependencyLockExtension, map, this.$globalLockFilename, this.$lockFilename);
                }
            }
            {
                this.this$0 = dependencyLockPlugin;
                this.$lockAfterEvaluating = bl;
                this.$extension = dependencyLockExtension;
                this.$overrides = map;
                this.$globalLockFilename = string;
                this.$lockFilename = string2;
            }
        });
    }

    private final void disableCachingForGenerateLock() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        List list = project.getGradle().getStartParameter().getTaskNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.gradle.startParameter.taskNames");
        if (this.hasGenerationTask(list)) {
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            project2.getConfigurations().all((Action)disableCachingForGenerateLock.1.INSTANCE);
        }
    }

    private final void maybeApplyLock(Configuration conf, DependencyLockExtension extension, Map<?, ?> overrides, String globalLockFileName, String lockFilename) {
        File file;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        File file2 = project.getRootProject().getProjectDir();
        String string = globalLockFileName;
        if (string == null) {
            string = extension.getGlobalLockFile();
        }
        File globalLock = new File(file2, string);
        if (globalLock.exists()) {
            file = globalLock;
        } else {
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            File file3 = project2.getProjectDir();
            String string2 = lockFilename;
            if (string2 == null) {
                string2 = extension.getLockFile();
            }
            file = new File(file3, string2);
        }
        File dependenciesLock = file;
        String string3 = dependenciesLock.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dependenciesLock.name");
        this.lockUsed = string3;
        DependencyManagement dependencyManagement = this.insight;
        if (dependencyManagement == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"insight");
        }
        StringBuilder stringBuilder = new StringBuilder().append("nebula.dependency-lock locked with: ");
        String string4 = this.lockUsed;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        }
        dependencyManagement.addPluginMessage(stringBuilder.append(string4).toString());
        Project project3 = this.project;
        if (project3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (!DependencyLockTaskConfigurer.shouldIgnoreDependencyLock(project3)) {
            Set<String> set;
            List taskNames;
            Project project4 = this.project;
            if (project4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            List list = taskNames = project4.getGradle().getStartParameter().getTaskNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(list);
            Project project5 = this.project;
            if (project5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            if (project5.hasProperty(UPDATE_DEPENDENCIES)) {
                Project project6 = this.project;
                if (project6 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Object object = project6.property(UPDATE_DEPENDENCIES);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                set = this.parseUpdates((String)object);
            } else {
                set = extension.getUpdateDependencies();
            }
            Set<String> updates = set;
            StringBuilder stringBuilder2 = new StringBuilder();
            Project project7 = this.project;
            if (project7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(project7.getGroup()).append(":");
            Project project8 = this.project;
            if (project8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            String projectCoord = stringBuilder3.append(project8.getName()).toString();
            if (hasUpdateTask) {
                boolean bl;
                block25: {
                    Iterable $receiver$iv = updates;
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!Intrinsics.areEqual((Object)it, (Object)projectCoord)) continue;
                        bl = true;
                        break block25;
                    }
                    bl = false;
                }
                if (bl) {
                    throw (Throwable)new DependencyLockException("Dependency locks cannot be updated. An update was requested for a project dependency (" + projectCoord + ")");
                }
            }
            List list2 = taskNames;
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"taskNames");
            boolean hasGenerateTask = this.hasGenerationTask(list2);
            if (dependenciesLock.exists()) {
                if (!hasGenerateTask) {
                    DependencyLockPlugin.applyLock$default(this, conf, dependenciesLock, null, 4, null);
                } else if (hasUpdateTask) {
                    Set<String> set2 = updates;
                    Intrinsics.checkExpressionValueIsNotNull(set2, (String)"updates");
                    this.applyLock(conf, dependenciesLock, set2);
                }
            }
            this.applyOverrides(conf, overrides);
        }
    }

    private final boolean hasGenerationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)Companion.getGENERATION_TASK_NAMES());
    }

    private final boolean hasUpdateTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)Companion.getUPDATE_TASK_NAMES());
    }

    private final boolean hasTask(Collection<String> cliTasks, Collection<String> taskNames) {
        Object v0;
        block1: {
            Iterable iterable;
            NameMatcher matcher = new NameMatcher();
            Iterable iterable2 = iterable = (Iterable)cliTasks;
            for (Object t : iterable2) {
                String cliTaskName = (String)t;
                List tokens = StringsKt.split$default((CharSequence)cliTaskName, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                String taskName = (String)CollectionsKt.last((List)tokens);
                String generatesPresent = matcher.find(taskName, taskNames);
                if (!(generatesPresent != null && this.taskRunOnThisProject(tokens))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        String found = v0;
        return found != null;
    }

    private final boolean taskRunOnThisProject(List<String> tokens) {
        if (tokens.size() == 1) {
            return true;
        }
        if (tokens.size() == 2 && Intrinsics.areEqual((Object)tokens.get(0), (Object)"")) {
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            return Intrinsics.areEqual((Object)project, (Object)project2.getRootProject());
        }
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return Intrinsics.areEqual((Object)project.getName(), (Object)tokens.get(tokens.size() - 2));
    }

    private final Set<String> parseUpdates(String updates) {
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)updates, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null));
    }

    private final void applyLock(Configuration conf, File dependenciesLock, Set<String> updates) {
        Map locks;
        this.LOGGER.info("Using " + dependenciesLock.getName() + " to lock dependencies in " + conf);
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        if ((locks = dependencyLockReader.readLocks(conf, dependenciesLock, (Collection<String>)updates)) != null) {
            String string;
            Map map;
            Map.Entry it;
            Map $receiver$iv$iv;
            Map $receiver$iv;
            Map map2 = $receiver$iv = locks;
            Object destination$iv$iv = new LinkedHashMap();
            Map map3 = $receiver$iv$iv;
            Iterator iterator = map3.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                Object v = it.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                map = (Map)v;
                string = "locked";
                Map map4 = map;
                if (map4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (!map4.containsKey(string)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $receiver$iv = destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList($receiver$iv.size());
            map3 = $receiver$iv$iv;
            for (Map.Entry item$iv$iv : map3.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                Object v = it.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                map = (Map)v;
                string = "locked";
                Map map5 = map;
                if (map5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
                }
                Object version = map5.get(string);
                ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), version);
                object.add(moduleVersionSelectorKey);
            }
            List locked = (List)destination$iv$iv;
            this.LOGGER.debug("locked: {}", (Object)locked);
            this.lockConfiguration(conf, locked);
        }
    }

    static /* bridge */ /* synthetic */ void applyLock$default(DependencyLockPlugin dependencyLockPlugin, Configuration configuration, File file, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        dependencyLockPlugin.applyLock(configuration, file, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyOverrides(Configuration conf, Map<?, ?> overrides) {
        void $receiver$iv$iv;
        Map<?, ?> $receiver$iv;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project.hasProperty(OVERRIDE_FILE)) {
            StringBuilder stringBuilder = new StringBuilder().append("Using override file ");
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.LOGGER.info(stringBuilder.append(project2.property(OVERRIDE_FILE)).append(" to lock dependencies").toString());
            DependencyManagement dependencyManagement = this.insight;
            if (dependencyManagement == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"insight");
            }
            StringBuilder stringBuilder2 = new StringBuilder().append("nebula.dependency-lock using override file: ");
            Project project3 = this.project;
            if (project3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            dependencyManagement.addPluginMessage(stringBuilder2.append(project3.property(OVERRIDE_FILE)).toString());
        }
        Project project4 = this.project;
        if (project4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project4.hasProperty(OVERRIDE)) {
            StringBuilder stringBuilder = new StringBuilder().append("Using command line overrides ");
            Project project5 = this.project;
            if (project5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.LOGGER.info(stringBuilder.append(project5.property(OVERRIDE)).toString());
            DependencyManagement dependencyManagement = this.insight;
            if (dependencyManagement == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"insight");
            }
            StringBuilder stringBuilder3 = new StringBuilder().append("nebula.dependency-lock using override: ");
            Project project6 = this.project;
            if (project6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            dependencyManagement.addPluginMessage(stringBuilder3.append(project6.property(OVERRIDE)).toString());
        }
        Map<?, ?> map = $receiver$iv = overrides;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var7_6 = $receiver$iv$iv;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), it.getValue());
            collection.add(moduleVersionSelectorKey);
        }
        List overrideDeps = (List)destination$iv$iv;
        this.LOGGER.debug("overrides: {}", (Object)overrideDeps);
        this.lockConfiguration(conf, overrideDeps);
    }

    /*
     * WARNING - void declaration
     */
    private final void lockConfiguration(Configuration conf, List<ModuleVersionSelectorKey> selectorKeys) {
        Object value$iv$iv$iv;
        Object $receiver$iv$iv;
        Object $receiver$iv = selectorKeys;
        Iterable iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap();
        Iterator iterator = $receiver$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Map $receiver$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator.next();
            ModuleVersionSelectorKey it = (ModuleVersionSelectorKey)element$iv$iv;
            ModuleVersionSelectorKey key$iv$iv = it;
            value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                ArrayList answer$iv$iv$iv = new ArrayList();
                $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$receiver$iv.size()));
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv.entrySet();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry $i$a$1$groupBy = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            Object k = it$iv$iv.getKey();
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            ModuleVersionSelector moduleVersionSelector = ((ModuleVersionSelectorKey)it.getKey()).getSelector();
            map2.put(k2, moduleVersionSelector);
        }
        Map selectorsByKey = destination$iv$iv;
        conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(this, selectorsByKey, conf){
            final /* synthetic */ DependencyLockPlugin this$0;
            final /* synthetic */ Map $selectorsByKey;
            final /* synthetic */ Configuration $conf;

            public final void execute(DependencyResolveDetails details) {
                ModuleVersionSelectorKey moduleKey = DependencyLockPlugin.access$toKey(this.this$0, details);
                ModuleVersionSelector module = (ModuleVersionSelector)this.$selectorsByKey.get(moduleKey);
                if (module != null) {
                    details.useTarget((Object)module);
                    DependencyManagement dependencyManagement = this.this$0.getInsight();
                    String string = this.$conf.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"conf.name");
                    String string2 = moduleKey.toString();
                    String string3 = module.getVersion();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"module.version");
                    dependencyManagement.addLock(string, string2, string3, this.this$0.getLockUsed(), "nebula.dependency-lock");
                }
            }
            {
                this.this$0 = dependencyLockPlugin;
                this.$selectorsByKey = map;
                this.$conf = configuration;
            }
        });
    }

    private final ModuleVersionSelectorKey toKey(@NotNull DependencyResolveDetails $receiver) {
        ModuleVersionSelector moduleVersionSelector = $receiver.getRequested();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionSelector, (String)"requested");
        return new ModuleVersionSelectorKey(moduleVersionSelector);
    }

    public DependencyLockPlugin() {
        Logger logger = Logging.getLogger(DependencyLockPlugin.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Depend\u2026cyLockPlugin::class.java)");
        this.LOGGER = logger;
    }

    static {
        Companion = new Companion(null);
        GENERATION_TASK_NAMES = SetsKt.setOf((Object[])new String[]{GENERATE_LOCK_TASK_NAME, GENERATE_GLOBAL_LOCK_TASK_NAME, UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME});
        UPDATE_TASK_NAMES = SetsKt.setOf((Object[])new String[]{UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME});
    }

    public static final /* synthetic */ void access$disableCachingForGenerateLock(DependencyLockPlugin $this) {
        $this.disableCachingForGenerateLock();
    }

    public static final /* synthetic */ void access$maybeApplyLock(DependencyLockPlugin $this, @NotNull Configuration conf, @NotNull DependencyLockExtension extension, @NotNull Map overrides, @Nullable String globalLockFileName, @Nullable String lockFilename) {
        $this.maybeApplyLock(conf, extension, overrides, globalLockFileName, lockFilename);
    }

    @NotNull
    public static final /* synthetic */ ModuleVersionSelectorKey access$toKey(DependencyLockPlugin $this, @NotNull DependencyResolveDetails $receiver) {
        return $this.toKey($receiver);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\u0011\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\u0011\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\u0011\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bH\u0096\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0019\u0010\u0011\u001a\u00020\u00072\u000e\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u00130\u0013H\u0097\u0001J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "Lorg/gradle/api/artifacts/ModuleVersionSelector;", "selector", "(Lorg/gradle/api/artifacts/ModuleVersionSelector;)V", "getSelector", "()Lorg/gradle/api/artifacts/ModuleVersionSelector;", "equals", "", "other", "", "getGroup", "", "kotlin.jvm.PlatformType", "getName", "getVersion", "hashCode", "", "matchesStrictly", "p0", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "toString", "Companion", "gradle-dependency-lock-plugin_main"})
    private static final class ModuleVersionSelectorKey
    implements ModuleVersionSelector {
        @NotNull
        private final ModuleVersionSelector selector;
        public static final Companion Companion = new Companion(null);

        public int hashCode() {
            return Objects.hash(this.getGroup(), this.getName());
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            return object instanceof ModuleVersionSelector ? Intrinsics.areEqual((Object)this.getGroup(), (Object)((ModuleVersionSelector)other).getGroup()) && Intrinsics.areEqual((Object)this.getName(), (Object)((ModuleVersionSelector)other).getName()) : false;
        }

        @NotNull
        public String toString() {
            return this.getGroup() + ":" + this.getName();
        }

        @NotNull
        public final ModuleVersionSelector getSelector() {
            return this.selector;
        }

        public ModuleVersionSelectorKey(@NotNull ModuleVersionSelector selector) {
            Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
            this.selector = selector;
        }

        public String getGroup() {
            return this.selector.getGroup();
        }

        public String getName() {
            return this.selector.getName();
        }

        public String getVersion() {
            return this.selector.getVersion();
        }

        @Incubating
        public boolean matchesStrictly(ModuleVersionIdentifier p0) {
            return this.selector.matchesStrictly(p0);
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0007"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey$Companion;", "", "()V", "create", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "notation", "version", "gradle-dependency-lock-plugin_main"})
        public static final class Companion {
            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ModuleVersionSelectorKey create(@Nullable Object notation, @Nullable Object version) {
                void name;
                void group;
                List list;
                Object object = notation;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                List list2 = list = StringsKt.split$default((CharSequence)((String)object), (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                String string = (String)list2.get(0);
                list2 = list;
                String string2 = (String)list2.get(1);
                list = null;
                Object object2 = version;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                DefaultModuleVersionSelector selector = new DefaultModuleVersionSelector((String)group, (String)name, (String)object2);
                return new ModuleVersionSelectorKey((ModuleVersionSelector)selector);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$Companion;", "", "()V", "COMMIT_EXTENSION_NAME", "", "EXTENSION_NAME", "GENERATE_GLOBAL_LOCK_TASK_NAME", "GENERATE_LOCK_TASK_NAME", "GENERATION_TASK_NAMES", "", "getGENERATION_TASK_NAMES", "()Ljava/util/Set;", "GLOBAL_LOCK_FILE", "LOCK_AFTER_EVALUATING", "OVERRIDE", "OVERRIDE_FILE", "UPDATE_DEPENDENCIES", "UPDATE_GLOBAL_LOCK_TASK_NAME", "UPDATE_LOCK_TASK_NAME", "UPDATE_TASK_NAMES", "getUPDATE_TASK_NAMES", "gradle-dependency-lock-plugin_main"})
    public static final class Companion {
        @NotNull
        public final Set<String> getGENERATION_TASK_NAMES() {
            return GENERATION_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getUPDATE_TASK_NAMES() {
            return UPDATE_TASK_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

