/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.dependencylock;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nebula.plugin.dependencylock.DependencyLockCommitExtension;
import nebula.plugin.dependencylock.DependencyLockExtension;
import nebula.plugin.dependencylock.DependencyLockPlugin;
import nebula.plugin.dependencylock.DependencyLockReader;
import nebula.plugin.dependencylock.DependencyLockTaskConfigurer;
import nebula.plugin.dependencylock.GradleInteropKt;
import nebula.plugin.dependencylock.exceptions.DependencyLockException;
import nebula.plugin.dependencylock.utils.CoreLocking;
import nebula.plugin.dependencylock.utils.CoreLockingHelper;
import nebula.plugin.dependencylock.utils.DependencyResolutionVerifier;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.util.NameMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 @2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002@AB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J(\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0#H\u0002J \u0010$\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J\b\u0010'\u001a\u00020\u001cH\u0002J\u0016\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010,\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J$\u0010-\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u0016\u0010/\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\r0+H\u0002J\u001e\u00100\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J<\u00104\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\b\u00107\u001a\u0004\u0018\u00010\r2\b\u00108\u001a\u0004\u0018\u00010\rH\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\r0#2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010:\u001a\u00020\u001c2\u0006\u0010;\u001a\u00020!H\u0002J\u0016\u0010<\u001a\u00020)2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\r02H\u0002J\f\u0010>\u001a\u000203*\u00020?H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0002X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006B"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "LOGGER", "Lorg/gradle/api/logging/Logger;", "lockReader", "Lnebula/plugin/dependencylock/DependencyLockReader;", "getLockReader", "()Lnebula/plugin/dependencylock/DependencyLockReader;", "setLockReader", "(Lnebula/plugin/dependencylock/DependencyLockReader;)V", "lockUsed", "", "getLockUsed", "()Ljava/lang/String;", "setLockUsed", "(Ljava/lang/String;)V", "project", "getProject", "()Lorg/gradle/api/Project;", "setProject", "(Lorg/gradle/api/Project;)V", "reasons", "", "getReasons", "()Ljava/util/Set;", "apply", "", "applyLock", "conf", "Lorg/gradle/api/artifacts/Configuration;", "dependenciesLock", "Ljava/io/File;", "updates", "", "applyOverrides", "overrides", "", "disableCachingForGenerateLock", "hasGenerationTask", "", "cliTasks", "", "hasMigrationTask", "hasTask", "taskNames", "hasUpdateTask", "lockConfiguration", "selectorKeys", "", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "maybeApplyLock", "extension", "Lnebula/plugin/dependencylock/DependencyLockExtension;", "globalLockFileName", "lockFilename", "parseUpdates", "rewriteLocksUsingCoreLocking", "lockFile", "taskRunOnThisProject", "tokens", "toKey", "Lorg/gradle/api/artifacts/DependencyResolveDetails;", "Companion", "ModuleVersionSelectorKey", "gradle-dependency-lock-plugin"})
public final class DependencyLockPlugin
implements Plugin<Project> {
    private final Logger LOGGER;
    @NotNull
    public Project project;
    @NotNull
    public DependencyLockReader lockReader;
    @NotNull
    public String lockUsed;
    @NotNull
    private final Set<String> reasons;
    @NotNull
    public static final String EXTENSION_NAME = "dependencyLock";
    @NotNull
    public static final String COMMIT_EXTENSION_NAME = "commitDependencyLock";
    @NotNull
    public static final String GLOBAL_LOCK_FILE = "dependencyLock.globalLockFile";
    @NotNull
    public static final String LOCK_AFTER_EVALUATING = "dependencyLock.lockAfterEvaluating";
    @NotNull
    public static final String UPDATE_DEPENDENCIES = "dependencyLock.updateDependencies";
    @NotNull
    public static final String OVERRIDE = "dependencyLock.override";
    @NotNull
    public static final String OVERRIDE_FILE = "dependencyLock.overrideFile";
    @NotNull
    public static final String GENERATE_GLOBAL_LOCK_TASK_NAME = "generateGlobalLock";
    @NotNull
    public static final String UPDATE_GLOBAL_LOCK_TASK_NAME = "updateGlobalLock";
    @NotNull
    public static final String GENERATE_LOCK_TASK_NAME = "generateLock";
    @NotNull
    public static final String UPDATE_LOCK_TASK_NAME = "updateLock";
    @NotNull
    public static final String MIGRATE_TO_CORE_LOCK_TASK_NAME = "migrateToCoreLocks";
    @NotNull
    public static final String WRITE_CORE_LOCK_TASK_TO_RUN = "`./gradlew dependencies --write-locks`";
    @NotNull
    private static final Set<String> GENERATION_TASK_NAMES;
    @NotNull
    private static final Set<String> UPDATE_TASK_NAMES;
    @NotNull
    private static final Set<String> MIGRATION_TASK_NAMES;
    public static final Companion Companion;

    @NotNull
    public final Project getProject() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return project;
    }

    public final void setProject(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"<set-?>");
        this.project = project;
    }

    @NotNull
    public final DependencyLockReader getLockReader() {
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        return dependencyLockReader;
    }

    public final void setLockReader(@NotNull DependencyLockReader dependencyLockReader) {
        Intrinsics.checkParameterIsNotNull((Object)dependencyLockReader, (String)"<set-?>");
        this.lockReader = dependencyLockReader;
    }

    @NotNull
    public final String getLockUsed() {
        String string = this.lockUsed;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        }
        return string;
    }

    public final void setLockUsed(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.lockUsed = string;
    }

    @NotNull
    public final Set<String> getReasons() {
        return this.reasons;
    }

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.lockReader = new DependencyLockReader(project);
        DependencyLockExtension extension = (DependencyLockExtension)project.getExtensions().create(EXTENSION_NAME, DependencyLockExtension.class, new Object[0]);
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        DependencyLockCommitExtension commitExtension = (DependencyLockCommitExtension)project2.getExtensions().findByType(DependencyLockCommitExtension.class);
        if (commitExtension == null) {
            Project project3 = project.getRootProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project.rootProject");
            commitExtension = (DependencyLockCommitExtension)project3.getExtensions().create(COMMIT_EXTENSION_NAME, DependencyLockCommitExtension.class, new Object[0]);
        }
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        Map overrides = dependencyLockReader.readOverrides();
        String globalLockFilename = GradleInteropKt.findStringProperty(project, GLOBAL_LOCK_FILE);
        String lockFilename = new DependencyLockTaskConfigurer(project).configureTasks(globalLockFilename, extension, commitExtension, overrides);
        if (CoreLocking.isCoreLockingEnabled()) {
            List taskNames;
            File lockFile;
            this.LOGGER.warn(project.getName() + ": coreLockingSupport feature enabled");
            CoreLockingHelper coreLockingHelper = new CoreLockingHelper(project);
            DependencyLockExtension dependencyLockExtension = extension;
            Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
            coreLockingHelper.lockSelectedConfigurations(dependencyLockExtension.getConfigurationNames());
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            StartParameter startParameter = gradle.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
            if (!startParameter.getTaskNames().contains(MIGRATE_TO_CORE_LOCK_TASK_NAME)) {
                DependencyResolutionVerifier.verifySuccessfulResolution(project);
            }
            if ((lockFile = new File(project.getProjectDir(), extension.getLockFile())).exists()) {
                Gradle gradle2 = project.getGradle();
                Intrinsics.checkExpressionValueIsNotNull((Object)gradle2, (String)"project.gradle");
                StartParameter startParameter2 = gradle2.getStartParameter();
                Intrinsics.checkExpressionValueIsNotNull((Object)startParameter2, (String)"project.gradle.startParameter");
                if (startParameter2.isWriteDependencyLocks()) {
                    this.rewriteLocksUsingCoreLocking(lockFile);
                } else {
                    Gradle gradle3 = project.getGradle();
                    Intrinsics.checkExpressionValueIsNotNull((Object)gradle3, (String)"project.gradle");
                    StartParameter startParameter3 = gradle3.getStartParameter();
                    Intrinsics.checkExpressionValueIsNotNull((Object)startParameter3, (String)"project.gradle.startParameter");
                    List list = taskNames = startParameter3.getTaskNames();
                    Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskNames");
                    boolean hasMigrationTask = this.hasMigrationTask(list);
                    if (!hasMigrationTask) {
                        throw (Throwable)new BuildCancelledException("Legacy locks are not supported with core locking.\nIf you wish to migrate with the current locked dependencies, please use `./gradlew migrateToCoreLocks`\nAlternatively, please remove the legacy lockfile manually and use `./gradlew dependencies --write-locks`\n" + " - Legacy lock: " + lockFile.getAbsolutePath());
                    }
                }
            }
            Gradle gradle4 = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle4, (String)"project.gradle");
            StartParameter startParameter4 = gradle4.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter4, (String)"project.gradle.startParameter");
            List list = taskNames = startParameter4.getTaskNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(list);
            boolean hasGenerationTask = this.hasGenerationTask(taskNames);
            File globalLockFile = new File(project.getProjectDir(), extension.getGlobalLockFile());
            if (globalLockFile.exists() && !hasGenerationTask && !hasUpdateTask) {
                throw (Throwable)new BuildCancelledException("Legacy global locks are not supported with core locking.\nPlease remove global locks.\n" + " - Legacy global lock: " + globalLockFile.getAbsolutePath());
            }
        } else {
            void $this$groovyClosure$iv;
            boolean lockAfterEvaluating;
            boolean bl;
            Object lockFile;
            if (project.hasProperty(LOCK_AFTER_EVALUATING)) {
                lockFile = String.valueOf(project.property(LOCK_AFTER_EVALUATING));
                boolean taskNames = false;
                bl = Boolean.parseBoolean((String)lockFile);
            } else {
                DependencyLockExtension dependencyLockExtension = extension;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
                bl = lockAfterEvaluating = dependencyLockExtension.getLockAfterEvaluating();
            }
            if (lockAfterEvaluating) {
                this.LOGGER.info("Delaying dependency lock apply until beforeResolve (dependencyLock.lockAfterEvaluating set to true)");
            } else {
                this.LOGGER.info("Applying dependency lock during plugin apply (dependencyLock.lockAfterEvaluating set to false)");
            }
            this.disableCachingForGenerateLock();
            Gradle gradle = project.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            lockFile = this;
            TaskExecutionGraph taskExecutionGraph = gradle.getTaskGraph();
            boolean $i$f$groovyClosure = false;
            Closure closure = (Closure)new Closure<Unit>((Object)$this$groovyClosure$iv, (Object)$this$groovyClosure$iv, this){
                final /* synthetic */ Object $this_groovyClosure;
                final /* synthetic */ DependencyLockPlugin this$0;
                {
                    this.$this_groovyClosure = $receiver;
                    this.this$0 = dependencyLockPlugin;
                    super($super_call_param$2);
                }

                public final void doCall() {
                    boolean bl = false;
                    DependencyLockPlugin.access$disableCachingForGenerateLock(this.this$0);
                }
            };
            taskExecutionGraph.whenReady(closure);
            project.getConfigurations().all((Action)new Action<Configuration>(this, lockAfterEvaluating, extension, overrides, globalLockFilename, lockFilename){
                final /* synthetic */ DependencyLockPlugin this$0;
                final /* synthetic */ boolean $lockAfterEvaluating;
                final /* synthetic */ DependencyLockExtension $extension;
                final /* synthetic */ Map $overrides;
                final /* synthetic */ String $globalLockFilename;
                final /* synthetic */ String $lockFilename;

                public final void execute(Configuration conf) {
                    if (this.$lockAfterEvaluating) {
                        Configuration configuration = conf;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                        Configuration $this$onResolve$iv = configuration;
                        boolean $i$f$onResolve = false;
                        $this$onResolve$iv.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>($this$onResolve$iv, this, conf){
                            final /* synthetic */ Configuration $this_onResolve;
                            final /* synthetic */ apply.2 this$0;
                            final /* synthetic */ Configuration $conf$inlined;
                            {
                                this.$this_onResolve = configuration;
                                this.this$0 = var2_2;
                                this.$conf$inlined = configuration2;
                            }

                            public final void execute(ResolvableDependencies incoming) {
                                if (Intrinsics.areEqual((Object)this.$this_onResolve.getIncoming(), (Object)incoming)) {
                                    ResolvableDependencies resolvableDependencies = incoming;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"incoming");
                                    ResolvableDependencies it = resolvableDependencies;
                                    boolean bl = false;
                                    DependencyLockPlugin dependencyLockPlugin = this.this$0.this$0;
                                    Configuration configuration = this.$conf$inlined;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                                    DependencyLockExtension dependencyLockExtension = this.this$0.$extension;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
                                    Map map = this.this$0.$overrides;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"overrides");
                                    DependencyLockPlugin.access$maybeApplyLock(dependencyLockPlugin, configuration, dependencyLockExtension, map, this.this$0.$globalLockFilename, this.this$0.$lockFilename);
                                }
                            }
                        });
                    } else {
                        Configuration configuration = conf;
                        Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"conf");
                        DependencyLockExtension dependencyLockExtension = this.$extension;
                        Intrinsics.checkExpressionValueIsNotNull((Object)dependencyLockExtension, (String)"extension");
                        Map map = this.$overrides;
                        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"overrides");
                        DependencyLockPlugin.access$maybeApplyLock(this.this$0, configuration, dependencyLockExtension, map, this.$globalLockFilename, this.$lockFilename);
                    }
                }
                {
                    this.this$0 = dependencyLockPlugin;
                    this.$lockAfterEvaluating = bl;
                    this.$extension = dependencyLockExtension;
                    this.$overrides = map;
                    this.$globalLockFilename = string;
                    this.$lockFilename = string2;
                }
            });
        }
    }

    private final void disableCachingForGenerateLock() {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
        List list = startParameter.getTaskNames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"project.gradle.startParameter.taskNames");
        if (this.hasGenerationTask(list)) {
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            project2.getConfigurations().all((Action)disableCachingForGenerateLock.1.INSTANCE);
        }
    }

    private final void maybeApplyLock(Configuration conf, DependencyLockExtension extension, Map<?, ?> overrides, String globalLockFileName, String lockFilename) {
        File file;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        Project project2 = project.getRootProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.rootProject");
        File file2 = project2.getProjectDir();
        String string = globalLockFileName;
        if (string == null) {
            string = extension.getGlobalLockFile();
        }
        File globalLock = new File(file2, string);
        if (globalLock.exists()) {
            file = globalLock;
        } else {
            Project project3 = this.project;
            if (project3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            File file3 = project3.getProjectDir();
            String string2 = lockFilename;
            if (string2 == null) {
                string2 = extension.getLockFile();
            }
            file = new File(file3, string2);
        }
        File dependenciesLock = file;
        String string3 = dependenciesLock.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"dependenciesLock.name");
        this.lockUsed = string3;
        StringBuilder stringBuilder = new StringBuilder().append("nebula.dependency-lock locked with: ");
        String string4 = this.lockUsed;
        if (string4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockUsed");
        }
        this.reasons.add(stringBuilder.append(string4).toString());
        Project project4 = this.project;
        if (project4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (!DependencyLockTaskConfigurer.shouldIgnoreDependencyLock(project4)) {
            Set<String> set;
            List taskNames;
            Project project5 = this.project;
            if (project5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Gradle gradle = project5.getGradle();
            Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
            StartParameter startParameter = gradle.getStartParameter();
            Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
            List list = taskNames = startParameter.getTaskNames();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"taskNames");
            boolean hasUpdateTask = this.hasUpdateTask(list);
            Project project6 = this.project;
            if (project6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            if (project6.hasProperty(UPDATE_DEPENDENCIES)) {
                Project project7 = this.project;
                if (project7 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"project");
                }
                Object object = project7.property(UPDATE_DEPENDENCIES);
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                set = this.parseUpdates((String)object);
            } else {
                set = extension.getUpdateDependencies();
            }
            Set<String> updates = set;
            StringBuilder stringBuilder2 = new StringBuilder();
            Project project8 = this.project;
            if (project8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            StringBuilder stringBuilder3 = stringBuilder2.append(project8.getGroup()).append(':');
            Project project9 = this.project;
            if (project9 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            String projectCoord = stringBuilder3.append(project9.getName()).toString();
            if (hasUpdateTask) {
                boolean bl;
                block26: {
                    Set<String> set2 = updates;
                    Intrinsics.checkExpressionValueIsNotNull(set2, (String)"updates");
                    Iterable $this$any$iv = set2;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)projectCoord)) continue;
                            bl = true;
                            break block26;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    throw (Throwable)new DependencyLockException("Dependency locks cannot be updated. An update was requested for a project dependency (" + projectCoord + ')');
                }
            }
            boolean hasGenerateTask = this.hasGenerationTask(taskNames);
            if (dependenciesLock.exists()) {
                if (!hasGenerateTask) {
                    DependencyLockPlugin.applyLock$default(this, conf, dependenciesLock, null, 4, null);
                } else if (hasUpdateTask) {
                    Set<String> set3 = updates;
                    Intrinsics.checkExpressionValueIsNotNull(set3, (String)"updates");
                    this.applyLock(conf, dependenciesLock, set3);
                }
            }
            this.applyOverrides(conf, overrides);
        }
    }

    private final boolean hasGenerationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)GENERATION_TASK_NAMES);
    }

    private final boolean hasUpdateTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)UPDATE_TASK_NAMES);
    }

    private final boolean hasMigrationTask(Collection<String> cliTasks) {
        return this.hasTask(cliTasks, (Collection<String>)MIGRATION_TASK_NAMES);
    }

    private final boolean hasTask(Collection<String> cliTasks, Collection<String> taskNames) {
        Object v1;
        block1: {
            NameMatcher matcher = new NameMatcher();
            Iterable iterable = cliTasks;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                String cliTaskName = (String)t;
                boolean bl3 = false;
                List tokens = StringsKt.split$default((CharSequence)cliTaskName, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                String taskName = (String)CollectionsKt.last((List)tokens);
                String generatesPresent = matcher.find(taskName, taskNames);
                boolean bl4 = generatesPresent != null && this.taskRunOnThisProject(tokens);
                if (!bl4) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        String found = v1;
        return found != null;
    }

    private final boolean taskRunOnThisProject(List<String> tokens) {
        if (tokens.size() == 1) {
            return true;
        }
        if (tokens.size() == 2 && Intrinsics.areEqual((Object)tokens.get(0), (Object)"")) {
            Project project = this.project;
            if (project == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            return Intrinsics.areEqual((Object)project, (Object)project2.getRootProject());
        }
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        return Intrinsics.areEqual((Object)project.getName(), (Object)tokens.get(tokens.size() - 2));
    }

    private final Set<String> parseUpdates(String updates) {
        return CollectionsKt.toSet((Iterable)StringsKt.split$default((CharSequence)updates, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    private final void applyLock(Configuration conf, File dependenciesLock, Set<String> updates) {
        Map locks;
        this.LOGGER.info("Using " + dependenciesLock.getName() + " to lock dependencies in " + conf);
        DependencyLockReader dependencyLockReader = this.lockReader;
        if (dependencyLockReader == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lockReader");
        }
        if ((locks = dependencyLockReader.readLocks(conf, dependenciesLock, (Collection<String>)updates)) != null) {
            void $this$mapTo$iv$iv;
            boolean bl;
            String string;
            Map map;
            Map.Entry it;
            Map $this$filterTo$iv$iv;
            Map $this$filter$iv = locks;
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            void var11_10 = $this$filterTo$iv$iv;
            boolean bl2 = false;
            Iterator iterator = var11_10.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                it = element$iv$iv = iterator.next();
                boolean bl3 = false;
                Object v = it.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                map = (Map)v;
                string = "locked";
                bl = false;
                Map map3 = map;
                if (map3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
                }
                if (!map3.containsKey(string)) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            Map $this$map$iv = destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            var11_10 = $this$mapTo$iv$iv;
            bl2 = false;
            for (Map.Entry item$iv$iv : var11_10.entrySet()) {
                it = item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl4 = false;
                Object v = it.getValue();
                if (v == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<*, *>");
                }
                map = (Map)v;
                string = "locked";
                bl = false;
                Object version = map.get(string);
                ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), version);
                object.add(moduleVersionSelectorKey);
            }
            List locked = (List)destination$iv$iv;
            this.LOGGER.debug("locked: {}", (Object)locked);
            this.lockConfiguration(conf, locked);
        }
    }

    static /* synthetic */ void applyLock$default(DependencyLockPlugin dependencyLockPlugin, Configuration configuration, File file, Set set, int n, Object object) {
        if ((n & 4) != 0) {
            set = SetsKt.emptySet();
        }
        dependencyLockPlugin.applyLock(configuration, file, set);
    }

    /*
     * WARNING - void declaration
     */
    private final void applyOverrides(Configuration conf, Map<?, ?> overrides) {
        void $this$mapTo$iv$iv;
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project.hasProperty(OVERRIDE_FILE)) {
            StringBuilder stringBuilder = new StringBuilder().append("Using override file ");
            Project project2 = this.project;
            if (project2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.LOGGER.info(stringBuilder.append(project2.property(OVERRIDE_FILE)).append(" to lock dependencies").toString());
            StringBuilder stringBuilder2 = new StringBuilder().append("nebula.dependency-lock using override file: ");
            Project project3 = this.project;
            if (project3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.reasons.add(stringBuilder2.append(project3.property(OVERRIDE_FILE)).toString());
        }
        Project project4 = this.project;
        if (project4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        if (project4.hasProperty(OVERRIDE)) {
            StringBuilder stringBuilder = new StringBuilder().append("Using command line overrides ");
            Project project5 = this.project;
            if (project5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.LOGGER.info(stringBuilder.append(project5.property(OVERRIDE)).toString());
            StringBuilder stringBuilder3 = new StringBuilder().append("nebula.dependency-lock using override: ");
            Project project6 = this.project;
            if (project6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"project");
            }
            this.reasons.add(stringBuilder3.append(project6.property(OVERRIDE)).toString());
        }
        Map<?, ?> $this$map$iv = overrides;
        boolean $i$f$map = false;
        Map<?, ?> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var9_8 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var9_8.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            ModuleVersionSelectorKey moduleVersionSelectorKey = ModuleVersionSelectorKey.Companion.create(it.getKey(), it.getValue());
            collection.add(moduleVersionSelectorKey);
        }
        List overrideDeps = (List)destination$iv$iv;
        this.LOGGER.debug("overrides: {}", (Object)overrideDeps);
        this.lockConfiguration(conf, overrideDeps);
    }

    /*
     * WARNING - void declaration
     */
    private final void lockConfiguration(Configuration conf, List<ModuleVersionSelectorKey> selectorKeys) {
        void $this$mapValuesTo$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = selectorKeys;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object element$iv$iv = iterator.next();
            ModuleVersionSelectorKey it = (ModuleVersionSelectorKey)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map2 = map;
            boolean bl3 = false;
            ModuleVersionSelectorKey moduleVersionSelectorKey = (ModuleVersionSelectorKey)it.getKey();
            map2.put(k2, moduleVersionSelectorKey);
        }
        Map selectorsByKey = destination$iv$iv;
        conf.getResolutionStrategy().eachDependency((Action)new Action<DependencyResolveDetails>(this, selectorsByKey){
            final /* synthetic */ DependencyLockPlugin this$0;
            final /* synthetic */ Map $selectorsByKey;

            public final void execute(DependencyResolveDetails details) {
                DependencyResolveDetails dependencyResolveDetails = details;
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencyResolveDetails, (String)"details");
                ModuleVersionSelectorKey moduleKey = DependencyLockPlugin.access$toKey(this.this$0, dependencyResolveDetails);
                ModuleVersionSelectorKey module = (ModuleVersionSelectorKey)this.$selectorsByKey.get(moduleKey);
                if (module != null) {
                    details.because(moduleKey.toModuleString() + " locked to " + module.getVersion() + '\n' + "\twith reasons: " + CollectionsKt.joinToString$default((Iterable)this.this$0.getReasons(), null, null, null, (int)0, null, null, (int)63, null)).useTarget(module.toMap());
                }
            }
            {
                this.this$0 = dependencyLockPlugin;
                this.$selectorsByKey = map;
            }
        });
    }

    private final ModuleVersionSelectorKey toKey(@NotNull DependencyResolveDetails $this$toKey) {
        ModuleVersionSelector moduleVersionSelector = $this$toKey.getRequested();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionSelector, (String)"requested");
        String string = moduleVersionSelector.getGroup();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"requested.group");
        ModuleVersionSelector moduleVersionSelector2 = $this$toKey.getRequested();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionSelector2, (String)"requested");
        String string2 = moduleVersionSelector2.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"requested.name");
        ModuleVersionSelector moduleVersionSelector3 = $this$toKey.getRequested();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleVersionSelector3, (String)"requested");
        return new ModuleVersionSelectorKey(string, string2, moduleVersionSelector3.getVersion());
    }

    private final void rewriteLocksUsingCoreLocking(File lockFile) {
        Project project = this.project;
        if (project == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"project");
        }
        File dependencyLockDirectory = new File(project.getProjectDir(), "/gradle/dependency-locks");
        this.LOGGER.warn("Removing legacy locks to use core Gradle locking. This will remove legacy locks.This is not a migration.\n" + " - Legacy lock: " + lockFile.getAbsolutePath() + '\n' + " - Core Gradle locks: " + dependencyLockDirectory.getAbsoluteFile() + '\n' + "\n" + "To migrate your currently locked state, please run `./gradlew migrateToCoreLocks`");
        String failureToDeleteLockfileMessage = "Failed to delete legacy locks.\nPlease remove the legacy lock file manually.\n" + " - Legacy lock: " + lockFile.getAbsolutePath();
        try {
            if (!lockFile.delete()) {
                throw (Throwable)new BuildCancelledException(failureToDeleteLockfileMessage);
            }
        }
        catch (Exception e) {
            throw (Throwable)new BuildCancelledException(failureToDeleteLockfileMessage, (Throwable)e);
        }
    }

    public DependencyLockPlugin() {
        Set set;
        Logger logger = Logging.getLogger(DependencyLockPlugin.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logging.getLogger(Depend\u2026cyLockPlugin::class.java)");
        this.LOGGER = logger;
        DependencyLockPlugin dependencyLockPlugin = this;
        boolean bl = false;
        dependencyLockPlugin.reasons = set = (Set)new LinkedHashSet();
    }

    static {
        Companion = new Companion(null);
        GENERATION_TASK_NAMES = SetsKt.setOf((Object[])new String[]{GENERATE_LOCK_TASK_NAME, GENERATE_GLOBAL_LOCK_TASK_NAME, UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME});
        UPDATE_TASK_NAMES = SetsKt.setOf((Object[])new String[]{UPDATE_LOCK_TASK_NAME, UPDATE_GLOBAL_LOCK_TASK_NAME});
        MIGRATION_TASK_NAMES = SetsKt.setOf((Object)MIGRATE_TO_CORE_LOCK_TASK_NAME);
    }

    public static final /* synthetic */ void access$disableCachingForGenerateLock(DependencyLockPlugin $this) {
        $this.disableCachingForGenerateLock();
    }

    public static final /* synthetic */ void access$maybeApplyLock(DependencyLockPlugin $this, Configuration conf, DependencyLockExtension extension, Map overrides, String globalLockFileName, String lockFilename) {
        $this.maybeApplyLock(conf, extension, overrides, globalLockFileName, lockFilename);
    }

    public static final /* synthetic */ ModuleVersionSelectorKey access$toKey(DependencyLockPlugin $this, DependencyResolveDetails $this$access_u24toKey) {
        return $this.toKey($this$access_u24toKey);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0011J\u0006\u0010\u0012\u001a\u00020\u0003J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "", "group", "", "name", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "getVersion", "equals", "", "other", "hashCode", "", "toMap", "", "toModuleString", "toString", "Companion", "gradle-dependency-lock-plugin"})
    private static final class ModuleVersionSelectorKey {
        @NotNull
        private final String group;
        @NotNull
        private final String name;
        @Nullable
        private final String version;
        public static final Companion Companion = new Companion(null);

        public int hashCode() {
            return Objects.hash(this.group, this.name);
        }

        public boolean equals(@Nullable Object other) {
            Object object = other;
            return object instanceof ModuleVersionSelectorKey ? Intrinsics.areEqual((Object)this.group, (Object)((ModuleVersionSelectorKey)other).group) && Intrinsics.areEqual((Object)this.name, (Object)((ModuleVersionSelectorKey)other).name) : false;
        }

        @NotNull
        public final Map<String, String> toMap() {
            return MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"group", (Object)this.group), TuplesKt.to((Object)"name", (Object)this.name), TuplesKt.to((Object)"version", (Object)this.version)});
        }

        @NotNull
        public final String toModuleString() {
            return this.group + ':' + this.name;
        }

        @NotNull
        public String toString() {
            return this.group + ':' + this.name + ':' + this.version;
        }

        @NotNull
        public final String getGroup() {
            return this.group;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public ModuleVersionSelectorKey(@NotNull String group, @NotNull String name, @Nullable String version) {
            Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0007"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey$Companion;", "", "()V", "create", "Lnebula/plugin/dependencylock/DependencyLockPlugin$ModuleVersionSelectorKey;", "notation", "version", "gradle-dependency-lock-plugin"})
        public static final class Companion {
            @NotNull
            public final ModuleVersionSelectorKey create(@Nullable Object notation, @Nullable Object version) {
                Object object = notation;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                String cfr_ignored_0 = (String)object;
                String group = StringsKt.substringBefore$default((String)((String)notation), (String)":", null, (int)2, null);
                String name = StringsKt.substringAfter$default((String)((String)notation), (String)":", null, (int)2, null);
                Object object2 = version;
                if (object2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                return new ModuleVersionSelectorKey(group, name, (String)object2);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnebula/plugin/dependencylock/DependencyLockPlugin$Companion;", "", "()V", "COMMIT_EXTENSION_NAME", "", "EXTENSION_NAME", "GENERATE_GLOBAL_LOCK_TASK_NAME", "GENERATE_LOCK_TASK_NAME", "GENERATION_TASK_NAMES", "", "getGENERATION_TASK_NAMES", "()Ljava/util/Set;", "GLOBAL_LOCK_FILE", "LOCK_AFTER_EVALUATING", "MIGRATE_TO_CORE_LOCK_TASK_NAME", "MIGRATION_TASK_NAMES", "getMIGRATION_TASK_NAMES", "OVERRIDE", "OVERRIDE_FILE", "UPDATE_DEPENDENCIES", "UPDATE_GLOBAL_LOCK_TASK_NAME", "UPDATE_LOCK_TASK_NAME", "UPDATE_TASK_NAMES", "getUPDATE_TASK_NAMES", "WRITE_CORE_LOCK_TASK_TO_RUN", "gradle-dependency-lock-plugin"})
    public static final class Companion {
        @NotNull
        public final Set<String> getGENERATION_TASK_NAMES() {
            return GENERATION_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getUPDATE_TASK_NAMES() {
            return UPDATE_TASK_NAMES;
        }

        @NotNull
        public final Set<String> getMIGRATION_TASK_NAMES() {
            return MIGRATION_TASK_NAMES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

