/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.info.scm;

import groovy.lang.MetaClass;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import nebula.plugin.info.scm.AbstractScmProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.gradle.api.Project;
import org.gradle.api.provider.ProviderFactory;

public class GitScmProvider
extends AbstractScmProvider {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitScmProvider(ProviderFactory providerFactory) {
        super(providerFactory);
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public boolean supports(Project project) {
        return this.findFile(project.getProjectDir(), ".git") != null;
    }

    private Repository getRepository(File projectDir) {
        return ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir)).build();
    }

    @Override
    public String calculateModuleOrigin(File projectDir) {
        Repository repository = this.getRepository(projectDir);
        StoredConfig storedConfig = repository.getConfig();
        String remoteOriginUrl = storedConfig.getString("remote", "origin", "url");
        URL url = ResourceGroovyMethods.toURL((String)remoteOriginUrl);
        if (DefaultTypeTransformation.booleanUnbox((Object)url.getUserInfo())) {
            URL uRL;
            String user = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)url.getUserInfo().split(":"), Object[].class))));
            url = uRL = new URL(url.getProtocol(), StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)user, (CharSequence)"@"), (CharSequence)url.getHost()), url.getPort(), url.getFile());
        }
        String string = url.toExternalForm();
        try {
            return string;
        }
        catch (MalformedURLException ignore) {
            String string2 = remoteOriginUrl;
            return string2;
        }
    }

    @Override
    public String calculateModuleSource(File projectDir) {
        Repository repository = this.getRepository(projectDir);
        File gitDir = repository.getDirectory();
        return StringGroovyMethods.minus((CharSequence)projectDir.getAbsolutePath(), (Object)gitDir.getParentFile().getAbsolutePath());
    }

    @Override
    public String calculateChange(File projectDir) {
        String string = this.calculateFullChange(projectDir);
        return string != null ? string.substring(0, 7) : null;
    }

    @Override
    public String calculateFullChange(File projectDir) {
        boolean isHashPresent = this.getProviderFactory().environmentVariable("GIT_COMMIT").isPresent();
        String hash = null;
        if (!isHashPresent) {
            String string;
            ObjectId head = this.getRepository(projectDir).resolve(Constants.HEAD);
            if (!DefaultTypeTransformation.booleanUnbox((Object)head)) {
                return ShortTypeHandling.castToString(null);
            }
            hash = string = head.getName();
        } else {
            Object object = this.getProviderFactory().environmentVariable("GIT_COMMIT").get();
            hash = ShortTypeHandling.castToString((Object)object);
        }
        return hash;
    }

    @Override
    public String calculateBranch(File projectDir) {
        return this.getRepository(projectDir).getBranch();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitScmProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

