/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.info.scm;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import nebula.plugin.info.scm.AbstractScmProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecOutput;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScmProvider
extends AbstractScmProvider {
    private Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitScmProvider(ProviderFactory providerFactory) {
        super(providerFactory);
        MetaClass metaClass;
        Logger logger;
        this.logger = logger = LoggerFactory.getLogger(GitScmProvider.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public boolean supports(Project project) {
        return this.findFile(project.getProjectDir(), ".git") != null;
    }

    @Override
    public String calculateModuleOrigin(File projectDir) {
        String remoteOriginUrl = this.executeGitCommand("git", "config", "--get", "remote.origin.url");
        URL url = ResourceGroovyMethods.toURL((String)remoteOriginUrl);
        if (DefaultTypeTransformation.booleanUnbox((Object)url.getUserInfo())) {
            URL uRL;
            String user = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)url.getUserInfo().split(":"), Object[].class))));
            url = uRL = new URL(url.getProtocol(), StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)user, (CharSequence)"@"), (CharSequence)url.getHost()), url.getPort(), url.getFile());
        }
        String string = url.toExternalForm();
        try {
            return string;
        }
        catch (MalformedURLException ignore) {
            String string2 = remoteOriginUrl;
            return string2;
        }
    }

    @Override
    public String calculateModuleSource(File projectDir) {
        String gitWorkDir = this.executeGitCommand("git", "rev-parse", "--show-toplevel");
        return StringGroovyMethods.minus((CharSequence)projectDir.getAbsolutePath(), (Object)new File(gitWorkDir).getAbsolutePath());
    }

    @Override
    public String calculateChange(File projectDir) {
        String string = this.calculateFullChange(projectDir);
        return string != null ? string.substring(0, 7) : null;
    }

    @Override
    public String calculateFullChange(File projectDir) {
        boolean isHashPresent = this.getProviderFactory().environmentVariable("GIT_COMMIT").isPresent();
        String hash = null;
        if (!isHashPresent) {
            String string;
            hash = string = this.executeGitCommand("git", "rev-parse", "HEAD");
        } else {
            Object object = this.getProviderFactory().environmentVariable("GIT_COMMIT").get();
            hash = ShortTypeHandling.castToString((Object)object);
        }
        return hash;
    }

    @Override
    public String calculateBranch(File projectDir) {
        return this.executeGitCommand("git", "rev-parse", "--abbrev-ref", "HEAD");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String executeGitCommand(Object ... args) {
        Reference args2 = new Reference((Object)args);
        try {
            public final class _executeGitCommand_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference args;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _executeGitCommand_closure1(Object _outerInstance, Object _thisObject, Reference args) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.args = reference = args;
                }

                public Boolean doCall(Object it) {
                    ((ExecSpec)it).commandLine((Object[])ScriptBytecodeAdapter.castToType((Object)this.args.get(), Object[].class));
                    boolean bl = true;
                    ((ExecSpec)it).setIgnoreExitValue(bl);
                    return true;
                }

                @Generated
                public Object[] getArgs() {
                    return (Object[])ScriptBytecodeAdapter.castToType((Object)this.args.get(), Object[].class);
                }

                @Generated
                public Object call(Object args) {
                    return this.doCall(args);
                }

                @Generated
                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Boolean doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _executeGitCommand_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            ExecOutput execOutput = this.getProviderFactory().exec((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _executeGitCommand_closure1(this, this, args2)), Action.class));
            if (!(execOutput.getResult().isPresent() && ((ExecResult)execOutput.getResult().get()).getExitValue() != 0)) return ((String)execOutput.getStandardOutput().getAsText().get()).replaceAll("\n", "").trim();
            this.logger.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Object[])((Object[])args2.get()), (String)" "), execOutput.getStandardError().getAsText().get()}, new String[]{"Could not execute Git command: ", " | Reason: ", ""})));
            return ShortTypeHandling.castToString(null);
        }
        catch (Exception e) {
            this.logger.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Object[])((Object[])args2.get()), (String)" ")}, new String[]{"Could not execute Git command: ", ""})));
            return ShortTypeHandling.castToString(null);
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitScmProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

