/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.info.scm;

import groovy.lang.Closure;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import java.io.File;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import nebula.plugin.info.scm.AbstractScmProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.process.ExecSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScmProvider
extends AbstractScmProvider {
    private Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private final Closure memoizedMethodClosure$calculateModuleOriginFile;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitScmProvider(ProviderFactory providerFactory) {
        super(providerFactory);
        Closure closure;
        MetaClass metaClass;
        Logger logger;
        this.logger = logger = LoggerFactory.getLogger(GitScmProvider.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.memoizedMethodClosure$calculateModuleOriginFile = closure = new _closure1(this, this).memoize();
    }

    @Override
    public boolean supports(Project project) {
        return this.findFile(project.getProjectDir(), ".git") != null;
    }

    @Override
    public String calculateModuleOrigin(File projectDir) {
        return ShortTypeHandling.castToString((Object)this.memoizedMethodClosure$calculateModuleOriginFile.call((Object)projectDir));
    }

    @Override
    public String calculateModuleSource(File projectDir) {
        String gitWorkDir = this.executeGitCommand("git", "rev-parse", "--show-toplevel");
        if (!DefaultTypeTransformation.booleanUnbox((Object)gitWorkDir)) {
            return projectDir.getAbsolutePath();
        }
        return StringGroovyMethods.minus((CharSequence)projectDir.getAbsolutePath(), (Object)new File(gitWorkDir).getAbsolutePath());
    }

    @Override
    public String calculateChange(File projectDir) {
        String string = this.calculateFullChange(projectDir);
        return string != null ? string.substring(0, 7) : null;
    }

    @Override
    public String calculateFullChange(File projectDir) {
        boolean isHashPresent = this.getProviderFactory().environmentVariable("GIT_COMMIT").isPresent();
        String hash = null;
        hash = !isHashPresent ? this.executeGitCommand("git", "rev-parse", "HEAD") : ShortTypeHandling.castToString((Object)this.getProviderFactory().environmentVariable("GIT_COMMIT").get());
        return hash;
    }

    @Override
    public String calculateBranch(File projectDir) {
        return this.executeGitCommand("git", "rev-parse", "--abbrev-ref", "HEAD");
    }

    private String executeGitCommand(Object ... args) {
        Reference args2 = new Reference((Object)args);
        public final class _executeGitCommand_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference args;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _executeGitCommand_closure2(Object _outerInstance, Object _thisObject, Reference args) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.args = reference = args;
            }

            public ExecSpec doCall(Object it) {
                return ((ExecSpec)it).commandLine((Object[])ScriptBytecodeAdapter.castToType((Object)this.args.get(), Object[].class));
            }

            @Generated
            public Object[] getArgs() {
                return (Object[])ScriptBytecodeAdapter.castToType((Object)this.args.get(), Object[].class);
            }

            @Generated
            public Object call(Object args) {
                return this.doCall(args);
            }

            @Generated
            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public ExecSpec doCall() {
                CallSite[] callSiteArray = _executeGitCommand_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _executeGitCommand_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_executeGitCommand_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _executeGitCommand_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String string = ((String)this.getProviderFactory().exec((Action)ScriptBytecodeAdapter.castToType((Object)((Object)new _executeGitCommand_closure2(this, this, args2)), Action.class)).getStandardOutput().getAsText().get()).replaceAll("\n", "").trim();
        try {
            return string;
        }
        catch (Exception e) {
            this.logger.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Object[])((Object[])args2.get()), (String)" ")}, new String[]{"Could not execute Git command: ", ""})));
            String string2 = ShortTypeHandling.castToString(null);
            return string2;
        }
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitScmProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    protected String memoizedMethodPriv$calculateModuleOriginFile(File projectDir) {
        String remoteOriginUrl = this.executeGitCommand("git", "config", "--get", "remote.origin.url");
        URL url = ResourceGroovyMethods.toURL((String)remoteOriginUrl);
        if (DefaultTypeTransformation.booleanUnbox((Object)url.getUserInfo())) {
            String user = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.first((Object[])url.getUserInfo().split(":")));
            url = new URL(url.getProtocol(), StringGroovyMethods.plus((String)StringGroovyMethods.plus((String)user, (CharSequence)"@"), (CharSequence)url.getHost()), url.getPort(), url.getFile());
        }
        String string = url.toExternalForm();
        try {
            return string;
        }
        catch (MalformedURLException ignore) {
            String string2 = remoteOriginUrl;
            return string2;
        }
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public String doCall(File projectDir) {
            return ShortTypeHandling.castToString((Object)InvokerHelper.invokeMethodSafe((Object)((GitScmProvider)this.getThisObject()), (String)"memoizedMethodPriv$calculateModuleOriginFile", (Object)new Object[]{projectDir}));
        }

        @Generated
        public String call(File projectDir) {
            return this.doCall(projectDir);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

