/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.info.scm;

import groovy.lang.MetaClass;
import java.io.File;
import nebula.plugin.info.scm.AbstractScmProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.gradle.api.Project;

public class GitScmProvider
extends AbstractScmProvider {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitScmProvider() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public boolean supports(Project project) {
        return this.findFile(project.getProjectDir(), ".git") != null;
    }

    private Repository getRepository(File projectDir) {
        return ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir)).build();
    }

    @Override
    public String calculateModuleOrigin(File projectDir) {
        Repository repository = this.getRepository(projectDir);
        StoredConfig storedConfig = repository.getConfig();
        return storedConfig.getString("remote", "origin", "url");
    }

    @Override
    public String calculateModuleSource(File projectDir) {
        Repository repository = this.getRepository(projectDir);
        File gitDir = repository.getDirectory();
        return StringGroovyMethods.minus((CharSequence)projectDir.getAbsolutePath(), (Object)gitDir.getParentFile().getAbsolutePath());
    }

    @Override
    public String calculateChange(File projectDir) {
        String string;
        String hash = System.getenv("GIT_COMMIT");
        if (!DefaultTypeTransformation.booleanUnbox((Object)hash)) {
            String string2;
            ObjectId head = this.getRepository(projectDir).resolve(Constants.HEAD);
            if (!DefaultTypeTransformation.booleanUnbox((Object)head)) {
                return ShortTypeHandling.castToString(null);
            }
            hash = string2 = head.getName();
        }
        String shortHash = (string = hash) != null ? string.substring(0, 7) : null;
        return shortHash;
    }

    @Override
    public String calculateBranch(File projectDir) {
        return this.getRepository(projectDir).getBranch();
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitScmProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

