/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.info.scm;

import groovy.lang.MetaClass;
import java.io.File;
import nebula.plugin.info.scm.AbstractScmProvider;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitScmProvider
extends AbstractScmProvider {
    private Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public GitScmProvider() {
        MetaClass metaClass;
        Logger logger;
        this.logger = logger = LoggerFactory.getLogger(GitScmProvider.class);
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public boolean supports(Project project) {
        return this.findFile(project.getProjectDir(), ".git") != null;
    }

    private Repository getRepository(File projectDir) {
        return ((RepositoryBuilder)new RepositoryBuilder().findGitDir(projectDir)).build();
    }

    @Override
    public String calculateModuleOrigin(File projectDir) {
        String string;
        Repository repository = this.getRepository(projectDir);
        StoredConfig storedConfig = repository.getConfig();
        String url = storedConfig.getString("remote", "origin", "url");
        String string2 = url;
        if (DefaultTypeTransformation.booleanUnbox(string2 != null ? Boolean.valueOf(string2.startsWith("https://")) : null) || DefaultTypeTransformation.booleanUnbox((string = url) != null ? Boolean.valueOf(string.startsWith("http://")) : null)) {
            String string3;
            url = string3 = this.hideSensitiveInformation(url);
        }
        return url;
    }

    @Override
    public String calculateModuleSource(File projectDir) {
        Repository repository = this.getRepository(projectDir);
        File gitDir = repository.getDirectory();
        return StringGroovyMethods.minus((CharSequence)projectDir.getAbsolutePath(), (Object)gitDir.getParentFile().getAbsolutePath());
    }

    @Override
    public String calculateChange(File projectDir) {
        String string;
        String hash = System.getenv("GIT_COMMIT");
        if (!DefaultTypeTransformation.booleanUnbox((Object)hash)) {
            String string2;
            ObjectId head = this.getRepository(projectDir).resolve(Constants.HEAD);
            if (!DefaultTypeTransformation.booleanUnbox((Object)head)) {
                return ShortTypeHandling.castToString(null);
            }
            hash = string2 = head.getName();
        }
        String shortHash = (string = hash) != null ? string.substring(0, 7) : null;
        return shortHash;
    }

    @Override
    public String calculateBranch(File projectDir) {
        return this.getRepository(projectDir).getBranch();
    }

    private String hideSensitiveInformation(String url) {
        block5: {
            String credentials = ResourceGroovyMethods.toURL((String)url).getUserInfo();
            if (!DefaultTypeTransformation.booleanUnbox((Object)credentials)) break block5;
            String string = url.replaceFirst(credentials, credentials.replaceFirst(":.*", ""));
            try {
                return string;
            }
            catch (Exception e) {
                this.logger.warn("Unable to remove credentials from repository URL. {0}", (Object)e.getMessage());
            }
        }
        return url;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != GitScmProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }
}

