/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactType;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ExtensionsKt;
import com.netflix.gradle.jakartaee.specifications.Specification;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import com.netflix.gradle.jakartaee.specifications.api.Api;
import com.netflix.gradle.jakartaee.specifications.impl.Impl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.artifacts.CacheableRule;
import org.gradle.api.artifacts.CapabilityResolutionDetails;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.ComponentMetadataRule;
import org.gradle.api.artifacts.ComponentVariantIdentifier;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.VariantMetadata;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.dsl.ComponentMetadataHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.capabilities.MutableCapabilitiesMetadata;
import org.jetbrains.annotations.NotNull;

@CacheableRule
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\ba\u0018\u0000 &2\u00020\u0001:\u0001&J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH&J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H&J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH&J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0012\u0010\u000f\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0005\u00a8\u0006'"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/Specification;", "Lorg/gradle/api/artifacts/ComponentMetadataRule;", "capabilityGroup", "", "getCapabilityGroup", "()Ljava/lang/String;", "coordinates", "", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "getCoordinates", "()Ljava/util/List;", "jakartaCoordinates", "getJakartaCoordinates", "javaxCoordinates", "getJavaxCoordinates", "name", "getName", "artifactType", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactType;", "artifactCoordinate", "configureCapabilities", "", "dependencies", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "configureCapabilitiesResolution", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "execute", "context", "Lorg/gradle/api/artifacts/ComponentMetadataContext;", "implementationForSpecification", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "specificationVersion", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "implementationVersionFor", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "artifactVersion", "substitute", "Companion", "gradle-jakartaee-migration-plugin"})
public interface Specification
extends ComponentMetadataRule {
    @NotNull
    public static final Companion Companion = com.netflix.gradle.jakartaee.specifications.Specification$Companion.$$INSTANCE;

    @NotNull
    public String getName();

    @NotNull
    public List<ArtifactCoordinate> getCoordinates();

    @NotNull
    public List<ArtifactCoordinate> getJavaxCoordinates();

    @NotNull
    public List<ArtifactCoordinate> getJakartaCoordinates();

    @NotNull
    public String getCapabilityGroup();

    @NotNull
    public ArtifactType artifactType(@NotNull ArtifactCoordinate var1);

    @NotNull
    public ArtifactVersion implementationVersionFor(@NotNull ArtifactVersionCoordinate var1);

    @NotNull
    public ArtifactVersionCoordinate implementationForSpecification(@NotNull SpecificationVersion var1);

    public void configureCapabilities(@NotNull DependencyHandler var1);

    public void execute(@NotNull ComponentMetadataContext var1);

    public void configureCapabilitiesResolution(@NotNull Configuration var1);

    public void substitute(@NotNull Configuration var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/Specification$Companion;", "", "()V", "IMPLEMENTATIONS", "", "Lcom/netflix/gradle/jakartaee/specifications/Specification;", "getIMPLEMENTATIONS", "()Ljava/util/List;", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final List<Specification> IMPLEMENTATIONS;

        private Companion() {
        }

        @NotNull
        public final List<Specification> getIMPLEMENTATIONS() {
            return IMPLEMENTATIONS;
        }

        static {
            $$INSTANCE = new Companion();
            IMPLEMENTATIONS = CollectionsKt.plus((Collection)Api.Companion.getIMPLEMENTATIONS(), (Iterable)Impl.Companion.getIMPLEMENTATIONS());
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Specification.kt\ncom/netflix/gradle/jakartaee/specifications/Specification$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1855#2,2:123\n1559#2:125\n1590#2,4:126\n*S KotlinDebug\n*F\n+ 1 Specification.kt\ncom/netflix/gradle/jakartaee/specifications/Specification$DefaultImpls\n*L\n67#1:123,2\n82#1:125\n82#1:126,4\n*E\n"})
    public static final class DefaultImpls {
        public static void configureCapabilities(@NotNull Specification $this, @NotNull DependencyHandler dependencies) {
            Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
            ComponentMetadataHandler components = dependencies.getComponents();
            Iterable $this$forEach$iv = $this.getCoordinates();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ArtifactCoordinate coordinate = (ArtifactCoordinate)element$iv;
                boolean bl = false;
                components.withModule((Object)coordinate.getNotation(), $this.getClass());
            }
        }

        public static void execute(@NotNull Specification $this, @NotNull ComponentMetadataContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            context.getDetails().allVariants(arg_0 -> DefaultImpls.execute$lambda$1((Function1)new Function1<VariantMetadata, Unit>($this, context){
                final /* synthetic */ Specification this$0;
                final /* synthetic */ ComponentMetadataContext $context;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(VariantMetadata metadata) {
                    metadata.withCapabilities(arg_0 -> execute.1.invoke$lambda$0((Function1)new Function1<MutableCapabilitiesMetadata, Unit>(this.this$0, this.$context){
                        final /* synthetic */ Specification this$0;
                        final /* synthetic */ ComponentMetadataContext $context;
                        {
                            this.this$0 = $receiver;
                            this.$context = $context;
                            super(1);
                        }

                        public final void invoke(MutableCapabilitiesMetadata it) {
                            it.addCapability(this.this$0.getCapabilityGroup(), this.this$0.getName(), this.$context.getDetails().getId().getVersion());
                        }
                    }, arg_0));
                }

                private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    $tmp0.invoke(p0);
                }
            }, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        public static void configureCapabilitiesResolution(@NotNull Specification $this, @NotNull Configuration configuration) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Iterable $this$mapIndexed$iv = $this.getCoordinates();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void coordinate;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                ArtifactCoordinate artifactCoordinate = (ArtifactCoordinate)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)coordinate, (Object)((int)index)));
            }
            Map coordinateToOrdinal = MapsKt.toMap((Iterable)((List)destination$iv$iv));
            String capability = $this.getCapabilityGroup() + ':' + $this.getName();
            configuration.getResolutionStrategy().getCapabilitiesResolution().withCapability((Object)capability, arg_0 -> DefaultImpls.configureCapabilitiesResolution$lambda$3((Function1)new Function1<CapabilityResolutionDetails, Unit>((Map<ArtifactCoordinate, Integer>)coordinateToOrdinal, $this){
                final /* synthetic */ Map<ArtifactCoordinate, Integer> $coordinateToOrdinal;
                final /* synthetic */ Specification this$0;
                {
                    this.$coordinateToOrdinal = $coordinateToOrdinal;
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(CapabilityResolutionDetails details) {
                    T t;
                    void $this$maxBy$iv;
                    Iterable $this$sortedByDescending$iv;
                    ComponentVariantIdentifier it;
                    void $this$filterTo$iv$iv;
                    details.because("Provides the highest EE specification version");
                    List list = details.getCandidates();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"details.candidates");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        it = (ComponentVariantIdentifier)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getId() instanceof ModuleComponentIdentifier)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    Object object = this.$coordinateToOrdinal;
                    boolean $i$f$sortedByDescending = false;
                    $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator((Map)object){
                        final /* synthetic */ Map $coordinateToOrdinal$inlined;
                        {
                            this.$coordinateToOrdinal$inlined = map;
                        }

                        public final int compare(T a, T b) {
                            ComponentVariantIdentifier it = (ComponentVariantIdentifier)b;
                            boolean bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            ArtifactVersionCoordinate coordinate = ExtensionsKt.toCoordinate(it);
                            it = (ComponentVariantIdentifier)a;
                            Comparable comparable = (Integer)this.$coordinateToOrdinal$inlined.get(coordinate.getModule());
                            bl = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            coordinate = ExtensionsKt.toCoordinate(it);
                            return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Integer)this.$coordinateToOrdinal$inlined.get(coordinate.getModule())));
                        }
                    });
                    object = this.this$0;
                    boolean $i$f$maxByOrThrow = false;
                    Iterator<T> iterator$iv = $this$maxBy$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    T maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        t = maxElem$iv;
                    } else {
                        ArtifactVersion artifactVersion;
                        ComponentVariantIdentifier it2 = (ComponentVariantIdentifier)maxElem$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                        ArtifactVersionCoordinate coordinate = ExtensionsKt.toCoordinate(it2);
                        if (object.artifactType(coordinate.getModule()) == ArtifactType.EMBED) {
                            details.because("Provides an embedded EE API and implementation");
                            artifactVersion = new ArtifactVersion("2147483647");
                        } else {
                            artifactVersion = object.implementationVersionFor(coordinate);
                        }
                        Comparable maxValue$iv = artifactVersion;
                        do {
                            Comparable v$iv;
                            ArtifactVersion artifactVersion2;
                            T e$iv = iterator$iv.next();
                            it = (ComponentVariantIdentifier)e$iv;
                            $i$a$-maxByOrThrow-Specification$configureCapabilitiesResolution$1$candidate$3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            ArtifactVersionCoordinate coordinate2 = ExtensionsKt.toCoordinate(it);
                            if (object.artifactType(coordinate2.getModule()) == ArtifactType.EMBED) {
                                details.because("Provides an embedded EE API and implementation");
                                artifactVersion2 = new ArtifactVersion("2147483647");
                            } else {
                                artifactVersion2 = object.implementationVersionFor(coordinate2);
                            }
                            if (maxValue$iv.compareTo(v$iv = (Comparable)artifactVersion2) >= 0) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        t = maxElem$iv;
                    }
                    ComponentVariantIdentifier candidate = (ComponentVariantIdentifier)t;
                    details.select(candidate);
                }
            }, arg_0));
        }

        public static void substitute(@NotNull Specification $this, @NotNull Configuration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            configuration.getResolutionStrategy().dependencySubstitution(arg_0 -> DefaultImpls.substitute$lambda$4((Function1)new Function1<DependencySubstitutions, Unit>($this){
                final /* synthetic */ Specification this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(DependencySubstitutions substitution) {
                    ArtifactVersionCoordinate jakartaImplementation = this.this$0.implementationForSpecification(SpecificationVersion.EE10);
                    ComponentSelector to = substitution.module(jakartaImplementation.getNotation());
                    Iterable $this$forEach$iv = this.this$0.getJavaxCoordinates();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        ArtifactCoordinate coordinate = (ArtifactCoordinate)element$iv;
                        boolean bl = false;
                        ComponentSelector from = substitution.module(coordinate.getNotation());
                        substitution.substitute(from).using(to).because("At least Jakarta EE 10 is required");
                    }
                }
            }, arg_0));
        }

        private static void execute$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static void configureCapabilitiesResolution$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static void substitute$lambda$4(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }
    }
}

