/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications.impl;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import com.netflix.gradle.jakartaee.specifications.impl.BasicImpl;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/impl/XmlBind;", "Lcom/netflix/gradle/jakartaee/specifications/impl/BasicImpl;", "()V", "substitute", "", "configuration", "Lorg/gradle/api/artifacts/Configuration;", "Companion", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nXmlBind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlBind.kt\ncom/netflix/gradle/jakartaee/specifications/impl/XmlBind\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class XmlBind
extends BasicImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ArtifactCoordinate GLASSFISH = new ArtifactCoordinate("org.glassfish.jaxb", "jaxb-runtime");
    @NotNull
    private static final ArtifactCoordinate SUN = new ArtifactCoordinate("com.sun.xml.bind", "jaxb-impl");
    @NotNull
    private static final Map<SpecificationVersion, ArtifactVersion> SPECIFICATION_TO_XML_BIND_VERSION;
    private static final Method SUBSTITUTIONS_ADD_RULE;

    public XmlBind() {
        super("xml.bind", GLASSFISH, SUN, SPECIFICATION_TO_XML_BIND_VERSION);
    }

    @Override
    public void substitute(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Object[] objectArray = new ArtifactCoordinate[]{SUN, GLASSFISH};
        List coordinates = CollectionsKt.listOf((Object[])objectArray);
        Action substitutionAction = arg_0 -> XmlBind.substitute$lambda$0(coordinates, arg_0);
        Object[] objectArray2 = new Object[]{substitutionAction, false};
        SUBSTITUTIONS_ADD_RULE.invoke((Object)configuration.getResolutionStrategy().getDependencySubstitution(), objectArray2);
    }

    private static final void substitute$lambda$0(List $coordinates, DependencySubstitution details) {
        Intrinsics.checkNotNullParameter((Object)$coordinates, (String)"$coordinates");
        ComponentSelector requested = details.getRequested();
        if (requested instanceof ModuleComponentSelector) {
            ModuleIdentifier moduleIdentifier = ((ModuleComponentSelector)requested).getModuleIdentifier();
            String string = moduleIdentifier.getGroup();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleIdentifier.group");
            String string2 = moduleIdentifier.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"moduleIdentifier.name");
            ArtifactCoordinate artifactCoordinate = new ArtifactCoordinate(string, string2);
            String string3 = ((ModuleComponentSelector)requested).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requested.version");
            ArtifactVersionCoordinate coordinate = artifactCoordinate.withVersion(string3);
            ArtifactVersion artifactVersion = SPECIFICATION_TO_XML_BIND_VERSION.get((Object)SpecificationVersion.EE10);
            Intrinsics.checkNotNull((Object)artifactVersion);
            ArtifactVersion minVersion = artifactVersion;
            if ($coordinates.contains(coordinate.getModule()) && coordinate.getVersion().compareTo(minVersion) < 0) {
                String message = "At least Jakarta EE 10 is required";
                ArtifactVersionCoordinate target = coordinate.getModule().withVersion(minVersion);
                details.useTarget((Object)target.getNotation(), message);
            }
        }
    }

    static {
        Object object = new Pair[]{TuplesKt.to((Object)((Object)SpecificationVersion.EE7), (Object)new ArtifactVersion("2.2.0")), TuplesKt.to((Object)((Object)SpecificationVersion.EE8), (Object)new ArtifactVersion("2.3.0")), TuplesKt.to((Object)((Object)SpecificationVersion.EE9), (Object)new ArtifactVersion("3.0.0")), TuplesKt.to((Object)((Object)SpecificationVersion.EE9_1), (Object)new ArtifactVersion("3.0.0")), TuplesKt.to((Object)((Object)SpecificationVersion.EE10), (Object)new ArtifactVersion("4.0.0"))};
        SPECIFICATION_TO_XML_BIND_VERSION = MapsKt.mapOf((Pair[])object);
        object = new Class[]{Action.class, Boolean.TYPE};
        Object $this$SUBSTITUTIONS_ADD_RULE_u24lambda_u241 = object = DefaultDependencySubstitutions.class.getDeclaredMethod("addSubstitution", (Class<?>)object);
        boolean bl = false;
        ((Method)$this$SUBSTITUTIONS_ADD_RULE_u24lambda_u241).setAccessible(true);
        SUBSTITUTIONS_ADD_RULE = object;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/impl/XmlBind$Companion;", "", "()V", "GLASSFISH", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "SPECIFICATION_TO_XML_BIND_VERSION", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "SUBSTITUTIONS_ADD_RULE", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "SUN", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

