/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UncheckedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.tomcat.jakartaee.EESpecProfile;
import org.apache.tomcat.jakartaee.EESpecProfiles;
import org.apache.tomcat.jakartaee.Migration;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisableCachingByDefault(because="Transform is fast enough not to benefit from caching")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b!\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u001c\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H'J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Parameters;", "()V", "excludedPaths", "", "", "getExcludedPaths", "()Ljava/util/List;", "excludedPaths$delegate", "Lkotlin/Lazy;", "includedPaths", "getIncludedPaths", "includedPaths$delegate", "transformInMemory", "", "getTransformInMemory", "()Z", "transformInMemory$delegate", "getInputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "toPaths", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "Companion", "Parameters", "TransformHandler", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nJakartaEeMigrationTransform.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JakartaEeMigrationTransform.kt\ncom/netflix/gradle/jakartaee/JakartaEeMigrationTransform\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,167:1\n1360#2:168\n1446#2,5:169\n2624#2,3:174\n1747#2,3:177\n*S KotlinDebug\n*F\n+ 1 JakartaEeMigrationTransform.kt\ncom/netflix/gradle/jakartaee/JakartaEeMigrationTransform\n*L\n95#1:168\n95#1:169,5\n111#1:174,3\n116#1:177,3\n*E\n"})
public abstract class JakartaEeMigrationTransform
implements TransformAction<Parameters> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy excludedPaths$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
        final /* synthetic */ JakartaEeMigrationTransform this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final List<String> invoke() {
            return JakartaEeMigrationTransform.access$toPaths(this.this$0, ((Parameters)this.this$0.getParameters()).getExcludedArtifacts());
        }
    }));
    @NotNull
    private final Lazy includedPaths$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends String>>(this){
        final /* synthetic */ JakartaEeMigrationTransform this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final List<String> invoke() {
            return JakartaEeMigrationTransform.access$toPaths(this.this$0, ((Parameters)this.this$0.getParameters()).getIncludedArtifacts());
        }
    }));
    @NotNull
    private final Lazy transformInMemory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Boolean>(this){
        final /* synthetic */ JakartaEeMigrationTransform this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Boolean invoke() {
            return ((Parameters)this.this$0.getParameters()).getTransformInMemory().get();
        }
    }));
    private static final Logger LOGGER = LoggerFactory.getLogger(JakartaEeMigrationTransform.class);

    private final List<String> getExcludedPaths() {
        Lazy lazy = this.excludedPaths$delegate;
        return (List)lazy.getValue();
    }

    private final List<String> getIncludedPaths() {
        Lazy lazy = this.includedPaths$delegate;
        return (List)lazy.getValue();
    }

    private final boolean getTransformInMemory() {
        Lazy lazy = this.transformInMemory$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toPaths(List<ArtifactCoordinate> $this$toPaths) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = $this$toPaths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ArtifactCoordinate it = (ArtifactCoordinate)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{'/' + it.getGroup() + '/' + it.getName() + '/', '/' + StringsKt.replace$default((String)it.getGroup(), (String)".", (String)"/", (boolean)false, (int)4, null) + '/' + it.getName() + '/'};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @PathSensitive(value=PathSensitivity.ABSOLUTE)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    public void transform(@NotNull TransformOutputs outputs) {
        boolean bl;
        File inputFile;
        block15: {
            String it;
            Intrinsics.checkNotNullParameter((Object)outputs, (String)"outputs");
            inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile();
            if (!inputFile.exists()) {
                throw new UncheckedIOException(new FileNotFoundException(inputFile.getAbsolutePath() + " does not exist. See https://github.com/nebula-plugins/gradle-jakartaee-migration-plugin/issues/7 for potential causes"));
            }
            if (!((Collection)this.getIncludedPaths()).isEmpty()) {
                boolean bl2;
                block14: {
                    Iterable $this$none$iv = this.getIncludedPaths();
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            it = (String)element$iv;
                            boolean bl3 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                            if (!StringsKt.contains$default((CharSequence)FilesKt.getInvariantSeparatorsPath((File)inputFile), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                            bl2 = false;
                            break block14;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    LOGGER.debug("Skipping JakartaEE transform for {}, path is not included", (Object)inputFile);
                    outputs.file((Object)inputFile);
                    return;
                }
            }
            Iterable $this$any$iv = this.getExcludedPaths();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (String)element$iv;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                    if (!StringsKt.contains$default((CharSequence)FilesKt.getInvariantSeparatorsPath((File)inputFile), (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            LOGGER.debug("Skipping JakartaEE transform for {}, path is excluded", (Object)inputFile);
            outputs.file((Object)inputFile);
            return;
        }
        Migration migration = new Migration();
        migration.setSource(inputFile);
        Path tempFilePath = Files.createTempFile("jakartaee", "transform", new FileAttribute[0]);
        migration.setDestination(tempFilePath.toFile());
        migration.setEESpecProfile((EESpecProfile)EESpecProfiles.EE);
        migration.setEnableDefaultExcludes(false);
        migration.setZipInMemory(this.getTransformInMemory());
        migration.execute();
        if (migration.hasConverted()) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
            File outputFile = outputs.file((Object)stringBuilder.append(FilesKt.getNameWithoutExtension((File)inputFile)).append("-jakartaee.jar").toString());
            Files.move(tempFilePath, outputFile.toPath(), new CopyOption[0]);
            try {
                Set<PosixFilePermission> perms = Files.getPosixFilePermissions(inputFile.toPath(), new LinkOption[0]);
                Files.setPosixFilePermissions(outputFile.toPath(), perms);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            LOGGER.info("Transformed {} to JakartaEE {}", (Object)inputFile.getName(), (Object)outputFile.getName());
        } else {
            LOGGER.info("No JakartaEE transformation required for {}", (Object)inputFile.getName());
            Files.delete(tempFilePath);
            outputs.file((Object)inputFile);
        }
    }

    public static final /* synthetic */ List access$toPaths(JakartaEeMigrationTransform $this, List $receiver) {
        return $this.toPaths($receiver);
    }

    static {
        java.util.logging.Logger logger = java.util.logging.Logger.getLogger(Migration.class.getCanonicalName());
        logger.setUseParentHandlers(false);
        Handler[] handlerArray = logger.getHandlers();
        Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"logger.handlers");
        for (Handler handler : handlerArray) {
            logger.removeHandler(handler);
        }
        Logger logger2 = LOGGER;
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"LOGGER");
        logger.addHandler(new TransformHandler(logger2));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H'J\b\u0010\u0006\u001a\u00020\u0007H'J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0016\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H&\u00a8\u0006\u000f"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Parameters;", "Lorg/gradle/api/artifacts/transform/TransformParameters;", "getExcludedArtifacts", "", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "getIncludedArtifacts", "getTransformInMemory", "Ljava/util/concurrent/atomic/AtomicBoolean;", "setExcludedArtifacts", "", "excludedArtifact", "setIncludedArtifacts", "includedArtifact", "setTransformInMemory", "transformInMemory", "gradle-jakartaee-migration-plugin"})
    public static interface Parameters
    extends TransformParameters {
        @Input
        @NotNull
        public List<ArtifactCoordinate> getExcludedArtifacts();

        public void setExcludedArtifacts(@NotNull List<ArtifactCoordinate> var1);

        @Input
        @NotNull
        public List<ArtifactCoordinate> getIncludedArtifacts();

        public void setIncludedArtifacts(@NotNull List<ArtifactCoordinate> var1);

        @Input
        @NotNull
        public AtomicBoolean getTransformInMemory();

        public void setTransformInMemory(@NotNull AtomicBoolean var1);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$Companion;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/netflix/gradle/jakartaee/JakartaEeMigrationTransform$TransformHandler;", "Ljava/util/logging/Handler;", "logger", "Lorg/slf4j/Logger;", "(Lorg/slf4j/Logger;)V", "getLogger", "()Lorg/slf4j/Logger;", "close", "", "flush", "publish", "record", "Ljava/util/logging/LogRecord;", "gradle-jakartaee-migration-plugin"})
    private static final class TransformHandler
    extends Handler {
        @NotNull
        private final Logger logger;

        public TransformHandler(@NotNull Logger logger) {
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            this.logger = logger;
        }

        @NotNull
        public final Logger getLogger() {
            return this.logger;
        }

        @Override
        public void publish(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            if (record.getLevel().intValue() < Level.INFO.intValue()) {
                this.logger.debug(record.getMessage());
            } else {
                this.logger.info(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

