/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.artifacts;

import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "Ljava/io/Serializable;", "group", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getGroup", "()Ljava/lang/String;", "getName", "notation", "getNotation", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "withVersion", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "version", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "gradle-jakartaee-migration-plugin"})
public final class ArtifactCoordinate
implements Serializable {
    @NotNull
    private final String group;
    @NotNull
    private final String name;
    @NotNull
    private final String notation;

    public ArtifactCoordinate(@NotNull String group, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.group = group;
        this.name = name;
        this.notation = this.group + ':' + this.name;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getNotation() {
        return this.notation;
    }

    @NotNull
    public String toString() {
        return this.notation;
    }

    @NotNull
    public final ArtifactVersionCoordinate withVersion(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ArtifactVersionCoordinate(this, new ArtifactVersion(version));
    }

    @NotNull
    public final ArtifactVersionCoordinate withVersion(@NotNull ArtifactVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ArtifactVersionCoordinate(this, version);
    }

    @NotNull
    public final String component1() {
        return this.group;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final ArtifactCoordinate copy(@NotNull String group, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new ArtifactCoordinate(group, name);
    }

    public static /* synthetic */ ArtifactCoordinate copy$default(ArtifactCoordinate artifactCoordinate, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifactCoordinate.group;
        }
        if ((n & 2) != 0) {
            string2 = artifactCoordinate.name;
        }
        return artifactCoordinate.copy(string, string2);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = result * 31 + this.name.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactCoordinate)) {
            return false;
        }
        ArtifactCoordinate artifactCoordinate = (ArtifactCoordinate)other;
        if (!Intrinsics.areEqual((Object)this.group, (Object)artifactCoordinate.group)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.name, (Object)artifactCoordinate.name);
    }
}

