/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.artifacts;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\b\u0010\u0018\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "Ljava/io/Serializable;", "module", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "version", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "(Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;)V", "getModule", "()Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "notation", "", "getNotation", "()Ljava/lang/String;", "getVersion", "()Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "gradle-jakartaee-migration-plugin"})
public final class ArtifactVersionCoordinate
implements Serializable {
    @NotNull
    private final ArtifactCoordinate module;
    @NotNull
    private final ArtifactVersion version;
    @NotNull
    private final String notation;

    public ArtifactVersionCoordinate(@NotNull ArtifactCoordinate module, @NotNull ArtifactVersion version) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.module = module;
        this.version = version;
        this.notation = this.module.getGroup() + ':' + this.module.getName() + ':' + this.version;
    }

    @NotNull
    public final ArtifactCoordinate getModule() {
        return this.module;
    }

    @NotNull
    public final ArtifactVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final String getNotation() {
        return this.notation;
    }

    @NotNull
    public String toString() {
        return this.notation;
    }

    @NotNull
    public final ArtifactCoordinate component1() {
        return this.module;
    }

    @NotNull
    public final ArtifactVersion component2() {
        return this.version;
    }

    @NotNull
    public final ArtifactVersionCoordinate copy(@NotNull ArtifactCoordinate module, @NotNull ArtifactVersion version) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return new ArtifactVersionCoordinate(module, version);
    }

    public static /* synthetic */ ArtifactVersionCoordinate copy$default(ArtifactVersionCoordinate artifactVersionCoordinate, ArtifactCoordinate artifactCoordinate, ArtifactVersion artifactVersion, int n, Object object) {
        if ((n & 1) != 0) {
            artifactCoordinate = artifactVersionCoordinate.module;
        }
        if ((n & 2) != 0) {
            artifactVersion = artifactVersionCoordinate.version;
        }
        return artifactVersionCoordinate.copy(artifactCoordinate, artifactVersion);
    }

    public int hashCode() {
        int result = this.module.hashCode();
        result = result * 31 + this.version.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactVersionCoordinate)) {
            return false;
        }
        ArtifactVersionCoordinate artifactVersionCoordinate = (ArtifactVersionCoordinate)other;
        if (!Intrinsics.areEqual((Object)this.module, (Object)artifactVersionCoordinate.module)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.version, (Object)artifactVersionCoordinate.version);
    }
}

