/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.specifications.Specification;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.artifacts.ComponentMetadataContext;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\b \u0018\u00002\u00020\u0001B3\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bBM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\tJ\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0019H\u0016R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/BasicSpecification;", "Lcom/netflix/gradle/jakartaee/specifications/Specification;", "name", "", "javaxCoordinate", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "jakartaCoordinate", "specificationToImplementationVersion", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "(Ljava/lang/String;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/Map;)V", "javaxCoordinates", "", "jakartaCoordinates", "(Ljava/lang/String;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/List;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/List;Ljava/util/Map;)V", "coordinates", "getCoordinates", "()Ljava/util/List;", "implementationToSpecificationVersion", "getJakartaCoordinates", "getJavaxCoordinates", "getName", "()Ljava/lang/String;", "implementationForSpecification", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "specificationVersion", "implementationVersionFor", "artifactVersion", "gradle-jakartaee-migration-plugin"})
@SourceDebugExtension(value={"SMAP\nBasicSpecification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BasicSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/BasicSpecification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1208#2,2:71\n1238#2,4:73\n*S KotlinDebug\n*F\n+ 1 BasicSpecification.kt\ncom/netflix/gradle/jakartaee/specifications/BasicSpecification\n*L\n49#1:71,2\n49#1:73,4\n*E\n"})
public abstract class BasicSpecification
implements Specification {
    @NotNull
    private final String name;
    @NotNull
    private final ArtifactCoordinate javaxCoordinate;
    @NotNull
    private final List<ArtifactCoordinate> javaxCoordinates;
    @NotNull
    private final ArtifactCoordinate jakartaCoordinate;
    @NotNull
    private final List<ArtifactCoordinate> jakartaCoordinates;
    @NotNull
    private final Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion;
    @NotNull
    private final Map<ArtifactVersion, SpecificationVersion> implementationToSpecificationVersion;

    /*
     * WARNING - void declaration
     */
    public BasicSpecification(@NotNull String name, @NotNull ArtifactCoordinate javaxCoordinate, @NotNull List<ArtifactCoordinate> javaxCoordinates, @NotNull ArtifactCoordinate jakartaCoordinate, @NotNull List<ArtifactCoordinate> jakartaCoordinates, @NotNull Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)javaxCoordinate, (String)"javaxCoordinate");
        Intrinsics.checkNotNullParameter(javaxCoordinates, (String)"javaxCoordinates");
        Intrinsics.checkNotNullParameter((Object)jakartaCoordinate, (String)"jakartaCoordinate");
        Intrinsics.checkNotNullParameter(jakartaCoordinates, (String)"jakartaCoordinates");
        Intrinsics.checkNotNullParameter(specificationToImplementationVersion, (String)"specificationToImplementationVersion");
        this.name = name;
        this.javaxCoordinate = javaxCoordinate;
        this.javaxCoordinates = javaxCoordinates;
        this.jakartaCoordinate = jakartaCoordinate;
        this.jakartaCoordinates = jakartaCoordinates;
        this.specificationToImplementationVersion = specificationToImplementationVersion;
        Iterable iterable = this.specificationToImplementationVersion.entrySet();
        BasicSpecification basicSpecification = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var10_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            ArtifactVersion artifactVersion = (ArtifactVersion)it.getValue();
            boolean bl2 = false;
            SpecificationVersion specificationVersion = (SpecificationVersion)((Object)it.getKey());
            map.put(artifactVersion, specificationVersion);
        }
        basicSpecification.implementationToSpecificationVersion = destination$iv$iv;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public final List<ArtifactCoordinate> getJavaxCoordinates() {
        return this.javaxCoordinates;
    }

    @Override
    @NotNull
    public final List<ArtifactCoordinate> getJakartaCoordinates() {
        return this.jakartaCoordinates;
    }

    public BasicSpecification(@NotNull String name, @NotNull ArtifactCoordinate javaxCoordinate, @NotNull ArtifactCoordinate jakartaCoordinate, @NotNull Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)javaxCoordinate, (String)"javaxCoordinate");
        Intrinsics.checkNotNullParameter((Object)jakartaCoordinate, (String)"jakartaCoordinate");
        Intrinsics.checkNotNullParameter(specificationToImplementationVersion, (String)"specificationToImplementationVersion");
        this(name, javaxCoordinate, CollectionsKt.listOf((Object)javaxCoordinate), jakartaCoordinate, CollectionsKt.listOf((Object)jakartaCoordinate), specificationToImplementationVersion);
    }

    @Override
    @NotNull
    public final ArtifactVersionCoordinate implementationForSpecification(@NotNull SpecificationVersion specificationVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)specificationVersion), (String)"specificationVersion");
        ArtifactCoordinate defaultImplementation = specificationVersion.compareTo((Enum)SpecificationVersion.EE8) <= 0 ? this.javaxCoordinate : this.jakartaCoordinate;
        ArtifactVersion artifactVersion = this.specificationToImplementationVersion.get((Object)specificationVersion);
        Intrinsics.checkNotNull((Object)artifactVersion);
        String version = artifactVersion.toString();
        return defaultImplementation.withVersion(version);
    }

    @Override
    @NotNull
    public ArtifactVersion implementationVersionFor(@NotNull ArtifactVersionCoordinate artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        if (Intrinsics.areEqual((Object)artifactVersion.getModule().getGroup(), (Object)"org.glassfish")) {
            ArtifactVersion artifactVersion2 = this.specificationToImplementationVersion.get((Object)SpecificationVersion.EE7);
            Intrinsics.checkNotNull((Object)artifactVersion2);
            return artifactVersion2;
        }
        return artifactVersion.getVersion();
    }

    @Override
    @NotNull
    public final List<ArtifactCoordinate> getCoordinates() {
        return CollectionsKt.plus((Collection)this.javaxCoordinates, (Iterable)this.jakartaCoordinates);
    }

    @Override
    public void configureCapabilities(@NotNull DependencyHandler dependencies) {
        Specification.DefaultImpls.configureCapabilities(this, dependencies);
    }

    @Override
    public void execute(@NotNull ComponentMetadataContext context) {
        Specification.DefaultImpls.execute(this, context);
    }

    @Override
    public void configureCapabilitiesResolution(@NotNull Configuration configuration) {
        Specification.DefaultImpls.configureCapabilitiesResolution(this, configuration);
    }

    @Override
    public void substitute(@NotNull Configuration configuration) {
        Specification.DefaultImpls.substitute(this, configuration);
    }
}

