/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.gradle.jakartaee.specifications.api;

import com.netflix.gradle.jakartaee.artifacts.ArtifactCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ArtifactType;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersion;
import com.netflix.gradle.jakartaee.artifacts.ArtifactVersionCoordinate;
import com.netflix.gradle.jakartaee.artifacts.ExtensionsKt;
import com.netflix.gradle.jakartaee.specifications.SpecificationVersion;
import com.netflix.gradle.jakartaee.specifications.api.Api;
import com.netflix.gradle.jakartaee.specifications.api.BasicApi;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016BM\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/api/ContainerProvidedApi;", "Lcom/netflix/gradle/jakartaee/specifications/api/BasicApi;", "Lcom/netflix/gradle/jakartaee/specifications/api/Api;", "name", "", "javaxCoordinate", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "javaxCoordinates", "", "jakartaCoordinate", "jakartaCoordinates", "specificationToImplementationVersion", "", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "(Ljava/lang/String;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/List;Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;Ljava/util/List;Ljava/util/Map;)V", "artifactType", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactType;", "artifactCoordinate", "implementationVersionFor", "artifactVersion", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersionCoordinate;", "Companion", "gradle-jakartaee-migration-plugin"})
public abstract class ContainerProvidedApi
extends BasicApi
implements Api {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion;
    @NotNull
    private static final Map<ArtifactVersion, SpecificationVersion> TOMCAT_TO_EE_VERSION;
    @NotNull
    private static final ArtifactCoordinate TOMCAT_EMBED;

    public ContainerProvidedApi(@NotNull String name, @NotNull ArtifactCoordinate javaxCoordinate, @NotNull List<ArtifactCoordinate> javaxCoordinates, @NotNull ArtifactCoordinate jakartaCoordinate, @NotNull List<ArtifactCoordinate> jakartaCoordinates, @NotNull Map<SpecificationVersion, ArtifactVersion> specificationToImplementationVersion) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)javaxCoordinate, (String)"javaxCoordinate");
        Intrinsics.checkNotNullParameter(javaxCoordinates, (String)"javaxCoordinates");
        Intrinsics.checkNotNullParameter((Object)jakartaCoordinate, (String)"jakartaCoordinate");
        Intrinsics.checkNotNullParameter(jakartaCoordinates, (String)"jakartaCoordinates");
        Intrinsics.checkNotNullParameter(specificationToImplementationVersion, (String)"specificationToImplementationVersion");
        super(name, javaxCoordinate, javaxCoordinates, jakartaCoordinate, jakartaCoordinates, specificationToImplementationVersion);
        this.specificationToImplementationVersion = specificationToImplementationVersion;
    }

    @Override
    @NotNull
    public ArtifactVersion implementationVersionFor(@NotNull ArtifactVersionCoordinate artifactVersion) {
        Intrinsics.checkNotNullParameter((Object)artifactVersion, (String)"artifactVersion");
        ArtifactVersion implementationVersion = super.implementationVersionFor(artifactVersion);
        String group = artifactVersion.getModule().getGroup();
        if (StringsKt.startsWith$default((String)group, (String)"tomcat", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)group, (String)"org.apache.tomcat", (boolean)false, (int)2, null)) {
            SpecificationVersion specificationVersion = TOMCAT_TO_EE_VERSION.get(ExtensionsKt.getMinorVersion(implementationVersion));
            if (specificationVersion == null) {
                specificationVersion = SpecificationVersion.EE7;
            }
            SpecificationVersion specificationVersion2 = specificationVersion;
            ArtifactVersion artifactVersion2 = this.specificationToImplementationVersion.get((Object)specificationVersion2);
            Intrinsics.checkNotNull((Object)artifactVersion2);
            implementationVersion = artifactVersion2;
        }
        return implementationVersion;
    }

    @Override
    @NotNull
    public ArtifactType artifactType(@NotNull ArtifactCoordinate artifactCoordinate) {
        Intrinsics.checkNotNullParameter((Object)artifactCoordinate, (String)"artifactCoordinate");
        return Intrinsics.areEqual((Object)artifactCoordinate.getGroup(), (Object)"org.apache.tomcat.embed") ? ArtifactType.EMBED : Api.DefaultImpls.artifactType(this, artifactCoordinate);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)new ArtifactVersion("8.0"), (Object)((Object)SpecificationVersion.EE7)), TuplesKt.to((Object)new ArtifactVersion("8.5"), (Object)((Object)SpecificationVersion.EE7)), TuplesKt.to((Object)new ArtifactVersion("9.0"), (Object)((Object)SpecificationVersion.EE8)), TuplesKt.to((Object)new ArtifactVersion("10.0"), (Object)((Object)SpecificationVersion.EE9)), TuplesKt.to((Object)new ArtifactVersion("10.1"), (Object)((Object)SpecificationVersion.EE10))};
        TOMCAT_TO_EE_VERSION = MapsKt.mapOf((Pair[])pairArray);
        TOMCAT_EMBED = new ArtifactCoordinate("org.apache.tomcat.embed", "tomcat-embed-core");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/netflix/gradle/jakartaee/specifications/api/ContainerProvidedApi$Companion;", "", "()V", "TOMCAT_EMBED", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "getTOMCAT_EMBED$gradle_jakartaee_migration_plugin", "()Lcom/netflix/gradle/jakartaee/artifacts/ArtifactCoordinate;", "TOMCAT_TO_EE_VERSION", "", "Lcom/netflix/gradle/jakartaee/artifacts/ArtifactVersion;", "Lcom/netflix/gradle/jakartaee/specifications/SpecificationVersion;", "getTOMCAT_TO_EE_VERSION$gradle_jakartaee_migration_plugin", "()Ljava/util/Map;", "gradle-jakartaee-migration-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ArtifactVersion, SpecificationVersion> getTOMCAT_TO_EE_VERSION$gradle_jakartaee_migration_plugin() {
            return TOMCAT_TO_EE_VERSION;
        }

        @NotNull
        public final ArtifactCoordinate getTOMCAT_EMBED$gradle_jakartaee_migration_plugin() {
            return TOMCAT_EMBED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

