/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.compile.provider;

import com.netflix.nebula.interop.GradleKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nebula.plugin.compile.provider.JDKPathProvider;
import org.gradle.api.JavaVersion;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnebula/plugin/compile/provider/EnvironmentJDKPathProvider;", "Lnebula/plugin/compile/provider/JDKPathProvider;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/provider/ProviderFactory;Lorg/gradle/api/Project;)V", "provide", "", "javaVersion", "Lorg/gradle/api/JavaVersion;", "gradle-java-cross-compile-plugin"})
public final class EnvironmentJDKPathProvider
implements JDKPathProvider {
    private final ProviderFactory providerFactory;
    private final Project project;

    @Override
    @Nullable
    public String provide(@NotNull JavaVersion javaVersion) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)javaVersion, (String)"javaVersion");
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        if (GradleKt.versionLessThan((Gradle)gradle, (String)"6.5")) {
            Provider jdkEnvVariable;
            Provider provider = jdkEnvVariable = this.providerFactory.environmentVariable("JDK_1" + javaVersion.getMajorVersion()).forUseAtConfigurationTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)provider, (String)"jdkEnvVariable");
            string = provider.isPresent() ? (String)jdkEnvVariable.get() : null;
        } else {
            string = System.getenv("JDK_1" + javaVersion.getMajorVersion());
        }
        return string;
    }

    public EnvironmentJDKPathProvider(@NotNull ProviderFactory providerFactory, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.providerFactory = providerFactory;
        this.project = project;
    }
}

