/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.compile;

import com.netflix.nebula.interop.GradleKt;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nebula.plugin.compile.JavaCrossCompileExtension;
import nebula.plugin.compile.provider.DefaultLocationJDKPathProvider;
import nebula.plugin.compile.provider.EnvironmentJDKPathProvider;
import nebula.plugin.compile.provider.JDKPathProvider;
import nebula.plugin.compile.provider.SDKManJDKPathProvider;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.gradle.jvm.toolchain.internal.DefaultToolchainSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J&\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011*\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\u0014*\u00020\u00122\u0006\u0010\b\u001a\u00020\u00022\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017\u00b2\u0006\n\u0010\u0018\u001a\u00020\u0014X\u008a\u0084\u0002"}, d2={"Lnebula/plugin/compile/JavaCrossCompilePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "configureBootstrapClasspath", "providers", "", "Lnebula/plugin/compile/provider/JDKPathProvider;", "extension", "Lnebula/plugin/compile/JavaCrossCompileExtension;", "cannotLocate", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lorg/gradle/api/JavaVersion;", "locate", "Lnebula/plugin/compile/JavaCrossCompilePlugin$JavaLocation;", "Companion", "JavaLocation", "gradle-java-cross-compile-plugin", "location"})
@SourceDebugExtension(value={"SMAP\nJavaCrossCompilePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaCrossCompilePlugin.kt\nnebula/plugin/compile/JavaCrossCompilePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n*S KotlinDebug\n*F\n+ 1 JavaCrossCompilePlugin.kt\nnebula/plugin/compile/JavaCrossCompilePlugin\n*L\n106#1:119\n106#1:120,3\n*E\n"})
public final class JavaCrossCompilePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providerFactory;
    @NotNull
    public static final String RT_JAR_PATH = "jre/lib/rt.jar";
    @NotNull
    public static final String CLASSES_JAR_PATH = "../Classes/classes.jar";
    @NotNull
    private static final List<String> ADDITIONAL_JARS;
    @NotNull
    private static final Logger logger;

    @Inject
    public JavaCrossCompilePlugin(@NotNull ProviderFactory providerFactory) {
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        this.providerFactory = providerFactory;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object[] objectArray = new JDKPathProvider[]{new EnvironmentJDKPathProvider(this.providerFactory, project), new DefaultLocationJDKPathProvider(), new SDKManJDKPathProvider(this.providerFactory, project)};
        List providers = CollectionsKt.listOf((Object[])objectArray);
        JavaCrossCompileExtension extension = (JavaCrossCompileExtension)project.getExtensions().create("javaCrossCompile", JavaCrossCompileExtension.class, new Object[0]);
        project.getPlugins().apply(JavaBasePlugin.class);
        project.afterEvaluate(arg_0 -> JavaCrossCompilePlugin.apply$lambda$0((Function1)new Function1<Project, Unit>(this, project, (List<? extends JDKPathProvider>)providers, extension){
            final /* synthetic */ JavaCrossCompilePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ List<JDKPathProvider> $providers;
            final /* synthetic */ JavaCrossCompileExtension $extension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$providers = $providers;
                this.$extension = $extension;
                super(1);
            }

            public final void invoke(Project it) {
                JavaCrossCompileExtension javaCrossCompileExtension = this.$extension;
                Intrinsics.checkNotNullExpressionValue((Object)javaCrossCompileExtension, (String)"extension");
                JavaCrossCompilePlugin.access$configureBootstrapClasspath(this.this$0, this.$project, this.$providers, javaCrossCompileExtension);
            }
        }, arg_0));
    }

    private final void configureBootstrapClasspath(Project project, List<? extends JDKPathProvider> providers, JavaCrossCompileExtension extension) {
        if (!extension.getEnabled()) {
            return;
        }
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().findByType(JavaPluginExtension.class);
        if (javaPluginExtension == null) {
            return;
        }
        JavaToolchainSpec toolchain = javaPluginExtension.getToolchain();
        Intrinsics.checkNotNull((Object)toolchain, (String)"null cannot be cast to non-null type org.gradle.jvm.toolchain.internal.DefaultToolchainSpec");
        if (((DefaultToolchainSpec)toolchain).isConfigured()) {
            project.getLogger().debug("Toolchain is configured for this project, skipping java-cross-compile plugin configuration");
            return;
        }
        JavaVersion targetCompatibility = javaPluginExtension.getTargetCompatibility();
        if (targetCompatibility.compareTo((Enum)JavaVersion.current()) < 0) {
            TaskContainer $this$configureBootstrapClasspath_u24lambda_u243 = project.getTasks();
            boolean bl = false;
            Lazy location$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavaLocation>(this, targetCompatibility, project, providers){
                final /* synthetic */ JavaCrossCompilePlugin this$0;
                final /* synthetic */ JavaVersion $targetCompatibility;
                final /* synthetic */ Project $project;
                final /* synthetic */ List<JDKPathProvider> $providers;
                {
                    this.this$0 = $receiver;
                    this.$targetCompatibility = $targetCompatibility;
                    this.$project = $project;
                    this.$providers = $providers;
                    super(0);
                }

                @NotNull
                public final JavaLocation invoke() {
                    JavaVersion javaVersion = this.$targetCompatibility;
                    Intrinsics.checkNotNullExpressionValue((Object)javaVersion, (String)"targetCompatibility");
                    return JavaCrossCompilePlugin.access$locate(this.this$0, javaVersion, this.$project, this.$providers);
                }
            }));
            $this$configureBootstrapClasspath_u24lambda_u243.withType(JavaCompile.class, arg_0 -> JavaCrossCompilePlugin.configureBootstrapClasspath$lambda$3$lambda$2((Function1)new Function1<JavaCompile, Unit>(project, targetCompatibility, (Lazy<JavaLocation>)location$delegate){
                final /* synthetic */ Project $project;
                final /* synthetic */ JavaVersion $targetCompatibility;
                final /* synthetic */ Lazy<JavaLocation> $location$delegate;
                {
                    this.$project = $project;
                    this.$targetCompatibility = $targetCompatibility;
                    this.$location$delegate = $location$delegate;
                    super(1);
                }

                public final void invoke(JavaCompile it) {
                    if (JavaVersion.current().compareTo((Enum)JavaVersion.VERSION_1_9) >= 0) {
                        Gradle gradle = this.$project.getGradle();
                        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                        if (GradleKt.versionLessThan((Gradle)gradle, (String)"6.6-rc-1")) {
                            Object[] objectArray = new String[]{"--release", this.$targetCompatibility.getMajorVersion()};
                            it.getOptions().getCompilerArgs().addAll(CollectionsKt.listOf((Object[])objectArray));
                        } else {
                            Property property = it.getOptions().getRelease();
                            String string = this.$targetCompatibility.getMajorVersion();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetCompatibility.majorVersion");
                            property.set((Object)Integer.parseInt(string));
                        }
                    } else {
                        Gradle gradle = this.$project.getGradle();
                        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
                        if (GradleKt.versionGreaterThan((Gradle)gradle, (String)"4.2.1")) {
                            it.getOptions().setBootstrapClasspath(JavaCrossCompilePlugin.access$configureBootstrapClasspath$lambda$3$lambda$1(this.$location$delegate).getBootstrapClasspath());
                        } else {
                            Object[] objectArray = new Class[]{String.class};
                            Method method = it.getOptions().getClass().getDeclaredMethod("setBootClasspath", (Class<?>[])objectArray);
                            objectArray = new Object[]{JavaCrossCompilePlugin.access$configureBootstrapClasspath$lambda$3$lambda$1(this.$location$delegate).getBootClasspath()};
                            method.invoke((Object)it.getOptions(), objectArray);
                        }
                    }
                }
            }, arg_0));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JavaLocation locate(JavaVersion $this$locate, Project project, List<? extends JDKPathProvider> providers) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File file;
        Object jdkHome;
        block10: {
            Object object;
            block9: {
                logger.debug("Locating JDK for " + $this$locate);
                for (Object it : (Iterable)providers) {
                    String string;
                    boolean bl = false;
                    String jdkHome2 = it.provide($this$locate);
                    if (jdkHome2 == null) {
                        logger.debug("Provider " + it + " did not find a JDK");
                        string = null;
                    } else {
                        logger.debug("Provider " + it + " found a JDK at " + jdkHome2);
                        string = jdkHome2;
                    }
                    if ((it = string) == null) continue;
                    object = it;
                    break block9;
                }
                object = null;
            }
            if (object == null) {
                throw this.cannotLocate($this$locate);
            }
            jdkHome = object;
            logger.debug("Found JDK for " + $this$locate + " at " + jdkHome);
            Object[] objectArray = new File[]{new File((String)jdkHome, RT_JAR_PATH), new File((String)jdkHome, CLASSES_JAR_PATH)};
            List runtimeJars = CollectionsKt.listOf((Object[])objectArray);
            for (File it : (Iterable)runtimeJars) {
                File file2;
                boolean bl2 = false;
                if (it.exists()) {
                    logger.debug("Found runtime classes jar " + it);
                    file2 = it;
                } else {
                    logger.debug("Runtime classes jar " + it + " does not exist");
                    file2 = null;
                }
                if ((it = file2) == null) continue;
                file = it;
                break block10;
            }
            file = null;
        }
        if (file == null) {
            throw this.cannotLocate($this$locate);
        }
        File runtimeJar = file;
        File libDir = runtimeJar.getParentFile();
        Iterable bl = ADDITIONAL_JARS;
        Collection collection = CollectionsKt.listOf((Object)runtimeJar);
        boolean $i$f$map = false;
        void bl2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl3 = false;
            collection2.add(new File(libDir, (String)it + ".jar"));
        }
        List jarFiles = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        Iterable iterable = jarFiles;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
        String classpath = CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        Object[] objectArray = new Object[]{classpath};
        ConfigurableFileCollection configurableFileCollection = project.files(objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files(classpath)");
        return new JavaLocation((String)jdkHome, (FileCollection)configurableFileCollection);
    }

    private final IllegalStateException cannotLocate(JavaVersion $this$cannotLocate) {
        return new IllegalStateException("Could not locate a compatible JDK for target compatibility " + $this$cannotLocate + ". Change the source/target compatibility, set a JDK_1" + $this$cannotLocate.getMajorVersion() + " environment variable with the location, or install to one of the default search locations");
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final JavaLocation configureBootstrapClasspath$lambda$3$lambda$1(Lazy<JavaLocation> $location$delegate) {
        Lazy<JavaLocation> lazy = $location$delegate;
        return (JavaLocation)lazy.getValue();
    }

    private static final void configureBootstrapClasspath$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$configureBootstrapClasspath(JavaCrossCompilePlugin $this, Project project, List providers, JavaCrossCompileExtension extension) {
        $this.configureBootstrapClasspath(project, providers, extension);
    }

    public static final /* synthetic */ JavaLocation access$locate(JavaCrossCompilePlugin $this, JavaVersion $receiver, Project project, List providers) {
        return $this.locate($receiver, project, providers);
    }

    public static final /* synthetic */ JavaLocation access$configureBootstrapClasspath$lambda$3$lambda$1(Lazy $location$delegate) {
        return JavaCrossCompilePlugin.configureBootstrapClasspath$lambda$3$lambda$1((Lazy<JavaLocation>)$location$delegate);
    }

    static {
        Object[] objectArray = new String[]{"jsse", "jce", "charsets"};
        ADDITIONAL_JARS = CollectionsKt.listOf((Object[])objectArray);
        Logger logger = LoggerFactory.getLogger(JavaCrossCompilePlugin.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(JavaCrossCompilePlugin::class.java)");
        JavaCrossCompilePlugin.logger = logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0016"}, d2={"Lnebula/plugin/compile/JavaCrossCompilePlugin$JavaLocation;", "", "jdkHome", "", "bootstrapClasspath", "Lorg/gradle/api/file/FileCollection;", "(Ljava/lang/String;Lorg/gradle/api/file/FileCollection;)V", "bootClasspath", "getBootClasspath", "()Ljava/lang/String;", "getBootstrapClasspath", "()Lorg/gradle/api/file/FileCollection;", "getJdkHome", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-java-cross-compile-plugin"})
    public static final class JavaLocation {
        @NotNull
        private final String jdkHome;
        @NotNull
        private final FileCollection bootstrapClasspath;

        public JavaLocation(@NotNull String jdkHome, @NotNull FileCollection bootstrapClasspath) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            Intrinsics.checkNotNullParameter((Object)bootstrapClasspath, (String)"bootstrapClasspath");
            this.jdkHome = jdkHome;
            this.bootstrapClasspath = bootstrapClasspath;
        }

        @NotNull
        public final String getJdkHome() {
            return this.jdkHome;
        }

        @NotNull
        public final FileCollection getBootstrapClasspath() {
            return this.bootstrapClasspath;
        }

        @NotNull
        public final String getBootClasspath() {
            Iterable iterable = (Iterable)this.bootstrapClasspath;
            String string = File.pathSeparator;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pathSeparator");
            return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final String component1() {
            return this.jdkHome;
        }

        @NotNull
        public final FileCollection component2() {
            return this.bootstrapClasspath;
        }

        @NotNull
        public final JavaLocation copy(@NotNull String jdkHome, @NotNull FileCollection bootstrapClasspath) {
            Intrinsics.checkNotNullParameter((Object)jdkHome, (String)"jdkHome");
            Intrinsics.checkNotNullParameter((Object)bootstrapClasspath, (String)"bootstrapClasspath");
            return new JavaLocation(jdkHome, bootstrapClasspath);
        }

        public static /* synthetic */ JavaLocation copy$default(JavaLocation javaLocation, String string, FileCollection fileCollection, int n, Object object) {
            if ((n & 1) != 0) {
                string = javaLocation.jdkHome;
            }
            if ((n & 2) != 0) {
                fileCollection = javaLocation.bootstrapClasspath;
            }
            return javaLocation.copy(string, fileCollection);
        }

        @NotNull
        public String toString() {
            return "JavaLocation(jdkHome=" + this.jdkHome + ", bootstrapClasspath=" + this.bootstrapClasspath + ')';
        }

        public int hashCode() {
            int result = this.jdkHome.hashCode();
            result = result * 31 + this.bootstrapClasspath.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaLocation)) {
                return false;
            }
            JavaLocation javaLocation = (JavaLocation)other;
            if (!Intrinsics.areEqual((Object)this.jdkHome, (Object)javaLocation.jdkHome)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.bootstrapClasspath, (Object)javaLocation.bootstrapClasspath);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnebula/plugin/compile/JavaCrossCompilePlugin$Companion;", "", "()V", "ADDITIONAL_JARS", "", "", "getADDITIONAL_JARS", "()Ljava/util/List;", "CLASSES_JAR_PATH", "RT_JAR_PATH", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "gradle-java-cross-compile-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getADDITIONAL_JARS() {
            return ADDITIONAL_JARS;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

