/*
 * Decompiled with CFR 0.152.
 */
package nebula.plugin.compile.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nebula.plugin.compile.provider.JDKPathProvider;
import org.gradle.api.JavaVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lnebula/plugin/compile/provider/DefaultLocationJDKPathProvider;", "Lnebula/plugin/compile/provider/JDKPathProvider;", "()V", "provide", "", "javaVersion", "Lorg/gradle/api/JavaVersion;", "Companion", "gradle-java-cross-compile-plugin"})
@SourceDebugExtension(value={"SMAP\nDefaultLocationJDKPathProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultLocationJDKPathProvider.kt\nnebula/plugin/compile/provider/DefaultLocationJDKPathProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1360#2:96\n1446#2,5:97\n1855#2:102\n288#2,2:103\n1856#2:105\n1855#2:106\n288#2,2:107\n288#2,2:109\n1855#2:111\n288#2,2:112\n1856#2:114\n1856#2:115\n288#2:116\n1747#2,3:117\n289#2:120\n*S KotlinDebug\n*F\n+ 1 DefaultLocationJDKPathProvider.kt\nnebula/plugin/compile/provider/DefaultLocationJDKPathProvider\n*L\n24#1:96\n24#1:97,5\n33#1:102\n34#1:103,2\n33#1:105\n44#1:106\n45#1:107,2\n50#1:109,2\n55#1:111\n56#1:112,2\n55#1:114\n44#1:115\n67#1:116\n77#1:117,3\n67#1:120\n*E\n"})
public final class DefaultLocationJDKPathProvider
implements JDKPathProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;
    @NotNull
    private static List<? extends File> basePaths;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String provide(@NotNull JavaVersion javaVersion) {
        File macOsJdkHome;
        Object v10;
        List candidates;
        block24: {
            Object element$iv3;
            File jdkHome;
            Object $this$firstOrNull$iv;
            Iterator $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)javaVersion, (String)"javaVersion");
            Object[] $this$flatMap$iv = (Object[])basePaths;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                block26: {
                    block25: {
                        Object[] objectArray2;
                        Object element$iv$iv = iterator.next();
                        File it2 = (File)element$iv$iv;
                        boolean bl2 = false;
                        object = objectArray2 = it2.listFiles(DefaultLocationJDKPathProvider::provide$lambda$1$lambda$0);
                        if (objectArray2 == null) break block25;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"listFiles(FileFilter { it.isDirectory })");
                        object = ArraysKt.toList((Object[])objectArray2);
                        if (object != null) break block26;
                    }
                    object = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = (Iterable)object;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            candidates = CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
            if (candidates.isEmpty()) {
                logger.debug("No candidates were found in search locations " + basePaths);
                return null;
            }
            $this$flatMap$iv = new String[]{"oracle", "openjdk"};
            Object $this$forEach$iv = (Object[])CollectionsKt.listOf((Object[])$this$flatMap$iv);
            boolean $i$f$forEach = false;
            $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$flatMapTo$iv$iv.hasNext()) {
                Object v2;
                block19: {
                    Object element$iv2 = $this$flatMapTo$iv$iv.next();
                    String variant = (String)element$iv2;
                    boolean bl = false;
                    $this$firstOrNull$iv = (Object[])candidates;
                    boolean $i$f$firstOrNull = false;
                    Iterator bl2 = $this$firstOrNull$iv.iterator();
                    while (bl2.hasNext()) {
                        Object element$iv4 = bl2.next();
                        File file = (File)element$iv4;
                        boolean bl3 = false;
                        logger.debug("Evaluating Ubuntu candidate " + file.getName());
                        String string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (!StringsKt.startsWith$default((String)string, (String)("java-" + javaVersion.getMajorVersion() + '-' + variant), (boolean)false, (int)2, null)) continue;
                        v2 = element$iv4;
                        break block19;
                    }
                    v2 = null;
                }
                if ((jdkHome = (File)v2) == null) continue;
                logger.debug("Found Ubuntu JDK at " + jdkHome);
                return jdkHome.getAbsolutePath();
            }
            $this$forEach$iv = new String[]{"jdk", "jre", "jdk+fx"};
            $this$forEach$iv = CollectionsKt.listOf((Object[])$this$forEach$iv);
            $i$f$forEach = false;
            $this$flatMapTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$flatMapTo$iv$iv.hasNext()) {
                List $i$f$firstOrNull32;
                Object v6;
                Object[] $this$firstOrNull$iv2;
                block21: {
                    List $i$f$firstOrNull222;
                    Object object;
                    block20: {
                        Object element$iv2 = $this$flatMapTo$iv$iv.next();
                        String javaPackage = (String)element$iv2;
                        boolean bl = false;
                        $this$firstOrNull$iv = candidates;
                        boolean $i$f$firstOrNull222 = false;
                        Iterator bl2 = $this$firstOrNull$iv.iterator();
                        while (bl2.hasNext()) {
                            element$iv3 = bl2.next();
                            File file = (File)element$iv3;
                            boolean bl4 = false;
                            logger.debug("Evaluating Github Actions java-package candidate " + file.getName());
                            String string = file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                            if (!StringsKt.startsWith$default((String)string, (String)javaPackage, (boolean)false, (int)2, null)) continue;
                            object = element$iv3;
                            break block20;
                        }
                        object = null;
                    }
                    jdkHome = (File)object;
                    List candidatesForJavaPackage = jdkHome != null && ($this$firstOrNull$iv = jdkHome.listFiles(DefaultLocationJDKPathProvider::provide$lambda$10$lambda$5)) != null && ($i$f$firstOrNull222 = ArraysKt.toList((Object[])$this$firstOrNull$iv)) != null ? $i$f$firstOrNull222 : CollectionsKt.emptyList();
                    $this$firstOrNull$iv2 = (Object[])candidatesForJavaPackage;
                    boolean $i$f$firstOrNull32 = false;
                    for (Object e : $this$firstOrNull$iv2) {
                        File it3 = (File)e;
                        boolean bl = false;
                        logger.debug("Evaluating Github Actions java-version candidate " + it3.getName());
                        String string = it3.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                        if (!StringsKt.startsWith$default((String)string, (String)(javaVersion.getMajorVersion() + '.'), (boolean)false, (int)2, null)) continue;
                        v6 = e;
                        break block21;
                    }
                    v6 = null;
                }
                $this$firstOrNull$iv = v6;
                List candidatesForJavaVersion = $this$firstOrNull$iv != null && ($this$firstOrNull$iv2 = ((File)$this$firstOrNull$iv).listFiles(DefaultLocationJDKPathProvider::provide$lambda$10$lambda$7)) != null && ($i$f$firstOrNull32 = ArraysKt.toList((Object[])$this$firstOrNull$iv2)) != null ? $i$f$firstOrNull32 : CollectionsKt.emptyList();
                $this$firstOrNull$iv = new String[]{"x64", "x86"};
                Iterable $this$forEach$iv2 = CollectionsKt.listOf((Object[])$this$firstOrNull$iv);
                boolean $i$f$forEach2 = false;
                for (Object element$iv3 : $this$forEach$iv2) {
                    File jdkHomeWithGithubActions;
                    Object v8;
                    block22: {
                        String string = (String)element$iv3;
                        boolean bl = false;
                        Iterable $this$firstOrNull$iv3 = candidatesForJavaVersion;
                        boolean $i$f$firstOrNull4 = false;
                        for (Object element$iv5 : $this$firstOrNull$iv3) {
                            File it4 = (File)element$iv5;
                            boolean bl5 = false;
                            logger.debug("Evaluating Github Actions architecture candidate " + it4.getName());
                            String string2 = it4.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                            if (!StringsKt.startsWith$default((String)string2, (String)string, (boolean)false, (int)2, null)) continue;
                            v8 = element$iv5;
                            break block22;
                        }
                        v8 = null;
                    }
                    if ((jdkHomeWithGithubActions = (File)v8) == null) continue;
                    logger.debug("Found Github Actions JDK at " + jdkHomeWithGithubActions);
                    return jdkHomeWithGithubActions.getAbsolutePath();
                }
            }
            Iterable $this$firstOrNull$iv4 = candidates;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv6 : $this$firstOrNull$iv4) {
                boolean bl;
                block23: {
                    void $this$any$iv;
                    File it5 = (File)element$iv6;
                    boolean bl6 = false;
                    logger.debug("Evaluating macOS/Windows candidate " + it5.getName());
                    String version = "1." + javaVersion.getMajorVersion() + ".0";
                    String name = it5.getName();
                    element$iv3 = new String[]{"jdk" + version, "jdk-" + version, version + ".jdk", "zulu" + version, "zulu-" + javaVersion.getMajorVersion() + ".jdk"};
                    element$iv3 = CollectionsKt.listOf(element$iv3);
                    boolean bl2 = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv7 : $this$any$iv) {
                            String it6 = (String)element$iv7;
                            boolean bl7 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            if (!StringsKt.startsWith$default((String)name, (String)it6, (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block23;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v10 = element$iv6;
                break block24;
            }
            v10 = null;
        }
        File jdkHome = v10;
        if (jdkHome != null && (macOsJdkHome = new File(jdkHome, "Contents/Home")).exists()) {
            logger.debug("Found macOS JDK at " + jdkHome);
            return macOsJdkHome.getAbsolutePath();
        }
        if (jdkHome == null) {
            logger.debug("No JDKs found in candidate locations " + candidates + ' ');
            return null;
        }
        return jdkHome.getAbsolutePath();
    }

    private static final boolean provide$lambda$1$lambda$0(File it) {
        return it.isDirectory();
    }

    private static final boolean provide$lambda$10$lambda$5(File it) {
        return it.isDirectory();
    }

    private static final boolean provide$lambda$10$lambda$7(File it) {
        return it.isDirectory();
    }

    static {
        Logger logger = LoggerFactory.getLogger(DefaultLocationJDKPathProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(DefaultLocatio\u2026PathProvider::class.java)");
        DefaultLocationJDKPathProvider.logger = logger;
        Object[] objectArray = new File[]{new File("/usr/lib/jvm"), new File("/opt/hostedtoolcache"), new File("/Library/Java/JavaVirtualMachines"), new File("C:\\Program Files\\Java")};
        basePaths = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnebula/plugin/compile/provider/DefaultLocationJDKPathProvider$Companion;", "", "()V", "basePaths", "", "Ljava/io/File;", "getBasePaths", "()Ljava/util/List;", "setBasePaths", "(Ljava/util/List;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "gradle-java-cross-compile-plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final List<File> getBasePaths() {
            return basePaths;
        }

        public final void setBasePaths(@NotNull List<? extends File> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            basePaths = list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

