/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.lint;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.codenarc.analyzer.StringSourceAnalyzer;
import org.codenarc.results.Results;
import org.codenarc.ruleregistry.RuleRegistryInitializer;
import org.codenarc.ruleset.CompositeRuleSet;
import org.codenarc.ruleset.PropertiesFileRuleSetConfigurer;
import org.codenarc.ruleset.RuleSet;
import org.codenarc.ruleset.RuleSetUtil;

public class GradleLint {
    public static void main(String[] args) throws IOException {
        new RuleRegistryInitializer().initializeRuleRegistry();
        CompositeRuleSet ruleSet = new CompositeRuleSet();
        ruleSet.addRuleSet(RuleSetUtil.loadRuleSetFile((String)"rulesets/basic.xml"));
        ruleSet.addRuleSet(RuleSetUtil.loadRuleSetFile((String)"rulesets/unnecessary.xml"));
        ruleSet.addRuleSet(RuleSetUtil.loadRuleSetFile((String)"rulesets/gradle.xml"));
        new PropertiesFileRuleSetConfigurer().configure((RuleSet)ruleSet);
        String source = new String(Files.readAllBytes(new File("build.gradle").toPath()));
        StringSourceAnalyzer sourceAnalyzer = new StringSourceAnalyzer(source);
        Results results = sourceAnalyzer.analyze((RuleSet)ruleSet);
        for (Object v : results.getViolations()) {
            System.out.println(v);
        }
    }
}

