/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.api.errors.NoHeadException;
import com.netflix.nebula.jgit.diff.DiffEntry;
import com.netflix.nebula.jgit.diff.DiffFormatter;
import com.netflix.nebula.jgit.dircache.DirCacheIterator;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ObjectReader;
import com.netflix.nebula.jgit.lib.ProgressMonitor;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.treewalk.AbstractTreeIterator;
import com.netflix.nebula.jgit.treewalk.CanonicalTreeParser;
import com.netflix.nebula.jgit.treewalk.FileTreeIterator;
import com.netflix.nebula.jgit.treewalk.filter.TreeFilter;
import com.netflix.nebula.jgit.util.io.NullOutputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;

public class DiffCommand
extends GitCommand<List<DiffEntry>> {
    private AbstractTreeIterator oldTree;
    private AbstractTreeIterator newTree;
    private boolean cached;
    private TreeFilter pathFilter = TreeFilter.ALL;
    private boolean showNameAndStatusOnly;
    private OutputStream out;
    private int contextLines = -1;
    private String sourcePrefix;
    private String destinationPrefix;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;

    protected DiffCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<DiffEntry> call() throws GitAPIException {
        DiffFormatter diffFmt = this.out != null && !this.showNameAndStatusOnly ? new DiffFormatter(new BufferedOutputStream(this.out)) : new DiffFormatter(NullOutputStream.INSTANCE);
        diffFmt.setRepository(this.repo);
        diffFmt.setProgressMonitor(this.monitor);
        try {
            List<DiffEntry> list;
            if (this.cached) {
                if (this.oldTree == null) {
                    ObjectId head = this.repo.resolve("HEAD^{tree}");
                    if (head == null) {
                        throw new NoHeadException(JGitText.get().cannotReadTree);
                    }
                    CanonicalTreeParser p = new CanonicalTreeParser();
                    try (ObjectReader reader = this.repo.newObjectReader();){
                        p.reset(reader, head);
                    }
                    this.oldTree = p;
                }
                this.newTree = new DirCacheIterator(this.repo.readDirCache());
            } else {
                if (this.oldTree == null) {
                    this.oldTree = new DirCacheIterator(this.repo.readDirCache());
                }
                if (this.newTree == null) {
                    this.newTree = new FileTreeIterator(this.repo);
                }
            }
            diffFmt.setPathFilter(this.pathFilter);
            List<DiffEntry> result = diffFmt.scan(this.oldTree, this.newTree);
            if (this.showNameAndStatusOnly) {
                list = result;
                return list;
            }
            if (this.contextLines >= 0) {
                diffFmt.setContext(this.contextLines);
            }
            if (this.destinationPrefix != null) {
                diffFmt.setNewPrefix(this.destinationPrefix);
            }
            if (this.sourcePrefix != null) {
                diffFmt.setOldPrefix(this.sourcePrefix);
            }
            diffFmt.format(result);
            diffFmt.flush();
            list = result;
            return list;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            diffFmt.close();
        }
    }

    public DiffCommand setCached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public DiffCommand setPathFilter(TreeFilter pathFilter) {
        this.pathFilter = pathFilter;
        return this;
    }

    public DiffCommand setOldTree(AbstractTreeIterator oldTree) {
        this.oldTree = oldTree;
        return this;
    }

    public DiffCommand setNewTree(AbstractTreeIterator newTree) {
        this.newTree = newTree;
        return this;
    }

    public DiffCommand setShowNameAndStatusOnly(boolean showNameAndStatusOnly) {
        this.showNameAndStatusOnly = showNameAndStatusOnly;
        return this;
    }

    public DiffCommand setOutputStream(OutputStream out) {
        this.out = out;
        return this;
    }

    public DiffCommand setContextLines(int contextLines) {
        this.contextLines = contextLines;
        return this;
    }

    public DiffCommand setSourcePrefix(String sourcePrefix) {
        this.sourcePrefix = sourcePrefix;
        return this;
    }

    public DiffCommand setDestinationPrefix(String destinationPrefix) {
        this.destinationPrefix = destinationPrefix;
        return this;
    }

    public DiffCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }
}

