/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.RemoteConfig;
import java.net.URISyntaxException;
import java.util.List;

public class RemoteListCommand
extends GitCommand<List<RemoteConfig>> {
    protected RemoteListCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<RemoteConfig> call() throws GitAPIException {
        this.checkCallable();
        try {
            return RemoteConfig.getAllRemoteConfigs(this.repo.getConfig());
        }
        catch (URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

