/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.notes.Note;
import com.netflix.nebula.jgit.notes.NoteMap;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevObject;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import java.io.IOException;

public class ShowNoteCommand
extends GitCommand<Note> {
    private RevObject id;
    private String notesRef = "refs/notes/commits";

    protected ShowNoteCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Note call() throws GitAPIException {
        this.checkCallable();
        NoteMap map = NoteMap.newEmptyMap();
        RevCommit notesCommit = null;
        try (RevWalk walk = new RevWalk(this.repo);){
            Ref ref = this.repo.getRef(this.notesRef);
            if (ref != null) {
                notesCommit = walk.parseCommit(ref.getObjectId());
                map = NoteMap.read(walk.getObjectReader(), notesCommit);
            }
            Note note = map.getNote(this.id);
            return note;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public ShowNoteCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public ShowNoteCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

