/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.ReflogCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.InvalidRefNameException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.ReflogEntry;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.getRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator i$ = stashEntries.iterator();
            while (i$.hasNext()) {
                ReflogEntry entry = (ReflogEntry)i$.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                    return stashCommits;
                }
            }
        }
    }
}

