/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.CloneCommand;
import com.netflix.nebula.jgit.api.Git;
import com.netflix.nebula.jgit.api.MergeCommand;
import com.netflix.nebula.jgit.api.RebaseCommand;
import com.netflix.nebula.jgit.api.TransportCommand;
import com.netflix.nebula.jgit.api.errors.CheckoutConflictException;
import com.netflix.nebula.jgit.api.errors.ConcurrentRefUpdateException;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.InvalidConfigurationException;
import com.netflix.nebula.jgit.api.errors.InvalidMergeHeadsException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.api.errors.NoHeadException;
import com.netflix.nebula.jgit.api.errors.NoMessageException;
import com.netflix.nebula.jgit.api.errors.RefNotFoundException;
import com.netflix.nebula.jgit.api.errors.WrongRepositoryStateException;
import com.netflix.nebula.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.jgit.lib.ProgressMonitor;
import com.netflix.nebula.jgit.lib.RefUpdate;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.merge.MergeStrategy;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import com.netflix.nebula.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                block37: {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Repository submoduleRepo = generator.getRepository();
                    if (submoduleRepo == null) {
                        CloneCommand clone = Git.cloneRepository();
                        this.configure(clone);
                        clone.setURI(url);
                        clone.setDirectory(generator.getDirectory());
                        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
                        if (this.monitor != null) {
                            clone.setProgressMonitor(this.monitor);
                        }
                        submoduleRepo = clone.call().getRepository();
                    }
                    try (RevWalk walk = new RevWalk(submoduleRepo);){
                        RevCommit commit = walk.parseCommit(generator.getObjectId());
                        String update = generator.getConfigUpdate();
                        if ("merge".equals(update)) {
                            MergeCommand merge = new MergeCommand(submoduleRepo);
                            merge.include(commit);
                            merge.setProgressMonitor(this.monitor);
                            merge.setStrategy(this.strategy);
                            merge.call();
                            break block37;
                        }
                        if ("rebase".equals(update)) {
                            RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                            rebase.setUpstream(commit);
                            rebase.setProgressMonitor(this.monitor);
                            rebase.setStrategy(this.strategy);
                            rebase.call();
                        } else {
                            DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                            co.setFailOnConflict(true);
                            co.checkout();
                            RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                            refUpdate.setNewObjectId(commit);
                            refUpdate.forceUpdate();
                        }
                    }
                    finally {
                        submoduleRepo.close();
                    }
                }
                updated.add(generator.getPath());
            }
            ArrayList<String> arrayList = updated;
            return arrayList;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }
}

