/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.ignore.internal;

import com.netflix.nebula.jgit.ignore.internal.AbstractMatcher;
import com.netflix.nebula.jgit.ignore.internal.Strings;

public class NameMatcher
extends AbstractMatcher {
    final boolean beginning;
    final char slash;
    final String subPattern;

    NameMatcher(String pattern, Character pathSeparator, boolean dirOnly, boolean deleteBackslash) {
        super(pattern, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        if (deleteBackslash) {
            pattern = Strings.deleteBackslash(pattern);
        }
        this.beginning = pattern.length() == 0 ? false : pattern.charAt(0) == this.slash;
        this.subPattern = !this.beginning ? pattern : pattern.substring(1);
    }

    @Override
    public boolean matches(String path, boolean assumeDirectory) {
        int end = 0;
        int firstChar = 0;
        do {
            boolean match;
            if (!(match = this.matches(path, firstChar = this.getFirstNotSlash(path, end), end = this.getFirstSlash(path, firstChar), assumeDirectory))) continue;
            return !this.dirOnly ? true : end > 0 && end != path.length() || assumeDirectory;
        } while (!this.beginning && end != path.length());
        return false;
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        String s = this.subPattern;
        if (s.length() != endExcl - startIncl) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c2;
            char c1 = s.charAt(i);
            if (c1 == (c2 = segment.charAt(i + startIncl))) continue;
            return false;
        }
        return true;
    }

    private int getFirstNotSlash(String s, int start) {
        int slashIdx = s.indexOf(this.slash, start);
        return slashIdx == start ? start + 1 : start;
    }

    private int getFirstSlash(String s, int start) {
        int slashIdx = s.indexOf(this.slash, start);
        return slashIdx == -1 ? s.length() : slashIdx;
    }
}

