/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.ketch;

import com.netflix.nebula.jgit.annotations.NonNull;
import com.netflix.nebula.jgit.annotations.Nullable;
import com.netflix.nebula.jgit.internal.ketch.KetchLeader;
import com.netflix.nebula.jgit.internal.ketch.KetchSystem;
import com.netflix.nebula.jgit.internal.ketch.LagCheck;
import com.netflix.nebula.jgit.internal.ketch.LogIndex;
import com.netflix.nebula.jgit.internal.ketch.ReplicaConfig;
import com.netflix.nebula.jgit.internal.ketch.ReplicaFetchRequest;
import com.netflix.nebula.jgit.internal.ketch.ReplicaPushRequest;
import com.netflix.nebula.jgit.internal.ketch.ReplicaSnapshot;
import com.netflix.nebula.jgit.internal.ketch.Round;
import com.netflix.nebula.jgit.internal.storage.reftree.RefTree;
import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import com.netflix.nebula.jgit.transport.ReceiveCommand;
import com.netflix.nebula.jgit.treewalk.TreeWalk;
import com.netflix.nebula.jgit.util.SystemReader;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KetchReplica {
    static final Logger log = LoggerFactory.getLogger(KetchReplica.class);
    private static final byte[] PEEL = new byte[]{32, 94};
    private final KetchLeader leader;
    private final String replicaName;
    private final Participation participation;
    private final CommitMethod commitMethod;
    private final CommitSpeed commitSpeed;
    private final long minRetryMillis;
    private final long maxRetryMillis;
    private final Map<ObjectId, List<ReceiveCommand>> staged;
    private final Map<String, ReceiveCommand> running;
    private final Map<String, ReceiveCommand> waiting;
    private final List<ReplicaPushRequest> queued;
    private ObjectId txnAccepted;
    private ObjectId txnCommitted;
    private State state = State.UNKNOWN;
    private String error;
    private Future<?> retryFuture;
    private long lastRetryMillis;
    private long retryAtMillis;

    protected KetchReplica(KetchLeader leader, String name, ReplicaConfig cfg) {
        this.leader = leader;
        this.replicaName = name;
        this.participation = cfg.getParticipation();
        this.commitMethod = cfg.getCommitMethod();
        this.commitSpeed = cfg.getCommitSpeed();
        this.minRetryMillis = cfg.getMinRetry(TimeUnit.MILLISECONDS);
        this.maxRetryMillis = cfg.getMaxRetry(TimeUnit.MILLISECONDS);
        this.staged = new HashMap<ObjectId, List<ReceiveCommand>>();
        this.running = new HashMap<String, ReceiveCommand>();
        this.waiting = new HashMap<String, ReceiveCommand>();
        this.queued = new ArrayList<ReplicaPushRequest>(4);
    }

    public KetchSystem getSystem() {
        return this.getLeader().getSystem();
    }

    public KetchLeader getLeader() {
        return this.leader;
    }

    public String getName() {
        return this.replicaName;
    }

    protected String describeForLog() {
        return this.getName();
    }

    public Participation getParticipation() {
        return this.participation;
    }

    public CommitMethod getCommitMethod() {
        return this.commitMethod;
    }

    public CommitSpeed getCommitSpeed() {
        return this.commitSpeed;
    }

    protected void shutdown() {
        Future<?> f = this.retryFuture;
        if (f != null) {
            this.retryFuture = null;
            f.cancel(true);
        }
    }

    ReplicaSnapshot snapshot() {
        ReplicaSnapshot s = new ReplicaSnapshot(this);
        s.accepted = this.txnAccepted;
        s.committed = this.txnCommitted;
        s.state = this.state;
        s.error = this.error;
        s.retryAtMillis = this.waitingForRetry() ? this.retryAtMillis : 0L;
        return s;
    }

    void initialize(Map<String, Ref> refs) {
        if (this.txnAccepted == null) {
            this.txnAccepted = KetchReplica.getId(refs.get(this.getSystem().getTxnAccepted()));
        }
        if (this.txnCommitted == null) {
            this.txnCommitted = KetchReplica.getId(refs.get(this.getSystem().getTxnCommitted()));
        }
    }

    ObjectId getTxnAccepted() {
        return this.txnAccepted;
    }

    boolean hasAccepted(LogIndex id) {
        return KetchReplica.equals(this.txnAccepted, id);
    }

    private static boolean equals(@Nullable ObjectId a, LogIndex b) {
        return a != null && b != null && AnyObjectId.equals(a, b);
    }

    void pushTxnAcceptedAsync(Round round) {
        LogIndex committedIndex;
        ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>();
        if (this.commitSpeed == CommitSpeed.BATCHED && KetchReplica.equals(this.txnAccepted, committedIndex = this.leader.getCommitted()) && !KetchReplica.equals(this.txnCommitted, committedIndex)) {
            this.prepareTxnCommitted(cmds, committedIndex);
        }
        if (round.stageCommands != null) {
            for (ReceiveCommand cmd : round.stageCommands) {
                cmds.add(KetchReplica.copy(cmd));
            }
        }
        cmds.add(new ReceiveCommand(round.acceptedOldIndex, round.acceptedNewIndex, this.getSystem().getTxnAccepted()));
        this.pushAsync(new ReplicaPushRequest(this, cmds));
    }

    private static ReceiveCommand copy(ReceiveCommand c) {
        return new ReceiveCommand(c.getOldId(), c.getNewId(), c.getRefName());
    }

    boolean shouldPushUnbatchedCommit(LogIndex committed, boolean leaderIdle) {
        return (leaderIdle || this.commitSpeed == CommitSpeed.FAST) && this.hasAccepted(committed);
    }

    void pushCommitAsync(LogIndex committed) {
        ArrayList<ReceiveCommand> cmds = new ArrayList<ReceiveCommand>();
        this.prepareTxnCommitted(cmds, committed);
        this.pushAsync(new ReplicaPushRequest(this, cmds));
    }

    private void prepareTxnCommitted(List<ReceiveCommand> cmds, ObjectId committed) {
        this.removeStaged(cmds, committed);
        cmds.add(new ReceiveCommand(this.txnCommitted, committed, this.getSystem().getTxnCommitted()));
    }

    private void removeStaged(List<ReceiveCommand> cmds, ObjectId committed) {
        List<ReceiveCommand> a = this.staged.remove(committed);
        if (a != null) {
            KetchReplica.delete(cmds, a);
        }
        if (this.staged.isEmpty() || !(committed instanceof LogIndex)) {
            return;
        }
        LogIndex committedIndex = (LogIndex)committed;
        Iterator<Map.Entry<ObjectId, List<ReceiveCommand>>> itr = this.staged.entrySet().iterator();
        while (itr.hasNext()) {
            LogIndex stagedIndex;
            Map.Entry<ObjectId, List<ReceiveCommand>> e = itr.next();
            if (!(e.getKey() instanceof LogIndex) || !(stagedIndex = (LogIndex)e.getKey()).isBefore(committedIndex)) continue;
            KetchReplica.delete(cmds, e.getValue());
            itr.remove();
        }
    }

    private static void delete(List<ReceiveCommand> cmds, List<ReceiveCommand> createCmds) {
        for (ReceiveCommand cmd : createCmds) {
            ObjectId id = cmd.getNewId();
            String name = cmd.getRefName();
            cmds.add(new ReceiveCommand(id, ObjectId.zeroId(), name));
        }
    }

    private void runNextPushRequest() {
        LogIndex committed = this.leader.getCommitted();
        if (!KetchReplica.equals(this.txnCommitted, committed) && this.shouldPushUnbatchedCommit(committed, this.leader.isIdle())) {
            this.pushCommitAsync(committed);
        }
        if (this.queued.isEmpty() || !this.running.isEmpty() || this.waitingForRetry()) {
            return;
        }
        HashMap<String, ReceiveCommand> cmdMap = new HashMap<String, ReceiveCommand>();
        for (ReplicaPushRequest req : this.queued) {
            for (ReceiveCommand cmd : req.getCommands()) {
                String name = cmd.getRefName();
                ReceiveCommand old = (ReceiveCommand)cmdMap.remove(name);
                if (old != null) {
                    cmd = new ReceiveCommand(old.getOldId(), cmd.getNewId(), name);
                }
                cmdMap.put(name, cmd);
            }
        }
        this.queued.clear();
        this.waiting.clear();
        ArrayList<ReceiveCommand> next = new ArrayList<ReceiveCommand>(cmdMap.values());
        for (ReceiveCommand cmd : next) {
            this.running.put(cmd.getRefName(), cmd);
        }
        this.startPush(new ReplicaPushRequest(this, next));
    }

    private void pushAsync(ReplicaPushRequest req) {
        if (this.defer(req)) {
            for (ReceiveCommand cmd : req.getCommands()) {
                this.waiting.put(cmd.getRefName(), cmd);
            }
            this.queued.add(req);
        } else {
            for (ReceiveCommand cmd : req.getCommands()) {
                this.running.put(cmd.getRefName(), cmd);
            }
            this.startPush(req);
        }
    }

    private boolean defer(ReplicaPushRequest req) {
        if (this.waitingForRetry()) {
            return true;
        }
        for (ReceiveCommand nextCmd : req.getCommands()) {
            ReceiveCommand priorCmd = this.waiting.get(nextCmd.getRefName());
            if (priorCmd == null) {
                priorCmd = this.running.get(nextCmd.getRefName());
            }
            if (priorCmd == null) continue;
            return true;
        }
        return false;
    }

    private boolean waitingForRetry() {
        Future<?> f = this.retryFuture;
        return f != null && !f.isDone();
    }

    private void retryLater(ReplicaPushRequest req) {
        Collection<ReceiveCommand> cmds = req.getCommands();
        for (ReceiveCommand cmd : cmds) {
            cmd.setResult(ReceiveCommand.Result.NOT_ATTEMPTED, null);
            if (this.waiting.containsKey(cmd.getRefName())) continue;
            this.waiting.put(cmd.getRefName(), cmd);
        }
        this.queued.add(0, new ReplicaPushRequest(this, cmds));
        if (!this.waitingForRetry()) {
            long delay = KetchSystem.delay(this.lastRetryMillis, this.minRetryMillis, this.maxRetryMillis);
            if (log.isDebugEnabled()) {
                log.debug("Retrying {} after {} ms", (Object)this.describeForLog(), (Object)delay);
            }
            this.lastRetryMillis = delay;
            this.retryAtMillis = SystemReader.getInstance().getCurrentTime() + delay;
            this.retryFuture = this.getSystem().getExecutor().schedule(new WeakRetryPush(this), delay, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRetryPush() {
        this.leader.lock.lock();
        try {
            this.retryFuture = null;
            this.runNextPushRequest();
        }
        finally {
            this.leader.lock.unlock();
        }
    }

    protected abstract void startPush(ReplicaPushRequest var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void afterPush(@Nullable Repository repo, ReplicaPushRequest req) {
        ReceiveCommand acceptCmd = null;
        ReceiveCommand commitCmd = null;
        ArrayList<ReceiveCommand> stages = null;
        for (ReceiveCommand cmd : req.getCommands()) {
            String name = cmd.getRefName();
            if (name.equals(this.getSystem().getTxnAccepted())) {
                acceptCmd = cmd;
                continue;
            }
            if (name.equals(this.getSystem().getTxnCommitted())) {
                commitCmd = cmd;
                continue;
            }
            if (cmd.getResult() != ReceiveCommand.Result.OK || cmd.getType() != ReceiveCommand.Type.CREATE || !name.startsWith(this.getSystem().getTxnStage())) continue;
            if (stages == null) {
                stages = new ArrayList<ReceiveCommand>();
            }
            stages.add(cmd);
        }
        State newState = null;
        ObjectId acceptId = KetchReplica.readId(req, acceptCmd);
        if (repo != null && acceptCmd != null && acceptCmd.getResult() != ReceiveCommand.Result.OK && req.getException() == null) {
            try (LagCheck lag = new LagCheck(this, repo);){
                newState = lag.check(acceptId, acceptCmd);
                acceptId = lag.getRemoteId();
            }
        }
        this.leader.lock.lock();
        try {
            for (ReceiveCommand cmd : req.getCommands()) {
                this.running.remove(cmd.getRefName());
            }
            Throwable err = req.getException();
            if (err != null) {
                this.state = State.OFFLINE;
                this.error = err.toString();
                this.retryLater(req);
                this.leader.onReplicaUpdate(this);
                return;
            }
            this.lastRetryMillis = 0L;
            this.error = null;
            this.updateView(req, acceptId, commitCmd);
            if (acceptCmd != null && acceptCmd.getResult() == ReceiveCommand.Result.OK) {
                State state = this.state = this.hasAccepted(this.leader.getHead()) ? State.CURRENT : State.LAGGING;
                if (stages != null) {
                    this.staged.put(acceptCmd.getNewId(), stages);
                }
            } else if (newState != null) {
                this.state = newState;
            }
            this.leader.onReplicaUpdate(this);
            this.runNextPushRequest();
        }
        finally {
            this.leader.lock.unlock();
        }
    }

    private void updateView(ReplicaPushRequest req, @Nullable ObjectId acceptId, ReceiveCommand commitCmd) {
        Map<String, Ref> adv;
        ObjectId committed;
        if (acceptId != null) {
            this.txnAccepted = acceptId;
        }
        if ((committed = KetchReplica.readId(req, commitCmd)) != null) {
            this.txnCommitted = committed;
        } else if (acceptId != null && this.txnCommitted == null && (adv = req.getRefs()) != null) {
            Ref refs = adv.get(this.getSystem().getTxnCommitted());
            this.txnCommitted = KetchReplica.getId(refs);
        }
    }

    @Nullable
    private static ObjectId readId(ReplicaPushRequest req, @Nullable ReceiveCommand cmd) {
        if (cmd == null) {
            return null;
        }
        if (cmd.getResult() == ReceiveCommand.Result.OK) {
            return cmd.getNewId();
        }
        Map<String, Ref> refs = req.getRefs();
        return refs != null ? KetchReplica.getId(refs.get(cmd.getRefName())) : null;
    }

    protected abstract void blockingFetch(Repository var1, ReplicaFetchRequest var2) throws IOException;

    protected Collection<ReceiveCommand> prepareCommit(Repository git, Map<String, Ref> current, ObjectId committed) throws IOException {
        ArrayList<ReceiveCommand> delta = new ArrayList<ReceiveCommand>();
        HashMap<String, Ref> remote = new HashMap<String, Ref>(current);
        try (RevWalk rw = new RevWalk(git);
             TreeWalk tw = new TreeWalk(rw.getObjectReader());){
            tw.setRecursive(true);
            tw.addTree(rw.parseCommit(committed).getTree());
            while (tw.next()) {
                ObjectId newId;
                String name;
                Ref oldRef;
                ObjectId oldId;
                if (tw.getRawMode(0) != 57344 || tw.isPathSuffix(PEEL, 2) || AnyObjectId.equals(oldId = KetchReplica.getId(oldRef = (Ref)remote.remove(name = RefTree.refName(tw.getPathString()))), newId = tw.getObjectId(0))) continue;
                delta.add(new ReceiveCommand(oldId, newId, name));
            }
        }
        for (Ref ref : remote.values()) {
            if (!this.canDelete(ref)) continue;
            delta.add(new ReceiveCommand(ref.getObjectId(), ObjectId.zeroId(), ref.getName()));
        }
        return delta;
    }

    boolean canDelete(Ref ref) {
        String name = ref.getName();
        if ("HEAD".equals(name)) {
            return false;
        }
        return !name.startsWith(this.getSystem().getTxnNamespace());
    }

    @NonNull
    static ObjectId getId(@Nullable Ref ref) {
        ObjectId id;
        if (ref != null && (id = ref.getObjectId()) != null) {
            return id;
        }
        return ObjectId.zeroId();
    }

    public static enum CommitMethod {
        ALL_REFS,
        TXN_COMMITTED;

    }

    public static enum CommitSpeed {
        FAST,
        BATCHED;

    }

    public static enum Participation {
        FULL,
        FOLLOWER_ONLY;

    }

    public static enum State {
        UNKNOWN,
        LAGGING,
        CURRENT,
        DIVERGENT,
        AHEAD,
        OFFLINE;

    }

    static class WeakRetryPush
    extends WeakReference<KetchReplica>
    implements Callable<Void> {
        WeakRetryPush(KetchReplica r) {
            super(r);
        }

        @Override
        public Void call() throws Exception {
            KetchReplica r = (KetchReplica)this.get();
            if (r != null) {
                r.doRetryPush();
            }
            return null;
        }
    }
}

