/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.storage.dfs;

import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Config;
import java.text.MessageFormat;

public class DfsBlockCacheConfig {
    public static final int KB = 1024;
    public static final int MB = 0x100000;
    private long blockLimit;
    private int blockSize;
    private double streamRatio;

    public DfsBlockCacheConfig() {
        this.setBlockLimit(0x2000000L);
        this.setBlockSize(65536);
        this.setStreamRatio(0.3);
    }

    public long getBlockLimit() {
        return this.blockLimit;
    }

    public DfsBlockCacheConfig setBlockLimit(long newLimit) {
        this.blockLimit = newLimit;
        return this;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public DfsBlockCacheConfig setBlockSize(int newSize) {
        this.blockSize = Math.max(512, newSize);
        return this;
    }

    public double getStreamRatio() {
        return this.streamRatio;
    }

    public DfsBlockCacheConfig setStreamRatio(double ratio) {
        this.streamRatio = Math.max(0.0, Math.min(ratio, 1.0));
        return this;
    }

    public DfsBlockCacheConfig fromConfig(Config rc) {
        this.setBlockLimit(rc.getLong("core", "dfs", "blockLimit", this.getBlockLimit()));
        this.setBlockSize(rc.getInt("core", "dfs", "blockSize", this.getBlockSize()));
        String v = rc.getString("core", "dfs", "streamRatio");
        if (v != null) {
            try {
                this.setStreamRatio(Double.parseDouble(v));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().enumValueNotSupported3, "core", "dfs", "streamRatio", v));
            }
        }
        return this;
    }
}

