/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.lib;

import com.netflix.nebula.jgit.annotations.NonNull;
import com.netflix.nebula.jgit.annotations.Nullable;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.Ref;

public class SymbolicRef
implements Ref {
    private final String name;
    private final Ref target;

    public SymbolicRef(@NonNull String refName, @NonNull Ref target) {
        this.name = refName;
        this.target = target;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    @Override
    @NonNull
    public Ref getLeaf() {
        Ref dst = this.getTarget();
        while (dst.isSymbolic()) {
            dst = dst.getTarget();
        }
        return dst;
    }

    @Override
    @NonNull
    public Ref getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public ObjectId getObjectId() {
        return this.getLeaf().getObjectId();
    }

    @Override
    @NonNull
    public Ref.Storage getStorage() {
        return Ref.Storage.LOOSE;
    }

    @Override
    @Nullable
    public ObjectId getPeeledObjectId() {
        return this.getLeaf().getPeeledObjectId();
    }

    @Override
    public boolean isPeeled() {
        return this.getLeaf().isPeeled();
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("SymbolicRef[");
        Ref cur = this;
        while (cur.isSymbolic()) {
            r.append(cur.getName());
            r.append(" -> ");
            cur = cur.getTarget();
        }
        r.append(cur.getName());
        r.append('=');
        r.append(ObjectId.toString(cur.getObjectId()));
        r.append("]");
        return r.toString();
    }
}

