/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.MissingObjectException;
import com.netflix.nebula.jgit.errors.NotSupportedException;
import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ProgressMonitor;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevObject;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import com.netflix.nebula.jgit.transport.PushConnection;
import com.netflix.nebula.jgit.transport.PushResult;
import com.netflix.nebula.jgit.transport.RemoteRefUpdate;
import com.netflix.nebula.jgit.transport.TrackingRefUpdate;
import com.netflix.nebula.jgit.transport.Transport;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class PushProcess {
    static final String PROGRESS_OPENING_CONNECTION = JGitText.get().openingConnection;
    private final Transport transport;
    private PushConnection connection;
    private final Map<String, RemoteRefUpdate> toPush;
    private final RevWalk walker;
    private final OutputStream out;

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush) throws TransportException {
        this(transport, toPush, null);
    }

    PushProcess(Transport transport, Collection<RemoteRefUpdate> toPush, OutputStream out) throws TransportException {
        this.walker = new RevWalk(transport.local);
        this.transport = transport;
        this.toPush = new HashMap<String, RemoteRefUpdate>();
        this.out = out;
        for (RemoteRefUpdate rru : toPush) {
            if (this.toPush.put(rru.getRemoteName(), rru) == null) continue;
            throw new TransportException(MessageFormat.format(JGitText.get().duplicateRemoteRefUpdateIsIllegal, rru.getRemoteName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PushResult execute(ProgressMonitor monitor) throws NotSupportedException, TransportException {
        try {
            monitor.beginTask(PROGRESS_OPENING_CONNECTION, 0);
            PushResult res = new PushResult();
            this.connection = this.transport.openPush();
            try {
                res.setAdvertisedRefs(this.transport.getURI(), this.connection.getRefsMap());
                res.peerUserAgent = this.connection.getPeerUserAgent();
                res.setRemoteUpdates(this.toPush);
                monitor.endTask();
                Map<String, RemoteRefUpdate> preprocessed = this.prepareRemoteUpdates();
                if (this.transport.isDryRun()) {
                    this.modifyUpdatesForDryRun();
                } else if (!preprocessed.isEmpty()) {
                    this.connection.push(monitor, preprocessed, this.out);
                }
            }
            finally {
                this.connection.close();
                res.addMessages(this.connection.getMessages());
            }
            if (!this.transport.isDryRun()) {
                this.updateTrackingRefs();
            }
            for (RemoteRefUpdate rru : this.toPush.values()) {
                TrackingRefUpdate tru = rru.getTrackingRefUpdate();
                if (tru == null) continue;
                res.add(tru);
            }
            PushResult pushResult = res;
            return pushResult;
        }
        finally {
            this.walker.close();
        }
    }

    private Map<String, RemoteRefUpdate> prepareRemoteUpdates() throws TransportException {
        boolean atomic = this.transport.isPushAtomic();
        HashMap<String, RemoteRefUpdate> result = new HashMap<String, RemoteRefUpdate>();
        for (RemoteRefUpdate rru : this.toPush.values()) {
            Ref advertisedRef = this.connection.getRef(rru.getRemoteName());
            ObjectId advertisedOld = null;
            if (advertisedRef != null) {
                advertisedOld = advertisedRef.getObjectId();
            }
            if (advertisedOld == null) {
                advertisedOld = ObjectId.zeroId();
            }
            if (rru.getNewObjectId().equals(advertisedOld)) {
                if (rru.isDelete()) {
                    rru.setStatus(RemoteRefUpdate.Status.NON_EXISTING);
                    continue;
                }
                rru.setStatus(RemoteRefUpdate.Status.UP_TO_DATE);
                continue;
            }
            if (rru.isExpectingOldObjectId() && !rru.getExpectedOldObjectId().equals(advertisedOld)) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_REMOTE_CHANGED);
                if (!atomic) continue;
                return this.rejectAll();
            }
            if (!rru.isExpectingOldObjectId()) {
                rru.setExpectedOldObjectId(advertisedOld);
            }
            if (advertisedOld.equals(ObjectId.zeroId()) || rru.isDelete()) {
                rru.setFastForward(true);
                result.put(rru.getRemoteName(), rru);
                continue;
            }
            boolean fastForward = true;
            try {
                RevObject oldRev = this.walker.parseAny(advertisedOld);
                RevObject newRev = this.walker.parseAny(rru.getNewObjectId());
                if (!(oldRev instanceof RevCommit && newRev instanceof RevCommit && this.walker.isMergedInto((RevCommit)oldRev, (RevCommit)newRev))) {
                    fastForward = false;
                }
            }
            catch (MissingObjectException x) {
                fastForward = false;
            }
            catch (Exception x) {
                throw new TransportException(this.transport.getURI(), MessageFormat.format(JGitText.get().readingObjectsFromLocalRepositoryFailed, x.getMessage()), x);
            }
            rru.setFastForward(fastForward);
            if (!fastForward && !rru.isForceUpdate()) {
                rru.setStatus(RemoteRefUpdate.Status.REJECTED_NONFASTFORWARD);
                if (!atomic) continue;
                return this.rejectAll();
            }
            result.put(rru.getRemoteName(), rru);
        }
        return result;
    }

    private Map<String, RemoteRefUpdate> rejectAll() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.REJECTED_OTHER_REASON);
            rru.setMessage(JGitText.get().transactionAborted);
        }
        return Collections.emptyMap();
    }

    private void modifyUpdatesForDryRun() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            if (rru.getStatus() != RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
            rru.setStatus(RemoteRefUpdate.Status.OK);
        }
    }

    private void updateTrackingRefs() {
        for (RemoteRefUpdate rru : this.toPush.values()) {
            RemoteRefUpdate.Status status = rru.getStatus();
            if (!rru.hasTrackingRefUpdate() || status != RemoteRefUpdate.Status.UP_TO_DATE && status != RemoteRefUpdate.Status.OK) continue;
            try {
                rru.updateTrackingRef(this.walker);
            }
            catch (IOException iOException) {}
        }
    }
}

