/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.NotSupportedException;
import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.BundleFetchConnection;
import com.netflix.nebula.jgit.transport.FetchConnection;
import com.netflix.nebula.jgit.transport.PushConnection;
import com.netflix.nebula.jgit.transport.Transport;
import com.netflix.nebula.jgit.transport.TransportBundle;
import com.netflix.nebula.jgit.transport.TransportLocal;
import com.netflix.nebula.jgit.transport.TransportProtocol;
import com.netflix.nebula.jgit.transport.URIish;
import com.netflix.nebula.jgit.util.FS;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class TransportBundleFile
extends Transport
implements TransportBundle {
    static final TransportProtocol PROTO_BUNDLE = new TransportProtocol(){
        private final String[] schemeNames = new String[]{"bundle", "file"};
        private final Set<String> schemeSet = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(this.schemeNames)));

        @Override
        public String getName() {
            return JGitText.get().transportProtoBundleFile;
        }

        @Override
        public Set<String> getSchemes() {
            return this.schemeSet;
        }

        @Override
        public boolean canHandle(URIish uri, Repository local, String remoteName) {
            return uri.getPath() != null && uri.getPort() <= 0 && uri.getUser() == null && uri.getPass() == null && uri.getHost() == null && (uri.getScheme() == null || this.getSchemes().contains(uri.getScheme()));
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NotSupportedException, TransportException {
            if ("bundle".equals(uri.getScheme())) {
                File path = local.getFS().resolve(new File("."), uri.getPath());
                return new TransportBundleFile(local, uri, path);
            }
            return TransportLocal.PROTO_LOCAL.open(uri, local, remoteName);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException, TransportException {
            if ("bundle".equals(uri.getScheme())) {
                File path = FS.DETECTED.resolve(new File("."), uri.getPath());
                return new TransportBundleFile(uri, path);
            }
            return TransportLocal.PROTO_LOCAL.open(uri);
        }
    };
    private final File bundle;

    TransportBundleFile(Repository local, URIish uri, File bundlePath) {
        super(local, uri);
        this.bundle = bundlePath;
    }

    public TransportBundleFile(URIish uri, File bundlePath) {
        super(uri);
        this.bundle = bundlePath;
    }

    @Override
    public FetchConnection openFetch() throws NotSupportedException, TransportException {
        FileInputStream src;
        try {
            src = new FileInputStream(this.bundle);
        }
        catch (FileNotFoundException err) {
            throw new TransportException(this.uri, JGitText.get().notFound);
        }
        return new BundleFetchConnection(this, src);
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
    }
}

