/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.transport;

import com.netflix.nebula.jgit.errors.NoRemoteRepositoryException;
import com.netflix.nebula.jgit.errors.NotSupportedException;
import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.lib.RepositoryBuilder;
import com.netflix.nebula.jgit.lib.RepositoryCache;
import com.netflix.nebula.jgit.transport.BasePackFetchConnection;
import com.netflix.nebula.jgit.transport.BasePackPushConnection;
import com.netflix.nebula.jgit.transport.FetchConnection;
import com.netflix.nebula.jgit.transport.InternalFetchConnection;
import com.netflix.nebula.jgit.transport.InternalPushConnection;
import com.netflix.nebula.jgit.transport.PackTransport;
import com.netflix.nebula.jgit.transport.PushConnection;
import com.netflix.nebula.jgit.transport.ReceivePack;
import com.netflix.nebula.jgit.transport.Transport;
import com.netflix.nebula.jgit.transport.TransportBundleFile;
import com.netflix.nebula.jgit.transport.TransportProtocol;
import com.netflix.nebula.jgit.transport.URIish;
import com.netflix.nebula.jgit.transport.UploadPack;
import com.netflix.nebula.jgit.transport.resolver.ReceivePackFactory;
import com.netflix.nebula.jgit.transport.resolver.UploadPackFactory;
import com.netflix.nebula.jgit.util.FS;
import com.netflix.nebula.jgit.util.io.MessageWriter;
import com.netflix.nebula.jgit.util.io.SafeBufferedOutputStream;
import com.netflix.nebula.jgit.util.io.StreamCopyThread;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

class TransportLocal
extends Transport
implements PackTransport {
    static final TransportProtocol PROTO_LOCAL = new TransportProtocol(){

        @Override
        public String getName() {
            return JGitText.get().transportProtoLocal;
        }

        @Override
        public Set<String> getSchemes() {
            return Collections.singleton("file");
        }

        @Override
        public boolean canHandle(URIish uri, Repository local, String remoteName) {
            return uri.getPath() != null && uri.getPort() <= 0 && uri.getUser() == null && uri.getPass() == null && uri.getHost() == null && (uri.getScheme() == null || this.getSchemes().contains(uri.getScheme()));
        }

        @Override
        public Transport open(URIish uri, Repository local, String remoteName) throws NoRemoteRepositoryException {
            File localPath = local.isBare() ? local.getDirectory() : local.getWorkTree();
            File path = local.getFS().resolve(localPath, uri.getPath());
            if (path.isFile()) {
                return new TransportBundleFile(local, uri, path);
            }
            File gitDir = RepositoryCache.FileKey.resolve(path, local.getFS());
            if (gitDir == null) {
                throw new NoRemoteRepositoryException(uri, JGitText.get().notFound);
            }
            return new TransportLocal(local, uri, gitDir);
        }

        @Override
        public Transport open(URIish uri) throws NotSupportedException, TransportException {
            File path = FS.DETECTED.resolve(new File("."), uri.getPath());
            if (path.isFile()) {
                return new TransportBundleFile(uri, path);
            }
            File gitDir = RepositoryCache.FileKey.resolve(path, FS.DETECTED);
            if (gitDir == null) {
                throw new NoRemoteRepositoryException(uri, JGitText.get().notFound);
            }
            return new TransportLocal(uri, gitDir);
        }
    };
    private final File remoteGitDir;

    TransportLocal(Repository local, URIish uri, File gitDir) {
        super(local, uri);
        this.remoteGitDir = gitDir;
    }

    TransportLocal(URIish uri, File gitDir) {
        super(uri);
        this.remoteGitDir = gitDir;
    }

    UploadPack createUploadPack(Repository dst) {
        return new UploadPack(dst);
    }

    ReceivePack createReceivePack(Repository dst) {
        return new ReceivePack(dst);
    }

    private Repository openRepo() throws TransportException {
        try {
            return ((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.remoteGitDir)).build();
        }
        catch (IOException err) {
            throw new TransportException(this.uri, JGitText.get().notAGitDirectory);
        }
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        String up = this.getOptionUploadPack();
        if (!"git-upload-pack".equals(up) && !"git upload-pack".equals(up)) {
            return new ForkLocalFetchConnection();
        }
        UploadPackFactory<Void> upf = new UploadPackFactory<Void>(){

            @Override
            public UploadPack create(Void req, Repository db) {
                return TransportLocal.this.createUploadPack(db);
            }
        };
        return new InternalFetchConnection<Object>(this, upf, null, this.openRepo());
    }

    @Override
    public PushConnection openPush() throws TransportException {
        String rp = this.getOptionReceivePack();
        if (!"git-receive-pack".equals(rp) && !"git receive-pack".equals(rp)) {
            return new ForkLocalPushConnection();
        }
        ReceivePackFactory<Void> rpf = new ReceivePackFactory<Void>(){

            @Override
            public ReceivePack create(Void req, Repository db) {
                return TransportLocal.this.createReceivePack(db);
            }
        };
        return new InternalPushConnection<Object>(this, rpf, null, this.openRepo());
    }

    @Override
    public void close() {
    }

    protected Process spawn(String cmd) throws TransportException {
        try {
            String[] args = new String[]{"."};
            ProcessBuilder proc = this.local.getFS().runInShell(cmd, args);
            proc.directory(this.remoteGitDir);
            Map<String, String> env = proc.environment();
            env.remove("GIT_ALTERNATE_OBJECT_DIRECTORIES");
            env.remove("GIT_CONFIG");
            env.remove("GIT_CONFIG_PARAMETERS");
            env.remove("GIT_DIR");
            env.remove("GIT_WORK_TREE");
            env.remove("GIT_GRAFT_FILE");
            env.remove("GIT_INDEX_FILE");
            env.remove("GIT_NO_REPLACE_OBJECTS");
            return proc.start();
        }
        catch (IOException err) {
            throw new TransportException(this.uri, err.getMessage(), err);
        }
    }

    class ForkLocalFetchConnection
    extends BasePackFetchConnection {
        private Process uploadPack;
        private Thread errorReaderThread;

        ForkLocalFetchConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.uploadPack = TransportLocal.this.spawn(TransportLocal.this.getOptionUploadPack());
            InputStream upErr = this.uploadPack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(upErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream upIn = this.uploadPack.getInputStream();
            OutputStream upOut = this.uploadPack.getOutputStream();
            upIn = new BufferedInputStream(upIn);
            upOut = new SafeBufferedOutputStream(upOut);
            this.init(upIn, upOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            if (this.uploadPack != null) {
                try {
                    this.uploadPack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.uploadPack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }

    class ForkLocalPushConnection
    extends BasePackPushConnection {
        private Process receivePack;
        private Thread errorReaderThread;

        ForkLocalPushConnection() throws TransportException {
            super(TransportLocal.this);
            MessageWriter msg = new MessageWriter();
            this.setMessageWriter(msg);
            this.receivePack = TransportLocal.this.spawn(TransportLocal.this.getOptionReceivePack());
            InputStream rpErr = this.receivePack.getErrorStream();
            this.errorReaderThread = new StreamCopyThread(rpErr, msg.getRawStream());
            this.errorReaderThread.start();
            InputStream rpIn = this.receivePack.getInputStream();
            OutputStream rpOut = this.receivePack.getOutputStream();
            rpIn = new BufferedInputStream(rpIn);
            rpOut = new SafeBufferedOutputStream(rpOut);
            this.init(rpIn, rpOut);
            this.readAdvertisedRefs();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            super.close();
            if (this.receivePack != null) {
                try {
                    this.receivePack.waitFor();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.receivePack = null;
                }
            }
            if (this.errorReaderThread != null) {
                try {
                    this.errorReaderThread.join();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.errorReaderThread = null;
                }
            }
        }
    }
}

