/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.AddCommand;
import com.netflix.nebula.jgit.api.AddNoteCommand;
import com.netflix.nebula.jgit.api.ApplyCommand;
import com.netflix.nebula.jgit.api.ArchiveCommand;
import com.netflix.nebula.jgit.api.BlameCommand;
import com.netflix.nebula.jgit.api.CheckoutCommand;
import com.netflix.nebula.jgit.api.CherryPickCommand;
import com.netflix.nebula.jgit.api.CleanCommand;
import com.netflix.nebula.jgit.api.CloneCommand;
import com.netflix.nebula.jgit.api.CommitCommand;
import com.netflix.nebula.jgit.api.CreateBranchCommand;
import com.netflix.nebula.jgit.api.DeleteBranchCommand;
import com.netflix.nebula.jgit.api.DeleteTagCommand;
import com.netflix.nebula.jgit.api.DescribeCommand;
import com.netflix.nebula.jgit.api.DiffCommand;
import com.netflix.nebula.jgit.api.FetchCommand;
import com.netflix.nebula.jgit.api.GarbageCollectCommand;
import com.netflix.nebula.jgit.api.InitCommand;
import com.netflix.nebula.jgit.api.ListBranchCommand;
import com.netflix.nebula.jgit.api.ListNotesCommand;
import com.netflix.nebula.jgit.api.ListTagCommand;
import com.netflix.nebula.jgit.api.LogCommand;
import com.netflix.nebula.jgit.api.LsRemoteCommand;
import com.netflix.nebula.jgit.api.MergeCommand;
import com.netflix.nebula.jgit.api.NameRevCommand;
import com.netflix.nebula.jgit.api.PullCommand;
import com.netflix.nebula.jgit.api.PushCommand;
import com.netflix.nebula.jgit.api.RebaseCommand;
import com.netflix.nebula.jgit.api.ReflogCommand;
import com.netflix.nebula.jgit.api.RemoteAddCommand;
import com.netflix.nebula.jgit.api.RemoteListCommand;
import com.netflix.nebula.jgit.api.RemoteRemoveCommand;
import com.netflix.nebula.jgit.api.RemoteSetUrlCommand;
import com.netflix.nebula.jgit.api.RemoveNoteCommand;
import com.netflix.nebula.jgit.api.RenameBranchCommand;
import com.netflix.nebula.jgit.api.ResetCommand;
import com.netflix.nebula.jgit.api.RevertCommand;
import com.netflix.nebula.jgit.api.RmCommand;
import com.netflix.nebula.jgit.api.ShowNoteCommand;
import com.netflix.nebula.jgit.api.StashApplyCommand;
import com.netflix.nebula.jgit.api.StashCreateCommand;
import com.netflix.nebula.jgit.api.StashDropCommand;
import com.netflix.nebula.jgit.api.StashListCommand;
import com.netflix.nebula.jgit.api.StatusCommand;
import com.netflix.nebula.jgit.api.SubmoduleAddCommand;
import com.netflix.nebula.jgit.api.SubmoduleInitCommand;
import com.netflix.nebula.jgit.api.SubmoduleStatusCommand;
import com.netflix.nebula.jgit.api.SubmoduleSyncCommand;
import com.netflix.nebula.jgit.api.SubmoduleUpdateCommand;
import com.netflix.nebula.jgit.api.TagCommand;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.lib.RepositoryBuilder;
import com.netflix.nebula.jgit.lib.RepositoryCache;
import com.netflix.nebula.jgit.util.FS;
import java.io.File;
import java.io.IOException;

public class Git
implements AutoCloseable {
    private final Repository repo;
    private final boolean closeRepo;

    public static Git open(File dir) throws IOException {
        return Git.open(dir, FS.DETECTED);
    }

    public static Git open(File dir, FS fs) throws IOException {
        RepositoryCache.FileKey key = RepositoryCache.FileKey.lenient(dir, fs);
        Object db = ((RepositoryBuilder)((RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().setFS(fs)).setGitDir(key.getFile())).setMustExist(true)).build();
        return new Git((Repository)db, true);
    }

    public static Git wrap(Repository repo) {
        return new Git(repo);
    }

    @Override
    public void close() {
        if (this.closeRepo) {
            this.repo.close();
        }
    }

    public static CloneCommand cloneRepository() {
        return new CloneCommand();
    }

    public static LsRemoteCommand lsRemoteRepository() {
        return new LsRemoteCommand(null);
    }

    public static InitCommand init() {
        return new InitCommand();
    }

    public Git(Repository repo) {
        this(repo, false);
    }

    Git(Repository repo, boolean closeRepo) {
        if (repo == null) {
            throw new NullPointerException();
        }
        this.repo = repo;
        this.closeRepo = closeRepo;
    }

    public CommitCommand commit() {
        return new CommitCommand(this.repo);
    }

    public LogCommand log() {
        return new LogCommand(this.repo);
    }

    public MergeCommand merge() {
        return new MergeCommand(this.repo);
    }

    public PullCommand pull() {
        return new PullCommand(this.repo);
    }

    public CreateBranchCommand branchCreate() {
        return new CreateBranchCommand(this.repo);
    }

    public DeleteBranchCommand branchDelete() {
        return new DeleteBranchCommand(this.repo);
    }

    public ListBranchCommand branchList() {
        return new ListBranchCommand(this.repo);
    }

    public ListTagCommand tagList() {
        return new ListTagCommand(this.repo);
    }

    public RenameBranchCommand branchRename() {
        return new RenameBranchCommand(this.repo);
    }

    public AddCommand add() {
        return new AddCommand(this.repo);
    }

    public TagCommand tag() {
        return new TagCommand(this.repo);
    }

    public FetchCommand fetch() {
        return new FetchCommand(this.repo);
    }

    public PushCommand push() {
        return new PushCommand(this.repo);
    }

    public CherryPickCommand cherryPick() {
        return new CherryPickCommand(this.repo);
    }

    public RevertCommand revert() {
        return new RevertCommand(this.repo);
    }

    public RebaseCommand rebase() {
        return new RebaseCommand(this.repo);
    }

    public RmCommand rm() {
        return new RmCommand(this.repo);
    }

    public CheckoutCommand checkout() {
        return new CheckoutCommand(this.repo);
    }

    public ResetCommand reset() {
        return new ResetCommand(this.repo);
    }

    public StatusCommand status() {
        return new StatusCommand(this.repo);
    }

    public ArchiveCommand archive() {
        return new ArchiveCommand(this.repo);
    }

    public AddNoteCommand notesAdd() {
        return new AddNoteCommand(this.repo);
    }

    public RemoveNoteCommand notesRemove() {
        return new RemoveNoteCommand(this.repo);
    }

    public ListNotesCommand notesList() {
        return new ListNotesCommand(this.repo);
    }

    public ShowNoteCommand notesShow() {
        return new ShowNoteCommand(this.repo);
    }

    public LsRemoteCommand lsRemote() {
        return new LsRemoteCommand(this.repo);
    }

    public CleanCommand clean() {
        return new CleanCommand(this.repo);
    }

    public BlameCommand blame() {
        return new BlameCommand(this.repo);
    }

    public ReflogCommand reflog() {
        return new ReflogCommand(this.repo);
    }

    public DiffCommand diff() {
        return new DiffCommand(this.repo);
    }

    public DeleteTagCommand tagDelete() {
        return new DeleteTagCommand(this.repo);
    }

    public SubmoduleAddCommand submoduleAdd() {
        return new SubmoduleAddCommand(this.repo);
    }

    public SubmoduleInitCommand submoduleInit() {
        return new SubmoduleInitCommand(this.repo);
    }

    public SubmoduleStatusCommand submoduleStatus() {
        return new SubmoduleStatusCommand(this.repo);
    }

    public SubmoduleSyncCommand submoduleSync() {
        return new SubmoduleSyncCommand(this.repo);
    }

    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(this.repo);
    }

    public StashListCommand stashList() {
        return new StashListCommand(this.repo);
    }

    public StashCreateCommand stashCreate() {
        return new StashCreateCommand(this.repo);
    }

    public StashApplyCommand stashApply() {
        return new StashApplyCommand(this.repo);
    }

    public StashDropCommand stashDrop() {
        return new StashDropCommand(this.repo);
    }

    public ApplyCommand apply() {
        return new ApplyCommand(this.repo);
    }

    public GarbageCollectCommand gc() {
        return new GarbageCollectCommand(this.repo);
    }

    public NameRevCommand nameRev() {
        return new NameRevCommand(this.repo);
    }

    public DescribeCommand describe() {
        return new DescribeCommand(this.repo);
    }

    public RemoteListCommand remoteList() {
        return new RemoteListCommand(this.repo);
    }

    public RemoteAddCommand remoteAdd() {
        return new RemoteAddCommand(this.repo);
    }

    public RemoteRemoveCommand remoteRemove() {
        return new RemoteRemoveCommand(this.repo);
    }

    public RemoteSetUrlCommand remoteSetUrl() {
        return new RemoteSetUrlCommand(this.repo);
    }

    public Repository getRepository() {
        return this.repo;
    }

    public String toString() {
        return "Git[" + this.repo + "]";
    }
}

