/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.lib.StoredConfig;
import com.netflix.nebula.jgit.transport.RemoteConfig;
import java.io.IOException;
import java.net.URISyntaxException;

public class RemoteRemoveCommand
extends GitCommand<RemoteConfig> {
    private String name;

    protected RemoteRemoveCommand(Repository repo) {
        super(repo);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public RemoteConfig call() throws GitAPIException {
        this.checkCallable();
        try {
            StoredConfig config = this.repo.getConfig();
            RemoteConfig remote = new RemoteConfig(config, this.name);
            config.unsetSection("remote", this.name);
            config.save();
            return remote;
        }
        catch (IOException | URISyntaxException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

