/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.Git;
import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.MergeResult;
import com.netflix.nebula.jgit.api.errors.ConcurrentRefUpdateException;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.api.errors.MultipleParentsNotAllowedException;
import com.netflix.nebula.jgit.api.errors.NoHeadException;
import com.netflix.nebula.jgit.api.errors.NoMessageException;
import com.netflix.nebula.jgit.api.errors.UnmergedPathsException;
import com.netflix.nebula.jgit.api.errors.WrongRepositoryStateException;
import com.netflix.nebula.jgit.dircache.DirCacheCheckout;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ObjectIdRef;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.merge.MergeMessageFormatter;
import com.netflix.nebula.jgit.merge.MergeStrategy;
import com.netflix.nebula.jgit.merge.ResolveMerger;
import com.netflix.nebula.jgit.revwalk.RevCommit;
import com.netflix.nebula.jgit.revwalk.RevWalk;
import com.netflix.nebula.jgit.treewalk.FileTreeIterator;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RevertCommand
extends GitCommand<RevCommit> {
    private List<Ref> commits = new LinkedList<Ref>();
    private String ourCommitName = null;
    private List<Ref> revertedRefs = new LinkedList<Ref>();
    private MergeResult failingResult;
    private List<String> unmergedPaths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;

    protected RevertCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RevCommit call() throws NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, GitAPIException {
        RevCommit newHead = null;
        this.checkCallable();
        try (RevWalk revWalk = new RevWalk(this.repo);){
            String newMessage;
            ResolveMerger merger;
            RevCommit srcParent;
            RevCommit srcCommit;
            RevCommit headCommit;
            block34: {
                Ref headRef = this.repo.getRef("HEAD");
                if (headRef == null) {
                    throw new NoHeadException(JGitText.get().commitOnRepoWithoutHEADCurrentlyNotSupported);
                }
                newHead = headCommit = revWalk.parseCommit(headRef.getObjectId());
                Iterator<Ref> i$ = this.commits.iterator();
                while (i$.hasNext()) {
                    Ref src = i$.next();
                    ObjectId srcObjectId = src.getPeeledObjectId();
                    if (srcObjectId == null) {
                        srcObjectId = src.getObjectId();
                    }
                    if ((srcCommit = revWalk.parseCommit(srcObjectId)).getParentCount() != 1) {
                        throw new MultipleParentsNotAllowedException(MessageFormat.format(JGitText.get().canOnlyRevertCommitsWithOneParent, srcCommit.name(), srcCommit.getParentCount()));
                    }
                    srcParent = srcCommit.getParent(0);
                    revWalk.parseHeaders(srcParent);
                    String ourName = this.calculateOurName(headRef);
                    String revertName = srcCommit.getId().abbreviate(7).name() + " " + srcCommit.getShortMessage();
                    merger = (ResolveMerger)this.strategy.newMerger(this.repo);
                    merger.setWorkingTreeIterator(new FileTreeIterator(this.repo));
                    merger.setBase(srcCommit.getTree());
                    merger.setCommitNames(new String[]{"BASE", ourName, revertName});
                    String shortMessage = "Revert \"" + srcCommit.getShortMessage() + "\"";
                    newMessage = shortMessage + "\n\n" + "This reverts commit " + srcCommit.getId().getName() + ".\n";
                    if (!merger.merge(headCommit, srcParent)) break block34;
                    if (AnyObjectId.equals(headCommit.getTree().getId(), merger.getResultTreeId())) continue;
                    DirCacheCheckout dco = new DirCacheCheckout(this.repo, headCommit.getTree(), this.repo.lockDirCache(), merger.getResultTreeId());
                    dco.setFailOnConflict(true);
                    dco.checkout();
                    try (Git git = new Git(this.getRepository());){
                        newHead = git.commit().setMessage(newMessage).setReflogComment("revert: " + shortMessage).call();
                    }
                    this.revertedRefs.add(src);
                    headCommit = newHead;
                }
                return newHead;
            }
            this.unmergedPaths = merger.getUnmergedPaths();
            Map<String, ResolveMerger.MergeFailureReason> failingPaths = merger.getFailingPaths();
            this.failingResult = failingPaths != null ? new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.FAILED, this.strategy, merger.getMergeResults(), failingPaths, null) : new MergeResult(null, merger.getBaseCommitId(), new ObjectId[]{headCommit.getId(), srcParent.getId()}, MergeResult.MergeStatus.CONFLICTING, this.strategy, merger.getMergeResults(), failingPaths, null);
            if (!merger.failed() && !this.unmergedPaths.isEmpty()) {
                String message = new MergeMessageFormatter().formatWithConflicts(newMessage, merger.getUnmergedPaths());
                this.repo.writeRevertHead(srcCommit.getId());
                this.repo.writeMergeCommitMsg(message);
            }
            RevCommit revCommit = null;
            return revCommit;
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().exceptionCaughtDuringExecutionOfRevertCommand, e), e);
        }
    }

    public RevertCommand include(Ref commit) {
        this.checkCallable();
        this.commits.add(commit);
        return this;
    }

    public RevertCommand include(AnyObjectId commit) {
        return this.include(commit.getName(), commit);
    }

    public RevertCommand include(String name, AnyObjectId commit) {
        return this.include(new ObjectIdRef.Unpeeled(Ref.Storage.LOOSE, name, commit.copy()));
    }

    public RevertCommand setOurCommitName(String ourCommitName) {
        this.ourCommitName = ourCommitName;
        return this;
    }

    private String calculateOurName(Ref headRef) {
        if (this.ourCommitName != null) {
            return this.ourCommitName;
        }
        String targetRefName = headRef.getTarget().getName();
        String headName = Repository.shortenRefName(targetRefName);
        return headName;
    }

    public List<Ref> getRevertedRefs() {
        return this.revertedRefs;
    }

    public MergeResult getFailingResult() {
        return this.failingResult;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public RevertCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }
}

