/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.api.errors.NoFilepatternException;
import com.netflix.nebula.jgit.dircache.DirCache;
import com.netflix.nebula.jgit.dircache.DirCacheBuildIterator;
import com.netflix.nebula.jgit.dircache.DirCacheBuilder;
import com.netflix.nebula.jgit.internal.JGitText;
import com.netflix.nebula.jgit.lib.FileMode;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.treewalk.TreeWalk;
import com.netflix.nebula.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private boolean cached = false;

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public RmCommand setCached(boolean cached) {
        this.checkCallable();
        this.cached = cached;
        return this;
    }

    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.reset();
            tw.setRecursive(true);
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            tw.addTree(new DirCacheBuildIterator(builder));
            while (tw.next()) {
                FileMode mode;
                if (this.cached || (mode = tw.getFileMode(0)).getObjectType() != 3) continue;
                File path = new File(this.repo.getWorkTree(), tw.getPathString());
                this.delete(path);
            }
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e);
        }
        finally {
            if (dc != null) {
                dc.unlock();
            }
        }
        return dc;
    }

    private void delete(File p) {
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            p = p.getParentFile();
        }
    }
}

