/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.api;

import com.netflix.nebula.jgit.api.GitCommand;
import com.netflix.nebula.jgit.api.errors.GitAPIException;
import com.netflix.nebula.jgit.api.errors.JGitInternalException;
import com.netflix.nebula.jgit.errors.ConfigInvalidException;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.lib.StoredConfig;
import com.netflix.nebula.jgit.submodule.SubmoduleWalk;
import com.netflix.nebula.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    @Override
    public Collection<String> call() throws GitAPIException {
        this.checkCallable();
        try {
            SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            StoredConfig config = this.repo.getConfig();
            ArrayList<String> initialized = new ArrayList<String>();
            while (generator.next()) {
                if (generator.getConfigUrl() != null) continue;
                String path = generator.getPath();
                String url = generator.getRemoteUrl();
                String update = generator.getModulesUpdate();
                if (url != null) {
                    config.setString("submodule", path, "url", url);
                }
                if (update != null) {
                    config.setString("submodule", path, "update", update);
                }
                if (url == null && update == null) continue;
                initialized.add(path);
            }
            if (!initialized.isEmpty()) {
                config.save();
            }
            return initialized;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

