/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.attributes;

import com.netflix.nebula.jgit.attributes.Attribute;
import com.netflix.nebula.jgit.errors.InvalidPatternException;
import com.netflix.nebula.jgit.ignore.internal.IMatcher;
import com.netflix.nebula.jgit.ignore.internal.PathMatcher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AttributesRule {
    private static final String ATTRIBUTES_SPLIT_REGEX = "[ \t\r]";
    private final String pattern;
    private final List<Attribute> attributes;
    private final boolean nameOnly;
    private final boolean dirOnly;
    private final IMatcher matcher;

    private static List<Attribute> parseAttributes(String attributesLine) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (String attribute : attributesLine.split(ATTRIBUTES_SPLIT_REGEX)) {
            if ((attribute = attribute.trim()).length() == 0) continue;
            if (attribute.startsWith("-")) {
                if (attribute.length() <= 1) continue;
                result.add(new Attribute(attribute.substring(1), Attribute.State.UNSET));
                continue;
            }
            if (attribute.startsWith("!")) {
                if (attribute.length() <= 1) continue;
                result.add(new Attribute(attribute.substring(1), Attribute.State.UNSPECIFIED));
                continue;
            }
            int equalsIndex = attribute.indexOf("=");
            if (equalsIndex == -1) {
                result.add(new Attribute(attribute, Attribute.State.SET));
                continue;
            }
            String attributeKey = attribute.substring(0, equalsIndex);
            if (attributeKey.length() <= 0) continue;
            String attributeValue = attribute.substring(equalsIndex + 1);
            result.add(new Attribute(attributeKey, attributeValue));
        }
        return result;
    }

    public AttributesRule(String pattern, String attributes) {
        this.attributes = AttributesRule.parseAttributes(attributes);
        if (pattern.endsWith("/")) {
            pattern = pattern.substring(0, pattern.length() - 1);
            this.dirOnly = true;
        } else {
            this.dirOnly = false;
        }
        int slashIndex = pattern.indexOf(47);
        if (slashIndex < 0) {
            this.nameOnly = true;
        } else if (slashIndex == 0) {
            this.nameOnly = false;
        } else {
            this.nameOnly = false;
            pattern = "/" + pattern;
        }
        IMatcher candidateMatcher = IMatcher.NO_MATCH;
        try {
            candidateMatcher = PathMatcher.createPathMatcher(pattern, Character.valueOf('/'), this.dirOnly);
        }
        catch (InvalidPatternException invalidPatternException) {
            // empty catch block
        }
        this.matcher = candidateMatcher;
        this.pattern = pattern;
    }

    public boolean isDirOnly() {
        return this.dirOnly;
    }

    public List<Attribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    public boolean isNameOnly() {
        return this.nameOnly;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isMatch(String relativeTarget, boolean isDirectory) {
        if (relativeTarget == null) {
            return false;
        }
        if (relativeTarget.length() == 0) {
            return false;
        }
        boolean match = this.matcher.matches(relativeTarget, isDirectory);
        return match;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.pattern);
        for (Attribute a : this.attributes) {
            sb.append(" ");
            sb.append(a);
        }
        return sb.toString();
    }
}

