/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.events;

import com.netflix.nebula.jgit.events.ConfigChangedListener;
import com.netflix.nebula.jgit.events.IndexChangedListener;
import com.netflix.nebula.jgit.events.ListenerHandle;
import com.netflix.nebula.jgit.events.RefsChangedListener;
import com.netflix.nebula.jgit.events.RepositoryEvent;
import com.netflix.nebula.jgit.events.RepositoryListener;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ListenerList {
    private final ConcurrentMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>> lists = new ConcurrentHashMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>>();

    public ListenerHandle addIndexChangedListener(IndexChangedListener listener) {
        return this.addListener(IndexChangedListener.class, listener);
    }

    public ListenerHandle addRefsChangedListener(RefsChangedListener listener) {
        return this.addListener(RefsChangedListener.class, listener);
    }

    public ListenerHandle addConfigChangedListener(ConfigChangedListener listener) {
        return this.addListener(ConfigChangedListener.class, listener);
    }

    public <T extends RepositoryListener> ListenerHandle addListener(Class<T> type, T listener) {
        ListenerHandle handle = new ListenerHandle(this, type, listener);
        this.add(handle);
        return handle;
    }

    public void dispatch(RepositoryEvent event) {
        List list = (List)this.lists.get(event.getListenerType());
        if (list != null) {
            for (ListenerHandle handle : list) {
                event.dispatch(handle.listener);
            }
        }
    }

    private void add(ListenerHandle handle) {
        CopyOnWriteArrayList<ListenerHandle> newList;
        CopyOnWriteArrayList<ListenerHandle> list = (CopyOnWriteArrayList<ListenerHandle>)this.lists.get(handle.type);
        if (list == null && (list = (List)this.lists.putIfAbsent(handle.type, newList = new CopyOnWriteArrayList<ListenerHandle>())) == null) {
            list = newList;
        }
        list.add(handle);
    }

    void remove(ListenerHandle handle) {
        List list = (List)this.lists.get(handle.type);
        if (list != null) {
            list.remove(handle);
        }
    }
}

