/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.nebula.jgit.internal.ketch;

import com.netflix.nebula.jgit.annotations.Nullable;
import com.netflix.nebula.jgit.errors.NotSupportedException;
import com.netflix.nebula.jgit.errors.TransportException;
import com.netflix.nebula.jgit.internal.ketch.KetchLeader;
import com.netflix.nebula.jgit.internal.ketch.KetchReplica;
import com.netflix.nebula.jgit.internal.ketch.ReplicaConfig;
import com.netflix.nebula.jgit.internal.ketch.ReplicaFetchRequest;
import com.netflix.nebula.jgit.internal.ketch.ReplicaPushRequest;
import com.netflix.nebula.jgit.lib.AnyObjectId;
import com.netflix.nebula.jgit.lib.NullProgressMonitor;
import com.netflix.nebula.jgit.lib.ObjectId;
import com.netflix.nebula.jgit.lib.ObjectIdRef;
import com.netflix.nebula.jgit.lib.Ref;
import com.netflix.nebula.jgit.lib.Repository;
import com.netflix.nebula.jgit.transport.FetchConnection;
import com.netflix.nebula.jgit.transport.PushConnection;
import com.netflix.nebula.jgit.transport.ReceiveCommand;
import com.netflix.nebula.jgit.transport.RemoteConfig;
import com.netflix.nebula.jgit.transport.RemoteRefUpdate;
import com.netflix.nebula.jgit.transport.Transport;
import com.netflix.nebula.jgit.transport.URIish;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RemoteGitReplica
extends KetchReplica {
    private final URIish uri;
    private final RemoteConfig remoteConfig;

    public RemoteGitReplica(KetchLeader leader, String name, URIish uri, ReplicaConfig cfg, @Nullable RemoteConfig rc) {
        super(leader, name, cfg);
        this.uri = uri;
        this.remoteConfig = rc;
    }

    public URIish getURI() {
        return this.uri;
    }

    @Nullable
    protected RemoteConfig getRemoteConfig() {
        return this.remoteConfig;
    }

    @Override
    protected String describeForLog() {
        return String.format("%s @ %s", this.getName(), this.getURI());
    }

    @Override
    protected void startPush(final ReplicaPushRequest req) {
        this.getSystem().getExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try (Repository git = RemoteGitReplica.this.getLeader().openRepository();){
                    try {
                        RemoteGitReplica.this.push(git, req);
                        req.done(git);
                    }
                    catch (Throwable err) {
                        req.setException(git, err);
                    }
                }
                catch (IOException err) {
                    req.setException(null, err);
                }
            }
        });
    }

    private void push(Repository repo, ReplicaPushRequest req) throws NotSupportedException, TransportException, IOException {
        Map<String, Ref> adv;
        List<RemoteCommand> cmds = RemoteGitReplica.asUpdateList(req.getCommands());
        try (Transport transport = Transport.open(repo, this.uri);){
            RemoteConfig rc = this.getRemoteConfig();
            if (rc != null) {
                transport.applyConfig(rc);
            }
            transport.setPushAtomic(true);
            adv = this.push(repo, transport, cmds);
        }
        for (RemoteCommand c : cmds) {
            c.copyStatusToResult();
        }
        req.setRefs(adv);
    }

    private Map<String, Ref> push(Repository git, Transport transport, List<RemoteCommand> cmds) throws IOException {
        Map<String, RemoteRefUpdate> updates = RemoteGitReplica.asUpdateMap(cmds);
        try (PushConnection connection = transport.openPush();){
            Map<String, Ref> adv = connection.getRefsMap();
            RemoteRefUpdate accepted = updates.get(this.getSystem().getTxnAccepted());
            if (accepted != null && !RemoteGitReplica.isExpectedValue(adv, accepted)) {
                RemoteGitReplica.abort(cmds);
                Map<String, Ref> map = adv;
                return map;
            }
            RemoteRefUpdate committed = updates.get(this.getSystem().getTxnCommitted());
            if (committed != null && !RemoteGitReplica.isExpectedValue(adv, committed)) {
                RemoteGitReplica.abort(cmds);
                Map<String, Ref> map = adv;
                return map;
            }
            if (committed != null && this.getCommitMethod() == KetchReplica.CommitMethod.ALL_REFS) {
                this.prepareCommit(git, cmds, updates, adv, committed.getNewObjectId());
            }
            connection.push(NullProgressMonitor.INSTANCE, updates);
            Map<String, Ref> map = adv;
            return map;
        }
    }

    private static boolean isExpectedValue(Map<String, Ref> adv, RemoteRefUpdate u) {
        Ref r = adv.get(u.getRemoteName());
        if (!AnyObjectId.equals(RemoteGitReplica.getId(r), u.getExpectedOldObjectId())) {
            ((RemoteCommand)u).cmd.setResult(ReceiveCommand.Result.LOCK_FAILURE);
            return false;
        }
        return true;
    }

    private void prepareCommit(Repository git, List<RemoteCommand> cmds, Map<String, RemoteRefUpdate> updates, Map<String, Ref> adv, ObjectId committed) throws IOException {
        for (ReceiveCommand cmd : this.prepareCommit(git, adv, committed)) {
            RemoteCommand c = new RemoteCommand(cmd);
            cmds.add(c);
            updates.put(c.getRemoteName(), c);
        }
    }

    private static List<RemoteCommand> asUpdateList(Collection<ReceiveCommand> cmds) {
        try {
            ArrayList<RemoteCommand> toPush = new ArrayList<RemoteCommand>(cmds.size());
            for (ReceiveCommand cmd : cmds) {
                toPush.add(new RemoteCommand(cmd));
            }
            return toPush;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, RemoteRefUpdate> asUpdateMap(List<RemoteCommand> cmds) {
        LinkedHashMap<String, RemoteRefUpdate> m = new LinkedHashMap<String, RemoteRefUpdate>();
        for (RemoteCommand cmd : cmds) {
            m.put(cmd.getRemoteName(), cmd);
        }
        return m;
    }

    private static void abort(List<RemoteCommand> cmds) {
        ArrayList<ReceiveCommand> tmp = new ArrayList<ReceiveCommand>(cmds.size());
        for (RemoteCommand cmd : cmds) {
            tmp.add(cmd.cmd);
        }
        ReceiveCommand.abort(tmp);
    }

    @Override
    protected void blockingFetch(Repository repo, ReplicaFetchRequest req) throws NotSupportedException, TransportException {
        try (Transport transport = Transport.open(repo, this.uri);){
            RemoteConfig rc = this.getRemoteConfig();
            if (rc != null) {
                transport.applyConfig(rc);
            }
            this.fetch(transport, req);
        }
    }

    private void fetch(Transport transport, ReplicaFetchRequest req) throws NotSupportedException, TransportException {
        try (FetchConnection conn = transport.openFetch();){
            Map<String, Ref> remoteRefs = conn.getRefsMap();
            req.setRefs(remoteRefs);
            ArrayList<Ref> want = new ArrayList<Ref>();
            for (String name : req.getWantRefs()) {
                Ref ref = remoteRefs.get(name);
                if (ref == null || ref.getObjectId() == null) continue;
                want.add(ref);
            }
            for (ObjectId id : req.getWantObjects()) {
                want.add(new ObjectIdRef.Unpeeled(Ref.Storage.NETWORK, id.name(), id));
            }
            conn.fetch(NullProgressMonitor.INSTANCE, want, Collections.emptySet());
        }
    }

    static class RemoteCommand
    extends RemoteRefUpdate {
        final ReceiveCommand cmd;

        RemoteCommand(ReceiveCommand cmd) throws IOException {
            super(null, null, cmd.getNewId(), cmd.getRefName(), true, null, cmd.getOldId());
            this.cmd = cmd;
        }

        void copyStatusToResult() {
            if (this.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
                switch (this.getStatus()) {
                    case OK: 
                    case UP_TO_DATE: 
                    case NON_EXISTING: {
                        this.cmd.setResult(ReceiveCommand.Result.OK);
                        break;
                    }
                    case REJECTED_NODELETE: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_NODELETE);
                        break;
                    }
                    case REJECTED_NONFASTFORWARD: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD);
                        break;
                    }
                    case REJECTED_OTHER_REASON: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, this.getMessage());
                        break;
                    }
                    default: {
                        this.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, this.getStatus().name());
                    }
                }
            }
        }
    }
}

